# CCMv2 Certificate Auto-Update Script

## Overview
The `cert_refresh.sh` script automates the process of downloading and updating CCMv2 root certificates from Cloudera's exposed endpoints across multiple regions (US, EU, and AP). It handles certificate validation, configuration updates, service restarts, and automatic rollback on failure.

## Key Features
- Automatic certificate download from console-domain-specific endpoints
- Automatic SHA256 checksum verification based on region (us-west-1, eu-1, ap-1)
- Certificate format validation using OpenSSL
- Optional `--insecure` flag to skip checksum verification for unknown regions
- Automatic backup creation before updates
- Service health validation after updates
- Automatic rollback on failures

## Prerequisites

### System Requirements
- Root access required
- Internet connectivity to Cloudera CCM endpoints

### Required Tools
The script will verify these are installed:
- `curl` - For downloading certificates
- `openssl` - For certificate validation
- `awk` - For config file parsing
- `systemctl` (or `service` for older systems) - For service management

---


## Installation

### Step 1: Copy Script to Target Node

```bash
# Copy script to the node
scp ccm_cert_refresh.sh root@<node-ip>:/tmp/

# SSH to the node
ssh root@<node-ip>
```
### Step 2: Make Script Executable

```bash
cd /tmp
chmod +x ccm_cert_refresh.sh

```

### Step 3: Install Dependencies (if needed)

```bash
# Install dependencies (CentOS/RHEL)
yum install -y openssl curl gawk

# Verify installations
openssl version
curl --version
awk --version
```
---

## Usage

### Basic Command Format

```bash
./ccm_cert_refresh.sh <command> [console_domain]
```

### Available Commands
#### Update Certificate
Updates the CCMv2 certificate for a specified console_domain. The script automatically verifies the certificate checksum for known regions.

```bash
# Update certificate with automatic checksum verification (us-west-1, eu-1, ap-1)
./ccm_cert_refresh.sh update https://console.us-west-1.cdp.cloudera.com

# Update certificate without checksum verification (for unknown regions)
./ccm_cert_refresh.sh update https://console.us-west-1.cdp.cloudera.com --insecure
```

**Certificate Checksum Verification:**
- The script automatically determines the expected SHA256 checksum based on the region extracted from the console domain
- Supported regions with automatic verification: `us-west-1`, `eu-1`, `ap-1`
- For unknown regions, the script will fail unless `--insecure` flag is explicitly provided
- Use the `--insecure` flag to explicitly skip checksum verification for unknown regions

#### List Available Backups
Shows all configuration backups that have been created.

```bash
./ccm_cert_refresh.sh list-backups
```

#### Show Help
Displays usage information and available regions.

```bash
./ccm_cert_refresh.sh help
# or
./ccm_cert_refresh.sh --help
# or
./ccm_cert_refresh.sh -h
```

### After Running the Script
Once the script completes successfully, test cluster connectivity from public cloud:

```bash
curl --location '{{host}}/api/v1/onpremises/checkClusterConnectivity' \
--header 'Cookie: cdp-session-token={{token}}' \
--header 'Content-Type: application/json' \
--data '{
    "clusterCrn": "{{clusterCrn}}",
    "serviceName": "CM"
}'
```

#### Replace the placeholders:
- {{host}} - Your CDP control plane endpoint
- {{token}} - Your CDP session token
- {{clusterCrn}} - Your cluster CRN

---

## What the Script Does

### 1. Pre-flight Checks

The script performs several validation steps before making any changes:

- Verifies root access
- Checks all required dependencies are installed (`curl`, `openssl`, `awk`, `systemctl`)
- Validates `config.toml` file exists at `/etc/jumpgate/config.toml`
- Verifies script integrity using SHA256 checksum
- Extracts region from console domain and determines expected certificate checksum
- Checks if `jumpgate-agent` service is running

### 2. Certificate Download & Comparison Prep

The script downloads the certificate from the region-specific endpoint and prepares it for comparison:

- Downloads certificate using `curl` with timeout settings
- Implements retry logic (3 attempts with 2-second delays between retries)
- Validates download was successful and file is not empty
- Performs checksum verification on the raw download (security check)
- Normalizes certificate content (removes Windows line endings and blank lines to match config format)
- Uses connection timeout (10 seconds) and max timeout (30 seconds)
- Calculates SHA256 checksum of the downloaded certificate
- Compares with expected checksum based on region (if region is known and `--insecure` is not set)
- Uses connection timeout (10 seconds) and max timeout (30 seconds)
- Stores certificate temporarily in `/tmp/ccmv2_cert_auto_update/`

### 3. Certificate Validation

Before applying any changes, the script validates the certificate:

- SHA256 checksum verification (if region is known and `--insecure` is not set)
- Validates certificate format using OpenSSL
- Extracts and displays certificate expiry date and SHA256 fingerprint(s)
- Ensures certificate is valid PEM format
- Fails if checksum mismatch, invalid format, or corrupted certificate

### 4. Configuration Backup

The script creates a backup before making any changes:

- Creates timestamped backup: `config.toml.backup.YYYYMMDD_HHMMSS`
- Stores backups in `/etc/jumpgate/backup/` directory
- Preserves original file permissions (644)
- Backup path is saved for potential rollback

### 5. Configuration Update (Only When Needed)

The script updates the CCMv2 configuration:

- Extracts the current `relayServerCertificate` from `config.toml`, normalizes it with the same logic used for the downloaded certificate, and compares certificate fingerprints (order-independent) to ensure the same set of certs exists regardless of chain ordering
- Skips the rest of the update if the existing certificate is already identical (no restart or backup needed)
- Parses `config.toml` using AWK
- Locates the `relayServerCertificate` field
- Replaces the certificate content with the new certificate
- Maintains all other configuration keys unchanged
- Sets proper file permissions (644) on updated config

### 6. Service Restart

The script restarts the CCMv2 agent service:

- Detects OS version (CentOS 6 vs 7+) for correct command
- Restarts `jumpgate-agent` service using `systemctl` or `service`
- Waits 3 seconds for service to stabilize
- Verifies service is running after restart
- Displays service status output

### 7. Service Validation

After restart, the script validates the service is healthy:

- Waits 10 seconds for full startup
- Checks if service is active and running
- Scans service logs for errors (last 1 minute)
- Counts error messages in logs
- Fails validation if errors are detected

### 8. Automatic Rollback

If any step fails, the script automatically rolls back:

- Restores configuration from the timestamped backup
- Restarts service with previous configuration
- Logs rollback status and reason
- Exits with error code

### 9. Cleanup

After successful or failed execution:

- Removes temporary directory `/tmp/ccmv2_cert_auto_update/`
- Keeps backup files in `/etc/jumpgate/backup/`
- Logs all operations to `/var/log/ccmv2_cert_auto_update.log`

---

## File Locations

| File/Directory | Location | Purpose |
|----------------|----------|---------|
| Config File | `/etc/jumpgate/config.toml` | Main CCMv2 configuration |
| Backup Directory | `/etc/jumpgate/backup/` | Timestamped configuration backups |
| Log File | `/var/log/ccmv2_cert_auto_update.log` | Script execution logs |
| Temp Directory | `/tmp/ccmv2_cert_auto_update/` | Temporary certificate download location |
| Service Logs | `/var/log/jumpgate/out.log` | jumpgate-agent service logs (CentOS 6) |
| Service Logs | `journalctl -u jumpgate-agent.service` | jumpgate-agent service logs (CentOS 7+) |

---
