/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hadoop.config;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class RangerLegacyConfigBuilder {
    private static final Logger LOG = Logger.getLogger(RangerLegacyConfigBuilder.class);

    public static Configuration getSecurityConfig(String serviceType) {
        Configuration ret = null;
        Configuration legacyConfig = new Configuration();
        String legacyResource = RangerLegacyConfigBuilder.getPropertyName("xasecure-<ServiceType>-security.xml", serviceType);
        URL legacyFileUrl = RangerLegacyConfigBuilder.getFileURL(legacyResource);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> getSecurityConfig() " + legacyResource + " FileName: " + legacyFileUrl));
        }
        if (legacyFileUrl != null) {
            legacyConfig.addResource(legacyFileUrl);
            Configuration rangerDefaultProp = RangerLegacyConfigBuilder.buildRangerSecurityConf(serviceType);
            ret = RangerLegacyConfigBuilder.mapLegacyConfigToRanger(rangerDefaultProp, legacyConfig, serviceType);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== getSecurityConfig() " + legacyResource + " FileName: " + legacyFileUrl));
        }
        return ret;
    }

    public static URL getAuditConfig(String serviceType) throws Throwable {
        URL ret = null;
        String legacyResource = RangerLegacyConfigBuilder.getPropertyName("xasecure-audit.xml", serviceType);
        ret = RangerLegacyConfigBuilder.getAuditResource(legacyResource);
        return ret;
    }

    public static URL getSSLConfig(String serviceType) throws Throwable {
        URL ret = null;
        String legacyResource = RangerLegacyConfigBuilder.getPropertyName("/etc/<ServiceType>/conf/xasecure-policymgr-ssl.xml", serviceType);
        ret = RangerLegacyConfigBuilder.getSSLResource(legacyResource);
        return ret;
    }

    public static String getPropertyName(String rangerProp, String serviceType) {
        return rangerProp.replace("<ServiceType>", serviceType);
    }

    private static Configuration mapLegacyConfigToRanger(Configuration rangerInConf, Configuration legacyConf, String serviceType) {
        Configuration ret = rangerInConf;
        HashMap<String, String> chgMap = RangerLegacyConfigBuilder.getConfigChangeMap(serviceType);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== mapLegacyConfigToRanger() MAP Size:  " + chgMap.size()));
        }
        for (Map.Entry<String, String> entry : chgMap.entrySet()) {
            String legacyKey = entry.getKey();
            String rangerKey = entry.getValue();
            String legacyConfVal = null;
            if (rangerKey.equals(RangerLegacyConfigBuilder.getPropertyName("ranger.plugin.<ServiceType>.service.name", serviceType))) {
                String serviceURL = legacyConf.get(RangerLegacyConfigBuilder.getPropertyName("xasecure.<ServiceType>.policymgr.url", serviceType));
                legacyConfVal = RangerLegacyConfigBuilder.fetchLegacyValue(serviceURL, rangerKey, serviceType);
            } else {
                legacyConfVal = rangerKey.equals(RangerLegacyConfigBuilder.getPropertyName("ranger.plugin.<ServiceType>.policy.rest.url", serviceType)) || rangerKey.equals(RangerLegacyConfigBuilder.getPropertyName("ranger.plugin.<ServiceType>.policy.cache.dir", serviceType)) ? RangerLegacyConfigBuilder.fetchLegacyValue(legacyConf.get(legacyKey), rangerKey, serviceType) : legacyConf.get(legacyKey);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("<== mapLegacyConfigToRanger() Ranger Key: " + rangerKey + "Legacy Key:" + legacyKey + "Legacy Value:" + legacyConfVal));
            }
            ret.set(rangerKey, legacyConfVal);
        }
        return ret;
    }

    public static URL getAuditResource(String fName) throws Throwable {
        URL ret = null;
        try {
            File f;
            String loc = RangerLegacyConfigBuilder.getFileLocation(fName);
            if (loc != null && (f = new File(loc)).exists() && f.canRead()) {
                File parentFile = new File(loc).getParentFile();
                ret = new File(parentFile, "xasecure-audit.xml").toURI().toURL();
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"Missing Ranger Audit configuration files...");
            throw t;
        }
        return ret;
    }

    public static URL getSSLResource(String fName) throws Throwable {
        URL ret = null;
        try {
            File f;
            String loc = RangerLegacyConfigBuilder.getFileLocation(fName);
            if (loc != null && (f = new File(loc)).exists() && f.canRead()) {
                File parentFile = new File(loc).getParentFile();
                ret = new File(parentFile, "/etc/<ServiceType>/conf/xasecure-policymgr-ssl.xml").toURI().toURL();
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"Missing Ranger SSL configuration files...");
            throw t;
        }
        return ret;
    }

    private static Configuration buildRangerSecurityConf(String serviceType) {
        Configuration rangerConf = new Configuration();
        rangerConf.set(RangerLegacyConfigBuilder.getPropertyName("ranger.plugin.<ServiceType>.service.name", serviceType), "");
        if ("knox".equals(serviceType)) {
            rangerConf.set(RangerLegacyConfigBuilder.getPropertyName("ranger.plugin.<ServiceType>.policy.source.impl", serviceType), "org.apache.ranger.admin.client.RangerAdminJersey2RESTClient");
        } else {
            rangerConf.set(RangerLegacyConfigBuilder.getPropertyName("ranger.plugin.<ServiceType>.policy.source.impl", serviceType), "");
        }
        rangerConf.set(RangerLegacyConfigBuilder.getPropertyName("ranger.plugin.<ServiceType>.policy.rest.url", serviceType), "");
        rangerConf.set(RangerLegacyConfigBuilder.getPropertyName("ranger.plugin.<ServiceType>.policy.rest.ssl.config.file", serviceType), RangerLegacyConfigBuilder.getPropertyName("/etc/<ServiceType>/conf/xasecure-policymgr-ssl.xml", serviceType));
        rangerConf.set(RangerLegacyConfigBuilder.getPropertyName("ranger.plugin.<ServiceType>.policy.pollIntervalMs", serviceType), "");
        rangerConf.set(RangerLegacyConfigBuilder.getPropertyName("ranger.plugin.<ServiceType>.policy.cache.dir", serviceType), "");
        rangerConf.set("xasecure.add-hadoop-authorization", "");
        return rangerConf;
    }

    private static HashMap<String, String> getConfigChangeMap(String serviceType) {
        HashMap<String, String> changeMap = new HashMap<String, String>();
        changeMap.put(serviceType, RangerLegacyConfigBuilder.getPropertyName("ranger.plugin.<ServiceType>.service.name", serviceType));
        changeMap.put(RangerLegacyConfigBuilder.getPropertyName("xasecure.<ServiceType>.policymgr.url", serviceType), RangerLegacyConfigBuilder.getPropertyName("ranger.plugin.<ServiceType>.policy.rest.url", serviceType));
        changeMap.put(RangerLegacyConfigBuilder.getPropertyName("xasecure.<ServiceType>.policymgr.url.reloadIntervalInMillis", serviceType), RangerLegacyConfigBuilder.getPropertyName("ranger.plugin.<ServiceType>.policy.pollIntervalMs", serviceType));
        changeMap.put(RangerLegacyConfigBuilder.getPropertyName("xasecure.<ServiceType>.policymgr.url.laststoredfile", serviceType), RangerLegacyConfigBuilder.getPropertyName("ranger.plugin.<ServiceType>.policy.cache.dir", serviceType));
        if ("hdfs".equals(serviceType)) {
            changeMap.put("xasecure.add-hadoop-authorization", "xasecure.add-hadoop-authorization");
        }
        if ("hbase".equals(serviceType) || "hive".equals(serviceType)) {
            changeMap.put(RangerLegacyConfigBuilder.getPropertyName("xasecure.<ServiceType>.update.xapolicies.on.grant.revoke", serviceType), RangerLegacyConfigBuilder.getPropertyName("xasecure.<ServiceType>.update.xapolicies.on.grant.revoke", serviceType));
        }
        if (LOG.isDebugEnabled()) {
            for (Map.Entry entry : changeMap.entrySet()) {
                String legacyKey = (String)entry.getKey();
                String rangerKey = (String)entry.getValue();
                LOG.debug((Object)("<== getConfigChangeMap() RangerConfig Key: " + rangerKey + " Legacy Key: " + legacyKey));
            }
        }
        return changeMap;
    }

    private static String getFileLocation(String fileName) {
        String ret = null;
        URL lurl = RangerLegacyConfigBuilder.class.getClassLoader().getResource(fileName);
        if (lurl == null) {
            lurl = RangerLegacyConfigBuilder.class.getClassLoader().getResource("/" + fileName);
        }
        if (lurl != null) {
            ret = lurl.getFile();
        }
        return ret;
    }

    private static URL getFileURL(String fileName) {
        return RangerLegacyConfigBuilder.class.getClassLoader().getResource(fileName);
    }

    private static String getPolicyMgrURL(String url) {
        int index = url.indexOf("/", url.lastIndexOf(":"));
        return url.substring(0, index);
    }

    private static String getServiceNameFromURL(String url) {
        int index = url.lastIndexOf("/");
        return url.substring(index + 1);
    }

    private static String getCacheFileURL(String cacheFile) {
        int index = cacheFile.lastIndexOf("/");
        return cacheFile.substring(0, index);
    }

    private static String fetchLegacyValue(String legacyVal, String rangerKey, String serviceType) {
        String ret = null;
        if (rangerKey.equals(RangerLegacyConfigBuilder.getPropertyName("ranger.plugin.<ServiceType>.service.name", serviceType))) {
            ret = RangerLegacyConfigBuilder.getServiceNameFromURL(legacyVal);
        } else if (rangerKey.equals(RangerLegacyConfigBuilder.getPropertyName("ranger.plugin.<ServiceType>.policy.rest.url", serviceType))) {
            ret = RangerLegacyConfigBuilder.getPolicyMgrURL(legacyVal);
        } else if (rangerKey.equals(RangerLegacyConfigBuilder.getPropertyName("ranger.plugin.<ServiceType>.policy.cache.dir", serviceType))) {
            ret = RangerLegacyConfigBuilder.getCacheFileURL(legacyVal);
        }
        return ret;
    }
}

