/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.conditionevaluator;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.contextenricher.RangerTagForEval;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;

public final class RangerScriptExecutionContext {
    private static final Log LOG = LogFactory.getLog(RangerScriptExecutionContext.class);
    private static final String TAG_ATTR_DATE_FORMAT_PROP = "ranger.plugin.tag.attr.additional.date.formats";
    private static final String TAG_ATTR_DATE_FORMAT_SEPARATOR = "||";
    private static final String TAG_ATTR_DATE_FORMAT_SEPARATOR_REGEX = "\\|\\|";
    private static final String DEFAULT_RANGER_TAG_ATTRIBUTE_DATE_FORMAT = "yyyy/MM/dd";
    private static final String DEFAULT_ATLAS_TAG_ATTRIBUTE_DATE_FORMAT_NAME = "ATLAS_DATE_FORMAT";
    private static final String DEFAULT_ATLAS_TAG_ATTRIBUTE_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private final RangerAccessRequest accessRequest;
    private Boolean result = false;
    private static String[] dateFormatStrings = null;
    private static final ThreadLocal<List<SimpleDateFormat>> THREADLOCAL_DATE_FORMATS;

    RangerScriptExecutionContext(RangerAccessRequest accessRequest) {
        this.accessRequest = accessRequest;
    }

    public static void init(Configuration config) {
        String additionalDateFormatsValue;
        StringBuilder sb = new StringBuilder(DEFAULT_RANGER_TAG_ATTRIBUTE_DATE_FORMAT);
        sb.append(TAG_ATTR_DATE_FORMAT_SEPARATOR).append(DEFAULT_ATLAS_TAG_ATTRIBUTE_DATE_FORMAT_NAME);
        String string = additionalDateFormatsValue = config != null ? config.get(TAG_ATTR_DATE_FORMAT_PROP) : null;
        if (StringUtils.isNotBlank((String)additionalDateFormatsValue)) {
            sb.append(TAG_ATTR_DATE_FORMAT_SEPARATOR).append(additionalDateFormatsValue);
        }
        String[] formatStrings = sb.toString().split(TAG_ATTR_DATE_FORMAT_SEPARATOR_REGEX);
        Arrays.sort(formatStrings, new Comparator<String>(){

            @Override
            public int compare(String first, String second) {
                return Integer.compare(second.length(), first.length());
            }
        });
        dateFormatStrings = formatStrings;
    }

    public String getResource() {
        String ret = null;
        RangerAccessResource val = RangerAccessRequestUtil.getCurrentResourceFromContext(this.getRequestContext());
        if (val != null) {
            ret = val.getAsString();
        }
        return ret;
    }

    public Map<String, Object> getRequestContext() {
        return this.accessRequest.getContext();
    }

    public String getRequestContextAttribute(String attributeName) {
        Object val;
        String ret = null;
        if (StringUtils.isNotBlank((String)attributeName) && (val = this.getRequestContext().get(attributeName)) != null) {
            ret = val.toString();
        }
        return ret;
    }

    public boolean isAccessTypeAny() {
        return this.accessRequest.isAccessTypeAny();
    }

    public boolean isAccessTypeDelegatedAdmin() {
        return this.accessRequest.isAccessTypeDelegatedAdmin();
    }

    public String getUser() {
        return this.accessRequest.getUser();
    }

    public Set<String> getUserGroups() {
        return this.accessRequest.getUserGroups();
    }

    public Date getAccessTime() {
        return this.accessRequest.getAccessTime() != null ? this.accessRequest.getAccessTime() : new Date();
    }

    public String getClientIPAddress() {
        return this.accessRequest.getClientIPAddress();
    }

    public String getClientType() {
        return this.accessRequest.getClientType();
    }

    public String getAction() {
        return this.accessRequest.getAction();
    }

    public String getRequestData() {
        return this.accessRequest.getRequestData();
    }

    public String getSessionId() {
        return this.accessRequest.getSessionId();
    }

    public RangerTagForEval getCurrentTag() {
        RangerTagForEval ret = RangerAccessRequestUtil.getCurrentTagFromContext(this.getRequestContext());
        if (ret == null && LOG.isDebugEnabled()) {
            LOG.debug((Object)"getCurrentTag() - No current TAG object. Script execution must be for resource-based policy.");
        }
        return ret;
    }

    public String getCurrentTagType() {
        RangerTagForEval tagObject = this.getCurrentTag();
        return tagObject != null ? tagObject.getType() : null;
    }

    public Set<String> getAllTagTypes() {
        HashSet<String> allTagTypes = null;
        Set<RangerTagForEval> tagObjectList = this.getAllTags();
        if (CollectionUtils.isNotEmpty(tagObjectList)) {
            for (RangerTagForEval tag : tagObjectList) {
                String tagType = tag.getType();
                if (allTagTypes == null) {
                    allTagTypes = new HashSet<String>();
                }
                allTagTypes.add(tagType);
            }
        }
        return allTagTypes;
    }

    public Map<String, String> getTagAttributes(String tagType) {
        Set<RangerTagForEval> tagObjectList;
        Map<String, String> ret = null;
        if (StringUtils.isNotBlank((String)tagType) && CollectionUtils.isNotEmpty(tagObjectList = this.getAllTags())) {
            for (RangerTagForEval tag : tagObjectList) {
                if (!tag.getType().equals(tagType)) continue;
                ret = tag.getAttributes();
                break;
            }
        }
        return ret;
    }

    public List<Map<String, String>> getTagAttributesForAllMatchingTags(String tagType) {
        Set<RangerTagForEval> tagObjectList;
        ArrayList<Map<String, String>> ret = null;
        if (StringUtils.isNotBlank((String)tagType) && CollectionUtils.isNotEmpty(tagObjectList = this.getAllTags())) {
            for (RangerTagForEval tag : tagObjectList) {
                if (!tag.getType().equals(tagType)) continue;
                Map<String, String> tagAttributes = tag.getAttributes();
                if (tagAttributes == null) break;
                if (ret == null) {
                    ret = new ArrayList<Map<String, String>>();
                }
                ret.add(tagAttributes);
                break;
            }
        }
        return ret;
    }

    public Set<String> getAttributeNames(String tagType) {
        Set<String> ret = null;
        Map<String, String> attributes = this.getTagAttributes(tagType);
        if (attributes != null) {
            ret = attributes.keySet();
        }
        return ret;
    }

    public String getAttributeValue(String tagType, String attributeName) {
        Map<String, String> attributes;
        String ret = null;
        if ((StringUtils.isNotBlank((String)tagType) || StringUtils.isNotBlank((String)attributeName)) && (attributes = this.getTagAttributes(tagType)) != null) {
            ret = attributes.get(attributeName);
        }
        return ret;
    }

    public List<String> getAttributeValueForAllMatchingTags(String tagType, String attributeName) {
        Map<String, String> attributes;
        ArrayList<String> ret = null;
        if ((StringUtils.isNotBlank((String)tagType) || StringUtils.isNotBlank((String)attributeName)) && (attributes = this.getTagAttributes(tagType)) != null && attributes.get(attributeName) != null) {
            if (ret == null) {
                ret = new ArrayList<String>();
            }
            ret.add(attributes.get(attributeName));
        }
        return ret;
    }

    public String getAttributeValue(String attributeName) {
        String ret = null;
        if (StringUtils.isNotBlank((String)attributeName)) {
            RangerTagForEval tag = this.getCurrentTag();
            Map<String, String> attributes = null;
            if (tag != null) {
                attributes = tag.getAttributes();
            }
            if (attributes != null) {
                ret = attributes.get(attributeName);
            }
        }
        return ret;
    }

    public boolean getResult() {
        return this.result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date getAsDate(String value, SimpleDateFormat df) {
        Date ret = null;
        TimeZone savedTimeZone = df.getTimeZone();
        try {
            ret = df.parse(value);
        }
        catch (ParseException parseException) {
        }
        finally {
            df.setTimeZone(savedTimeZone);
        }
        return ret;
    }

    public Date getAsDate(String value) {
        Date ret = null;
        if (StringUtils.isNotBlank((String)value)) {
            for (SimpleDateFormat simpleDateFormat : THREADLOCAL_DATE_FORMATS.get()) {
                ret = this.getAsDate(value, simpleDateFormat);
                if (ret == null) continue;
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)("The best match found for Format-String:[" + simpleDateFormat.toPattern() + "], date:[" + ret + "]"));
                break;
            }
        }
        if (ret == null) {
            LOG.error((Object)("RangerScriptExecutionContext.getAsDate() - Could not convert [" + value + "] to Date using any of the Format-Strings: " + Arrays.toString(dateFormatStrings)));
        } else {
            ret = StringUtil.getUTCDateForLocalDate(ret);
        }
        return ret;
    }

    public Date getTagAttributeAsDate(String tagType, String attributeName) {
        String attrValue = this.getAttributeValue(tagType, attributeName);
        return this.getAsDate(attrValue);
    }

    public boolean isAccessedAfter(String tagType, String attributeName) {
        boolean ret = false;
        Date accessDate = this.getAccessTime();
        Date expiryDate = this.getTagAttributeAsDate(tagType, attributeName);
        if (expiryDate == null || accessDate.after(expiryDate) || accessDate.equals(expiryDate)) {
            ret = true;
        }
        return ret;
    }

    public boolean isAccessedAfter(String attributeName) {
        boolean ret = false;
        Date accessDate = this.getAccessTime();
        Date expiryDate = this.getAsDate(this.getAttributeValue(attributeName));
        if (expiryDate == null || accessDate.after(expiryDate) || accessDate.equals(expiryDate)) {
            ret = true;
        }
        return ret;
    }

    public boolean isAccessedBefore(String tagType, String attributeName) {
        boolean ret = true;
        Date accessDate = this.getAccessTime();
        Date expiryDate = this.getTagAttributeAsDate(tagType, attributeName);
        if (expiryDate == null || accessDate.after(expiryDate)) {
            ret = false;
        }
        return ret;
    }

    public boolean isAccessedBefore(String attributeName) {
        boolean ret = true;
        Date accessDate = this.getAccessTime();
        Date expiryDate = this.getAsDate(this.getAttributeValue(attributeName));
        if (expiryDate == null || accessDate.after(expiryDate)) {
            ret = false;
        }
        return ret;
    }

    private Set<RangerTagForEval> getAllTags() {
        Set<RangerTagForEval> ret = RangerAccessRequestUtil.getRequestTagsFromContext(this.accessRequest.getContext());
        if (ret == null && LOG.isDebugEnabled()) {
            String resource = this.accessRequest.getResource().getAsString();
            LOG.debug((Object)("getAllTags() - No TAGS. No TAGS for the RangerAccessResource=" + resource));
        }
        return ret;
    }

    public void logDebug(Object msg) {
        LOG.debug(msg);
    }

    public void logInfo(Object msg) {
        LOG.info(msg);
    }

    public void logWarn(Object msg) {
        LOG.warn(msg);
    }

    public void logError(Object msg) {
        LOG.error(msg);
    }

    public void logFatal(Object msg) {
        LOG.fatal(msg);
    }

    static {
        RangerScriptExecutionContext.init(null);
        THREADLOCAL_DATE_FORMATS = new ThreadLocal<List<SimpleDateFormat>>(){

            @Override
            protected List<SimpleDateFormat> initialValue() {
                ArrayList<SimpleDateFormat> ret = new ArrayList<SimpleDateFormat>();
                for (String dateFormatString : dateFormatStrings) {
                    try {
                        if (!StringUtils.isNotBlank((String)dateFormatString)) continue;
                        if (StringUtils.equalsIgnoreCase((String)dateFormatString, (String)RangerScriptExecutionContext.DEFAULT_ATLAS_TAG_ATTRIBUTE_DATE_FORMAT_NAME)) {
                            dateFormatString = RangerScriptExecutionContext.DEFAULT_ATLAS_TAG_ATTRIBUTE_DATE_FORMAT;
                        }
                        SimpleDateFormat df = new SimpleDateFormat(dateFormatString);
                        df.setLenient(false);
                        ret.add(df);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return ret;
            }
        };
    }
}

