/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.contextenricher;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.contextenricher.RangerUserStoreEnricher;
import org.apache.ranger.plugin.contextenricher.RangerUserStoreRetriever;
import org.apache.ranger.plugin.store.RangerUserStoreListener;
import org.apache.ranger.plugin.util.DownloadTrigger;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerServiceNotFoundException;
import org.apache.ranger.plugin.util.RangerUserStore;

public class RangerUserStoreRefresher
extends Thread {
    private static final Log LOG = LogFactory.getLog(RangerUserStoreRefresher.class);
    private static final Log PERF_REFRESHER_INIT_LOG = RangerPerfTracer.getPerfLogger("userstore.init");
    private final RangerUserStoreRetriever userStoreRetriever;
    private final RangerUserStoreEnricher userStoreEnricher;
    private long lastKnownVersion;
    private final BlockingQueue<DownloadTrigger> userStoreDownloadQueue;
    private long lastActivationTimeInMillis;
    private final String cacheFile;
    private boolean hasProvidedUserStoreToReceiver;
    private Gson gson;
    private static Set<RangerUserStoreListener> listeners = new HashSet<RangerUserStoreListener>();

    public RangerUserStoreRefresher(RangerUserStoreRetriever userStoreRetriever, RangerUserStoreEnricher userStoreEnricher, RangerUserStoreListener rangerUserStoreListener, long lastKnownVersion, BlockingQueue<DownloadTrigger> userStoreDownloadQueue, String cacheFile) {
        this.userStoreRetriever = userStoreRetriever;
        this.userStoreEnricher = userStoreEnricher;
        this.lastKnownVersion = lastKnownVersion;
        this.userStoreDownloadQueue = userStoreDownloadQueue;
        this.cacheFile = cacheFile;
        this.registerUserStoreChangeListener(rangerUserStoreListener);
        try {
            this.gson = new GsonBuilder().setDateFormat("yyyyMMdd-HH:mm:ss.SSS-Z").create();
        }
        catch (Throwable excp) {
            LOG.fatal((Object)"failed to create GsonBuilder object", excp);
        }
        this.setName("RangerUserStoreRefresher(serviceName=" + userStoreRetriever.getServiceName() + ")-" + this.getId());
    }

    public long getLastActivationTimeInMillis() {
        return this.lastActivationTimeInMillis;
    }

    public void setLastActivationTimeInMillis(long lastActivationTimeInMillis) {
        this.lastActivationTimeInMillis = lastActivationTimeInMillis;
    }

    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerUserStoreRefresher().run()");
        }
        while (true) {
            DownloadTrigger trigger = null;
            try {
                RangerPerfTracer perf = null;
                if (RangerPerfTracer.isPerfTraceEnabled(PERF_REFRESHER_INIT_LOG)) {
                    perf = RangerPerfTracer.getPerfTracer(PERF_REFRESHER_INIT_LOG, "RangerUserStoreRefresher.run(lastKnownVersion=" + this.lastKnownVersion + ")");
                }
                trigger = this.userStoreDownloadQueue.take();
                this.populateUserStoreInfo();
                RangerPerfTracer.log(perf);
                continue;
            }
            catch (InterruptedException excp) {
                LOG.debug((Object)"RangerUserStoreRefresher().run() : interrupted! Exiting thread", (Throwable)excp);
            }
            finally {
                if (trigger == null) continue;
                trigger.signalCompletion();
                continue;
            }
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerUserStoreRefresher().run()");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void populateUserStoreInfo() throws InterruptedException {
        RangerUserStore rangerUserStore = null;
        if (this.userStoreEnricher != null && this.userStoreRetriever != null) {
            try {
                rangerUserStore = this.userStoreRetriever.retrieveUserStoreInfo(this.lastKnownVersion, this.lastActivationTimeInMillis);
                if (rangerUserStore == null && !this.hasProvidedUserStoreToReceiver) {
                    rangerUserStore = this.loadFromCache();
                }
                if (rangerUserStore != null) {
                    this.userStoreEnricher.setRangerUserStore(rangerUserStore);
                    if (rangerUserStore.getUserStoreVersion() != -1L) {
                        this.saveToCache(rangerUserStore);
                    }
                    LOG.info((Object)("RangerUserStoreRefresher.populateUserStoreInfo() - Updated userstore-cache to new version, lastKnownVersion=" + this.lastKnownVersion + "; newVersion=" + (rangerUserStore.getUserStoreVersion() == null ? -1L : rangerUserStore.getUserStoreVersion())));
                    this.hasProvidedUserStoreToReceiver = true;
                    this.lastKnownVersion = rangerUserStore.getUserStoreVersion() == null ? -1L : rangerUserStore.getUserStoreVersion();
                    this.setLastActivationTimeInMillis(System.currentTimeMillis());
                    return;
                }
                if (!LOG.isDebugEnabled()) return;
                LOG.debug((Object)("RangerUserStoreRefresher.populateUserStoreInfo() - No need to update userstore-cache. lastKnownVersion=" + this.lastKnownVersion));
                return;
            }
            catch (RangerServiceNotFoundException snfe) {
                LOG.error((Object)"Caught ServiceNotFound exception :", (Throwable)snfe);
                if (!this.userStoreEnricher.isDisableCacheIfServiceNotFound()) return;
                this.disableCache();
                this.setLastActivationTimeInMillis(System.currentTimeMillis());
                this.lastKnownVersion = -1L;
                return;
            }
            catch (InterruptedException interruptedException) {
                throw interruptedException;
            }
            catch (Exception e) {
                LOG.error((Object)"Encountered unexpected exception. Ignoring", (Throwable)e);
                return;
            }
        } else if (this.userStoreRetriever != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"RangerUserStoreRefresher.populateUserStoreInfo() for Ranger Raz");
            }
            try {
                rangerUserStore = this.userStoreRetriever.retrieveUserStoreInfo(this.lastKnownVersion, this.lastActivationTimeInMillis);
                if (rangerUserStore == null && !this.hasProvidedUserStoreToReceiver) {
                    rangerUserStore = this.loadFromCache();
                }
                if (rangerUserStore != null) {
                    for (RangerUserStoreListener listner : listeners) {
                        LOG.info((Object)("Updating userstore info for " + listner.getClass()));
                        listner.updateRangerUserStore(rangerUserStore);
                    }
                    if (rangerUserStore.getUserStoreVersion() != -1L) {
                        this.saveToCache(rangerUserStore);
                    }
                    LOG.info((Object)("RangerUserStoreRefresher.populateUserStoreInfo() - Updated userstore-cache for raz to new version, lastKnownVersion=" + this.lastKnownVersion + "; newVersion=" + (rangerUserStore.getUserStoreVersion() == null ? -1L : rangerUserStore.getUserStoreVersion())));
                    this.hasProvidedUserStoreToReceiver = true;
                    this.lastKnownVersion = rangerUserStore.getUserStoreVersion() == null ? -1L : rangerUserStore.getUserStoreVersion();
                    this.setLastActivationTimeInMillis(System.currentTimeMillis());
                    return;
                }
                if (!LOG.isDebugEnabled()) return;
                LOG.debug((Object)("RangerUserStoreRefresher.populateUserStoreInfo() - No need to update userstore-cache for raz. lastKnownVersion=" + this.lastKnownVersion));
                return;
            }
            catch (InterruptedException interruptedException) {
                throw interruptedException;
            }
            catch (Exception e) {
                LOG.error((Object)"Encountered unexpected exception. Ignoring", (Throwable)e);
                return;
            }
        } else {
            LOG.error((Object)"RangerUserStoreRefresher.populateUserStoreInfo() - no userstore receiver to update userstore-cache");
        }
    }

    public void cleanup() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerUserStoreRefresher.cleanup()");
        }
        this.stopRefresher();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerUserStoreRefresher.cleanup()");
        }
    }

    public void startRefresher() {
        try {
            super.start();
        }
        catch (Exception excp) {
            LOG.error((Object)("RangerUserStoreRefresher.startRetriever() - failed to start, exception=" + excp));
        }
    }

    public void stopRefresher() {
        if (super.isAlive()) {
            super.interrupt();
            boolean setInterrupted = false;
            boolean isJoined = false;
            while (!isJoined) {
                try {
                    super.join();
                    isJoined = true;
                }
                catch (InterruptedException excp) {
                    LOG.warn((Object)"RangerUserStoreRefresher(): Error while waiting for thread to exit", (Throwable)excp);
                    LOG.warn((Object)"Retrying Thread.join(), interrupted flag will be set after Thread.join() succeeds");
                    setInterrupted = true;
                }
            }
            if (setInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RangerUserStore loadFromCache() {
        File cacheFile;
        RangerUserStore rangerUserStore = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerUserStoreRefreher.loadFromCache()");
        }
        File file = cacheFile = StringUtils.isEmpty((String)this.cacheFile) ? null : new File(this.cacheFile);
        if (cacheFile != null && cacheFile.isFile() && cacheFile.canRead()) {
            FileReader reader = null;
            try {
                reader = new FileReader(cacheFile);
                rangerUserStore = (RangerUserStore)this.gson.fromJson((Reader)reader, RangerUserStore.class);
            }
            catch (Exception excp) {
                LOG.error((Object)("failed to load userstore information from cache file " + cacheFile.getAbsolutePath()), (Throwable)excp);
            }
            finally {
                if (reader != null) {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Exception excp) {
                        LOG.error((Object)("error while closing opened cache file " + cacheFile.getAbsolutePath()), (Throwable)excp);
                    }
                }
            }
        } else {
            LOG.warn((Object)("cache file does not exist or not readable '" + (cacheFile == null ? null : cacheFile.getAbsolutePath()) + "'"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerUserStoreRefreher.loadFromCache()");
        }
        return rangerUserStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToCache(RangerUserStore rangerUserStore) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerUserStoreRefreher.saveToCache()");
        }
        if (rangerUserStore != null) {
            File cacheFile;
            File file = cacheFile = StringUtils.isEmpty((String)this.cacheFile) ? null : new File(this.cacheFile);
            if (cacheFile != null) {
                FileWriter writer = null;
                try {
                    writer = new FileWriter(cacheFile);
                    this.gson.toJson((Object)rangerUserStore, (Appendable)writer);
                }
                catch (Exception excp) {
                    LOG.error((Object)("failed to save userstore information to cache file '" + cacheFile.getAbsolutePath() + "'"), (Throwable)excp);
                }
                finally {
                    if (writer != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Exception excp) {
                            LOG.error((Object)("error while closing opened cache file '" + cacheFile.getAbsolutePath() + "'"), (Throwable)excp);
                        }
                    }
                }
            }
        } else {
            LOG.info((Object)"userstore information is null. Nothing to save in cache");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerUserStoreRefreher.saveToCache()");
        }
    }

    private void disableCache() {
        File cacheFile;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerUserStoreRefreher.disableCache()");
        }
        File file = cacheFile = StringUtils.isEmpty((String)this.cacheFile) ? null : new File(this.cacheFile);
        if (cacheFile != null && cacheFile.isFile() && cacheFile.canRead()) {
            LOG.warn((Object)"Cleaning up local userstore cache");
            String renamedCacheFile = cacheFile.getAbsolutePath() + "_" + System.currentTimeMillis();
            if (!cacheFile.renameTo(new File(renamedCacheFile))) {
                LOG.error((Object)("Failed to move " + cacheFile.getAbsolutePath() + " to " + renamedCacheFile));
            } else {
                LOG.warn((Object)("moved " + cacheFile.getAbsolutePath() + " to " + renamedCacheFile));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"No local userstore cache found. No need to disable it!");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerUserStoreRefreher.disableCache()");
        }
    }

    public void registerUserStoreChangeListener(RangerUserStoreListener listener) {
        if (listener != null) {
            listeners.add(listener);
        }
    }

    public void unRegisterUserStoreChangeListener(RangerUserStoreListener listener) {
        if (listener != null) {
            listeners.remove(listener);
        }
    }
}

