/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.contextenricher.RangerTagForEval;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.PolicyEngine;
import org.apache.ranger.plugin.policyengine.PolicyEvaluatorForTag;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestProcessor;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngine;
import org.apache.ranger.plugin.policyengine.RangerPolicyRepository;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.policyengine.RangerResourceAccessInfo;
import org.apache.ranger.plugin.policyengine.RangerTagAccessRequest;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.service.RangerDefaultRequestProcessor;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerReadWriteLock;
import org.apache.ranger.plugin.util.RangerRoles;
import org.apache.ranger.plugin.util.ServicePolicies;

public class RangerPolicyEngineImpl
implements RangerPolicyEngine {
    private static final Log LOG = LogFactory.getLog(RangerPolicyEngineImpl.class);
    private static final Log PERF_POLICYENGINE_REQUEST_LOG = RangerPerfTracer.getPerfLogger("policyengine.request");
    private static final Log PERF_POLICYENGINE_AUDIT_LOG = RangerPerfTracer.getPerfLogger("policyengine.audit");
    private static final Log PERF_POLICYENGINE_GET_ACLS_LOG = RangerPerfTracer.getPerfLogger("policyengine.getResourceACLs");
    private final PolicyEngine policyEngine;
    private final RangerAccessRequestProcessor requestProcessor;
    private final ServiceConfig serviceConfig;

    public static RangerPolicyEngine getPolicyEngine(RangerPolicyEngineImpl other, ServicePolicies servicePolicies) {
        PolicyEngine policyEngine;
        RangerPolicyEngineImpl ret = null;
        if (other != null && servicePolicies != null && (policyEngine = other.policyEngine.cloneWithDelta(servicePolicies)) != null) {
            ret = policyEngine == other.policyEngine ? other : new RangerPolicyEngineImpl(policyEngine, other);
        }
        return ret;
    }

    public RangerPolicyEngineImpl(ServicePolicies servicePolicies, RangerPluginContext pluginContext, RangerRoles roles) {
        boolean isDeltasSupported;
        RangerPluginConfig config;
        RangerPluginConfig rangerPluginConfig = config = pluginContext != null ? pluginContext.getConfig() : null;
        boolean isUseReadWriteLock = config != null ? (isDeltasSupported = config.getBoolean(pluginContext.getConfig().getPropertyPrefix() + ".supports.policy.deltas", true)) && config.getBoolean(pluginContext.getConfig().getPropertyPrefix() + ".supports.in.place.policy.updates", false) : false;
        this.policyEngine = new PolicyEngine(servicePolicies, pluginContext, roles, isUseReadWriteLock);
        this.serviceConfig = new ServiceConfig(servicePolicies.getServiceConfig());
        this.requestProcessor = new RangerDefaultRequestProcessor(this.policyEngine);
    }

    public String toString() {
        return this.policyEngine.toString();
    }

    @Override
    public RangerAccessResult evaluatePolicies(RangerAccessRequest request, int policyType, RangerAccessResultProcessor resultProcessor) {
        RangerAccessResult ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.evaluatePolicies(" + request + ", policyType=" + policyType + ")"));
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_REQUEST_LOG)) {
            String requestHashCode = Integer.toHexString(System.identityHashCode(request)) + "_" + policyType;
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_REQUEST_LOG, "RangerPolicyEngine.evaluatePolicies(requestHashCode=" + requestHashCode + ")");
            LOG.info((Object)("RangerPolicyEngineImpl.evaluatePolicies(" + requestHashCode + ", " + request + ")"));
        }
        try (RangerReadWriteLock.RangerLock readLock = this.policyEngine.getReadLock();){
            if (LOG.isDebugEnabled() && readLock.isLockingEnabled()) {
                LOG.debug((Object)("Acquired lock - " + readLock));
            }
            this.requestProcessor.preProcess(request);
            ret = this.zoneAwareAccessEvaluationWithNoAudit(request, policyType);
            if (resultProcessor != null) {
                RangerPerfTracer perfAuditTracer = null;
                if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_AUDIT_LOG)) {
                    String requestHashCode = Integer.toHexString(System.identityHashCode(request)) + "_" + policyType;
                    perfAuditTracer = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_AUDIT_LOG, "RangerPolicyEngine.processAudit(requestHashCode=" + requestHashCode + ")");
                }
                resultProcessor.processResult(ret);
                RangerPerfTracer.log(perfAuditTracer);
            }
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.evaluatePolicies(" + request + ", policyType=" + policyType + "): " + ret));
        }
        return ret;
    }

    @Override
    public Collection<RangerAccessResult> evaluatePolicies(Collection<RangerAccessRequest> requests, int policyType, RangerAccessResultProcessor resultProcessor) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.evaluatePolicies(" + requests + ", policyType=" + policyType + ")"));
        }
        ArrayList<RangerAccessResult> ret = new ArrayList<RangerAccessResult>();
        try (RangerReadWriteLock.RangerLock readLock = this.policyEngine.getReadLock();){
            if (LOG.isDebugEnabled() && readLock.isLockingEnabled()) {
                LOG.debug((Object)("Acquired lock - " + readLock));
            }
            if (requests != null) {
                for (RangerAccessRequest request : requests) {
                    this.requestProcessor.preProcess(request);
                    RangerAccessResult result = this.zoneAwareAccessEvaluationWithNoAudit(request, policyType);
                    ret.add(result);
                }
            }
            if (resultProcessor != null) {
                resultProcessor.processResults(ret);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.evaluatePolicies(" + requests + ", policyType=" + policyType + "): " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluateAuditPolicies(RangerAccessResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.evaluateAuditPolicies(result=" + result + ")"));
        }
        try (RangerReadWriteLock.RangerLock readLock = this.policyEngine.getReadLock();){
            if (LOG.isDebugEnabled() && readLock.isLockingEnabled()) {
                LOG.debug((Object)("Acquired lock - " + readLock));
            }
            RangerPolicyRepository tagPolicyRepository = this.policyEngine.getTagPolicyRepository();
            RangerPolicyRepository policyRepository = this.policyEngine.getPolicyRepository();
            RangerAccessRequest request = result.getAccessRequest();
            boolean savedIsAuditedDetermined = result.getIsAuditedDetermined();
            boolean savedIsAudited = result.getIsAudited();
            result.setIsAudited(false);
            result.setIsAuditedDetermined(false);
            try {
                if (tagPolicyRepository != null) {
                    this.evaluateTagAuditPolicies(request, result, tagPolicyRepository);
                }
                if (!result.getIsAuditedDetermined() && policyRepository != null) {
                    this.evaluateResourceAuditPolicies(request, result, policyRepository);
                }
            }
            finally {
                if (!result.getIsAuditedDetermined()) {
                    result.setIsAudited(savedIsAudited);
                    result.setIsAuditedDetermined(savedIsAuditedDetermined);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.evaluateAuditPolicies(result=" + result + ")"));
        }
    }

    @Override
    public RangerResourceACLs getResourceACLs(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.getResourceACLs(request=" + request + ")"));
        }
        RangerResourceACLs ret = new RangerResourceACLs();
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_GET_ACLS_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_GET_ACLS_LOG, "RangerPolicyEngine.getResourceACLs(requestHashCode=" + request.getResource().getAsString() + ")");
        }
        try (RangerReadWriteLock.RangerLock readLock = this.policyEngine.getReadLock();){
            if (LOG.isDebugEnabled() && readLock.isLockingEnabled()) {
                LOG.debug((Object)("Acquired lock - " + readLock));
            }
            this.requestProcessor.preProcess(request);
            String zoneName = this.policyEngine.getUniquelyMatchedZoneName(request.getResource().getAsMap());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("zoneName:[" + zoneName + "]"));
            }
            ArrayList<RangerPolicyEvaluator> allEvaluators = new ArrayList<RangerPolicyEvaluator>();
            HashMap<Long, RangerPolicyResourceMatcher.MatchType> tagMatchTypeMap = new HashMap<Long, RangerPolicyResourceMatcher.MatchType>();
            HashSet<Long> policyIdForTemporalTags = new HashSet<Long>();
            this.getResourceACLEvaluatorsForZone(request, zoneName, allEvaluators, tagMatchTypeMap, policyIdForTemporalTags);
            allEvaluators.sort(RangerPolicyEvaluator.EVAL_ORDER_COMPARATOR);
            if (CollectionUtils.isNotEmpty(allEvaluators)) {
                Integer policyPriority = null;
                for (RangerPolicyEvaluator evaluator : allEvaluators) {
                    RangerPolicy policy;
                    Integer accessResult;
                    RangerPolicyEvaluator.PolicyACLSummary aclSummary;
                    boolean isMatched;
                    RangerPolicyResourceMatcher.MatchType matchType;
                    if (policyPriority == null) {
                        policyPriority = evaluator.getPolicyPriority();
                    }
                    if (policyPriority.intValue() != evaluator.getPolicyPriority()) {
                        ret.finalizeAcls();
                        policyPriority = evaluator.getPolicyPriority();
                    }
                    if ((matchType = (RangerPolicyResourceMatcher.MatchType)((Object)tagMatchTypeMap.get(evaluator.getId()))) == null) {
                        matchType = evaluator.getPolicyResourceMatcher().getMatchType(request.getResource(), request.getContext());
                    }
                    if (request.getResourceMatchingScope() == RangerAccessRequest.ResourceMatchingScope.SELF_OR_DESCENDANTS) {
                        isMatched = matchType != RangerPolicyResourceMatcher.MatchType.NONE;
                    } else {
                        boolean bl = isMatched = matchType == RangerPolicyResourceMatcher.MatchType.SELF || matchType == RangerPolicyResourceMatcher.MatchType.SELF_AND_ALL_DESCENDANTS;
                    }
                    if (!isMatched || (aclSummary = evaluator.getPolicyACLSummary()) == null) continue;
                    boolean isConditional = policyIdForTemporalTags.contains(evaluator.getId()) || evaluator.getValidityScheduleEvaluatorsCount() != 0;
                    for (Map.Entry<String, Map<String, RangerPolicyEvaluator.PolicyACLSummary.AccessResult>> userAccessInfo : aclSummary.getUsersAccessInfo().entrySet()) {
                        String userName = userAccessInfo.getKey();
                        for (Map.Entry<String, RangerPolicyEvaluator.PolicyACLSummary.AccessResult> accessInfo : userAccessInfo.getValue().entrySet()) {
                            if (isConditional) {
                                accessResult = RangerPolicyEvaluator.ACCESS_CONDITIONAL;
                            } else {
                                accessResult = accessInfo.getValue().getResult();
                                if (accessResult.equals(RangerPolicyEvaluator.ACCESS_UNDETERMINED)) {
                                    accessResult = RangerPolicyEvaluator.ACCESS_DENIED;
                                }
                            }
                            policy = evaluator.getPolicy();
                            ret.setUserAccessInfo(userName, accessInfo.getKey(), accessResult, policy);
                        }
                    }
                    for (Map.Entry<String, Map<String, RangerPolicyEvaluator.PolicyACLSummary.AccessResult>> groupAccessInfo : aclSummary.getGroupsAccessInfo().entrySet()) {
                        String groupName = groupAccessInfo.getKey();
                        for (Map.Entry<String, RangerPolicyEvaluator.PolicyACLSummary.AccessResult> accessInfo : groupAccessInfo.getValue().entrySet()) {
                            if (isConditional) {
                                accessResult = RangerPolicyEvaluator.ACCESS_CONDITIONAL;
                            } else {
                                accessResult = accessInfo.getValue().getResult();
                                if (accessResult.equals(RangerPolicyEvaluator.ACCESS_UNDETERMINED)) {
                                    accessResult = RangerPolicyEvaluator.ACCESS_DENIED;
                                }
                            }
                            policy = evaluator.getPolicy();
                            ret.setGroupAccessInfo(groupName, accessInfo.getKey(), accessResult, policy);
                        }
                    }
                    for (Map.Entry<String, Map<String, RangerPolicyEvaluator.PolicyACLSummary.AccessResult>> roleAccessInfo : aclSummary.getRolesAccessInfo().entrySet()) {
                        String roleName = roleAccessInfo.getKey();
                        for (Map.Entry<String, RangerPolicyEvaluator.PolicyACLSummary.AccessResult> accessInfo : roleAccessInfo.getValue().entrySet()) {
                            if (isConditional) {
                                accessResult = RangerPolicyEvaluator.ACCESS_CONDITIONAL;
                            } else {
                                accessResult = accessInfo.getValue().getResult();
                                if (accessResult.equals(RangerPolicyEvaluator.ACCESS_UNDETERMINED)) {
                                    accessResult = RangerPolicyEvaluator.ACCESS_DENIED;
                                }
                            }
                            policy = evaluator.getPolicy();
                            ret.setRoleAccessInfo(roleName, accessInfo.getKey(), accessResult, policy);
                        }
                    }
                }
                ret.finalizeAcls();
            }
        }
        RangerPerfTracer.logAlways(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.getResourceACLs(request=" + request + ") : ret=" + ret));
        }
        return ret;
    }

    @Override
    public void setUseForwardedIPAddress(boolean useForwardedIPAddress) {
        try (RangerReadWriteLock.RangerLock writeLock = this.policyEngine.getWriteLock();){
            if (LOG.isDebugEnabled() && writeLock.isLockingEnabled()) {
                LOG.debug((Object)("Acquired lock - " + writeLock));
            }
            this.policyEngine.setUseForwardedIPAddress(useForwardedIPAddress);
        }
    }

    @Override
    public void setTrustedProxyAddresses(String[] trustedProxyAddresses) {
        try (RangerReadWriteLock.RangerLock writeLock = this.policyEngine.getWriteLock();){
            if (LOG.isDebugEnabled() && writeLock.isLockingEnabled()) {
                LOG.debug((Object)("Acquired lock - " + writeLock));
            }
            this.policyEngine.setTrustedProxyAddresses(trustedProxyAddresses);
        }
    }

    @Override
    public RangerServiceDef getServiceDef() {
        RangerServiceDef ret;
        try (RangerReadWriteLock.RangerLock readLock = this.policyEngine.getReadLock();){
            if (LOG.isDebugEnabled() && readLock.isLockingEnabled()) {
                LOG.debug((Object)("Acquired lock - " + readLock));
            }
            ret = this.policyEngine.getServiceDef();
        }
        return ret;
    }

    @Override
    public long getPolicyVersion() {
        long ret;
        try (RangerReadWriteLock.RangerLock readLock = this.policyEngine.getReadLock();){
            if (LOG.isDebugEnabled() && readLock.isLockingEnabled()) {
                LOG.debug((Object)("Acquired lock - " + readLock));
            }
            ret = this.policyEngine.getPolicyVersion();
        }
        return ret;
    }

    @Override
    public long getRoleVersion() {
        return this.policyEngine.getRoleVersion();
    }

    @Override
    public void setRoles(RangerRoles roles) {
        try (RangerReadWriteLock.RangerLock writeLock = this.policyEngine.getWriteLock();){
            if (LOG.isDebugEnabled() && writeLock.isLockingEnabled()) {
                LOG.debug((Object)("Acquired lock - " + writeLock));
            }
            this.policyEngine.setRoles(roles);
        }
    }

    @Override
    public Set<String> getRolesFromUserAndGroups(String user, Set<String> groups) {
        Set<String> ret;
        try (RangerReadWriteLock.RangerLock readLock = this.policyEngine.getReadLock();){
            if (LOG.isDebugEnabled() && readLock.isLockingEnabled()) {
                LOG.debug((Object)("Acquired lock - " + readLock));
            }
            ret = this.policyEngine.getPluginContext().getAuthContext().getRolesForUserAndGroups(user, groups);
        }
        return ret;
    }

    @Override
    public String getUniquelyMatchedZoneName(GrantRevokeRequest grantRevokeRequest) {
        String ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.getUniquelyMatchedZoneName(" + grantRevokeRequest + ")"));
        }
        try (RangerReadWriteLock.RangerLock readLock = this.policyEngine.getReadLock();){
            if (LOG.isDebugEnabled() && readLock.isLockingEnabled()) {
                LOG.debug((Object)("Acquired lock - " + readLock));
            }
            ret = this.policyEngine.getUniquelyMatchedZoneName(grantRevokeRequest.getResource());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.getUniquelyMatchedZoneName(" + grantRevokeRequest + ") : " + ret));
        }
        return ret;
    }

    @Override
    public List<RangerPolicy> getResourcePolicies(String zoneName) {
        ArrayList<RangerPolicy> ret;
        try (RangerReadWriteLock.RangerLock readLock = this.policyEngine.getReadLock();){
            ArrayList<RangerPolicy> oldPolicies;
            if (LOG.isDebugEnabled() && readLock.isLockingEnabled()) {
                LOG.debug((Object)("Acquired lock - " + readLock));
            }
            ret = CollectionUtils.isNotEmpty(oldPolicies = this.policyEngine.getResourcePolicies(zoneName)) ? new ArrayList<RangerPolicy>(oldPolicies) : oldPolicies;
        }
        return ret;
    }

    @Override
    public List<RangerPolicy> getResourcePolicies() {
        ArrayList<RangerPolicy> ret;
        try (RangerReadWriteLock.RangerLock readLock = this.policyEngine.getReadLock();){
            RangerPolicyRepository policyRepository;
            if (LOG.isDebugEnabled() && readLock.isLockingEnabled()) {
                LOG.debug((Object)("Acquired lock - " + readLock));
            }
            ArrayList<RangerPolicy> oldPolicies = (policyRepository = this.policyEngine.getPolicyRepository()) == null ? ListUtils.EMPTY_LIST : policyRepository.getPolicies();
            ret = CollectionUtils.isNotEmpty(oldPolicies) ? new ArrayList<RangerPolicy>(oldPolicies) : oldPolicies;
        }
        return ret;
    }

    @Override
    public List<RangerPolicy> getTagPolicies() {
        ArrayList<RangerPolicy> ret;
        try (RangerReadWriteLock.RangerLock readLock = this.policyEngine.getReadLock();){
            RangerPolicyRepository tagPolicyRepository;
            if (LOG.isDebugEnabled() && readLock.isLockingEnabled()) {
                LOG.debug((Object)("Acquired lock - " + readLock));
            }
            ArrayList<RangerPolicy> oldPolicies = (tagPolicyRepository = this.policyEngine.getTagPolicyRepository()) == null ? ListUtils.EMPTY_LIST : tagPolicyRepository.getPolicies();
            ret = CollectionUtils.isNotEmpty(oldPolicies) ? new ArrayList<RangerPolicy>(oldPolicies) : oldPolicies;
        }
        return ret;
    }

    @Override
    public RangerResourceAccessInfo getResourceAccessInfo(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.getResourceAccessInfo(" + request + ")"));
        }
        this.requestProcessor.preProcess(request);
        RangerResourceAccessInfo ret = new RangerResourceAccessInfo(request);
        Set<String> zoneNames = this.policyEngine.getMatchedZonesForResourceAndChildren(request.getResource());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("zoneNames:[" + zoneNames + "]"));
        }
        if (CollectionUtils.isEmpty(zoneNames)) {
            this.getResourceAccessInfoForZone(request, ret, null);
        } else {
            for (String zoneName : zoneNames) {
                this.getResourceAccessInfoForZone(request, ret, zoneName);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.getResourceAccessInfo(" + request + "): " + ret));
        }
        return ret;
    }

    public void releaseResources(boolean isForced) {
        PolicyEngine policyEngine;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.releaseResources(isForced=" + isForced + ")"));
        }
        if ((policyEngine = this.policyEngine) != null) {
            policyEngine.preCleanup(isForced);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Cannot preCleanup policy-engine as it is null!");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.releaseResources(isForced=" + isForced + ")"));
        }
    }

    PolicyEngine getPolicyEngine() {
        return this.policyEngine;
    }

    private RangerPolicyEngineImpl(PolicyEngine policyEngine, RangerPolicyEngineImpl other) {
        this.policyEngine = policyEngine;
        this.requestProcessor = new RangerDefaultRequestProcessor(policyEngine);
        this.serviceConfig = new ServiceConfig(other.serviceConfig);
    }

    private RangerAccessResult zoneAwareAccessEvaluationWithNoAudit(RangerAccessRequest request, int policyType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.zoneAwareAccessEvaluationWithNoAudit(" + request + ", policyType =" + policyType + ")"));
        }
        RangerAccessResult ret = null;
        RangerPolicyRepository policyRepository = this.policyEngine.getPolicyRepository();
        RangerPolicyRepository tagPolicyRepository = this.policyEngine.getTagPolicyRepository();
        Set<String> zoneNames = this.policyEngine.getMatchedZonesForResourceAndChildren(request.getResource());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("zoneNames:[" + zoneNames + "]"));
        }
        if (CollectionUtils.isEmpty(zoneNames) || zoneNames.size() > 1 && !request.isAccessTypeAny()) {
            policyRepository = this.policyEngine.getRepositoryForZone(null);
            ret = this.evaluatePoliciesNoAudit(request, policyType, null, policyRepository, tagPolicyRepository);
            ret.setZoneName(null);
        } else if (zoneNames.size() == 1 || request.isAccessTypeAny()) {
            for (String zoneName : zoneNames) {
                policyRepository = this.policyEngine.getRepositoryForZone(zoneName);
                ret = this.evaluatePoliciesNoAudit(request, policyType, zoneName, policyRepository, tagPolicyRepository);
                ret.setZoneName(zoneName);
                if (!ret.getIsAllowed()) continue;
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)("Zone:[" + zoneName + "] allowed access. Completed processing other zones"));
                break;
            }
        }
        if (request.isAccessTypeAny() && (request.getResource() == null || CollectionUtils.isEmpty(request.getResource().getKeys())) && ret != null && !ret.getIsAllowed() && MapUtils.isNotEmpty(this.policyEngine.getZonePolicyRepositories())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Process all security-zones");
            }
            for (Map.Entry<String, RangerPolicyRepository> entry : this.policyEngine.getZonePolicyRepositories().entrySet()) {
                RangerAccessResult accessResult;
                String someZone = entry.getKey();
                policyRepository = entry.getValue();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Evaluating policies for zone:[" + someZone + "]"));
                }
                if (policyRepository == null || !(accessResult = this.evaluatePoliciesNoAudit(request, policyType, someZone, policyRepository, tagPolicyRepository)).getIsAllowed()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Zone:[" + someZone + "] allowed access. Completed processing other zones"));
                }
                accessResult.setZoneName(someZone);
                ret = accessResult;
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.zoneAwareAccessEvaluationWithNoAudit(" + request + ", policyType =" + policyType + "): " + ret));
        }
        return ret;
    }

    private RangerAccessResult evaluatePoliciesNoAudit(RangerAccessRequest request, int policyType, String zoneName, RangerPolicyRepository policyRepository, RangerPolicyRepository tagPolicyRepository) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.evaluatePoliciesNoAudit(" + request + ", policyType =" + policyType + ", zoneName=" + zoneName + ")"));
        }
        Date accessTime = request.getAccessTime() != null ? request.getAccessTime() : new Date();
        RangerAccessResult ret = this.createAccessResult(request, policyType);
        boolean isSuperUser = this.isSuperUser(request.getUser(), request.getUserGroups());
        if (isSuperUser || StringUtils.equals((String)request.getAccessType(), (String)"_super_user")) {
            ret.setIsAllowed(isSuperUser);
            ret.setIsAccessDetermined(true);
            ret.setPolicyId(-1L);
            ret.setPolicyPriority(Integer.MAX_VALUE);
            ret.setReason("superuser");
        }
        this.evaluateTagPolicies(request, policyType, zoneName, tagPolicyRepository, ret);
        if (LOG.isDebugEnabled() && ret.getIsAccessDetermined() && ret.getIsAuditedDetermined()) {
            if (!ret.getIsAllowed()) {
                LOG.debug((Object)("RangerPolicyEngineImpl.evaluatePoliciesNoAudit() - audit determined and access denied by a tag policy. Higher priority resource policies will be evaluated to check for allow, request=" + request + ", result=" + ret));
            } else {
                LOG.debug((Object)("RangerPolicyEngineImpl.evaluatePoliciesNoAudit() - audit determined and access allowed by a tag policy. Same or higher priority resource policies will be evaluated to check for deny, request=" + request + ", result=" + ret));
            }
        }
        boolean isAllowedByTags = ret.getIsAccessDetermined() && ret.getIsAllowed();
        boolean isDeniedByTags = ret.getIsAccessDetermined() && !ret.getIsAllowed();
        boolean evaluateResourcePolicies = this.policyEngine.hasResourcePolicies(policyRepository);
        if (evaluateResourcePolicies) {
            boolean foundInCache;
            boolean findAuditByResource = !ret.getIsAuditedDetermined();
            boolean bl = foundInCache = findAuditByResource && policyRepository.setAuditEnabledFromCache(request, ret);
            if (!isSuperUser) {
                ret.setIsAccessDetermined(false);
            }
            List<RangerPolicyEvaluator> evaluators = policyRepository.getLikelyMatchPolicyEvaluators(request, policyType);
            for (RangerPolicyEvaluator evaluator : evaluators) {
                if (!evaluator.isApplicable(accessTime)) continue;
                if (isDeniedByTags) {
                    if (ret.getPolicyPriority() >= evaluator.getPolicyPriority()) {
                        ret.setIsAccessDetermined(true);
                    }
                } else if (ret.getIsAllowed() && ret.getPolicyPriority() > evaluator.getPolicyPriority()) {
                    ret.setIsAccessDetermined(true);
                }
                ret.incrementEvaluatedPoliciesCount();
                evaluator.evaluate(request, ret);
                if (ret.getIsAllowed() && !evaluator.hasDeny()) {
                    ret.setIsAccessDetermined(true);
                }
                if (!ret.getIsAuditedDetermined() || !ret.getIsAccessDetermined()) continue;
                break;
            }
            if (!ret.getIsAccessDetermined()) {
                if (isDeniedByTags) {
                    ret.setIsAllowed(false);
                } else if (isAllowedByTags) {
                    ret.setIsAllowed(true);
                }
                if (!ret.getIsAllowed() && !this.getIsFallbackSupported()) {
                    ret.setIsAccessDetermined(true);
                }
            }
            if (ret.getIsAllowed()) {
                ret.setIsAccessDetermined(true);
            }
            if (findAuditByResource && !foundInCache) {
                policyRepository.storeAuditEnabledInCache(request, ret);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.evaluatePoliciesNoAudit(" + request + ", policyType =" + policyType + ", zoneName=" + zoneName + "): " + ret));
        }
        return ret;
    }

    private void evaluateTagPolicies(RangerAccessRequest request, int policyType, String zoneName, RangerPolicyRepository tagPolicyRepository, RangerAccessResult result) {
        List<PolicyEvaluatorForTag> policyEvaluators;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.evaluateTagPolicies(" + request + ", policyType =" + policyType + ", zoneName=" + zoneName + ", " + result + ")"));
        }
        Date accessTime = request.getAccessTime() != null ? request.getAccessTime() : new Date();
        Set<RangerTagForEval> tags = RangerAccessRequestUtil.getRequestTagsFromContext(request.getContext());
        List<PolicyEvaluatorForTag> list = policyEvaluators = tagPolicyRepository == null ? null : tagPolicyRepository.getLikelyMatchPolicyEvaluators(request, tags, policyType, accessTime);
        if (CollectionUtils.isNotEmpty(policyEvaluators)) {
            boolean useTagPoliciesFromDefaultZone = !this.policyEngine.isResourceZoneAssociatedWithTagService(zoneName);
            for (PolicyEvaluatorForTag policyEvaluator : policyEvaluators) {
                RangerPolicyEvaluator evaluator = policyEvaluator.getEvaluator();
                String policyZoneName = evaluator.getPolicy().getZoneName();
                if (useTagPoliciesFromDefaultZone) {
                    if (StringUtils.isNotEmpty((String)policyZoneName)) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Tag policy [zone:" + policyZoneName + "] does not belong to default zone. Not evaluating this policy:[" + evaluator.getPolicy() + "]"));
                        continue;
                    }
                } else if (!StringUtils.equals((String)zoneName, (String)policyZoneName)) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Tag policy [zone:" + policyZoneName + "] does not belong to the zone:[" + zoneName + "] of the accessed resource. Not evaluating this policy:[" + evaluator.getPolicy() + "]"));
                    continue;
                }
                RangerTagForEval tag = policyEvaluator.getTag();
                RangerTagAccessRequest tagEvalRequest = new RangerTagAccessRequest(tag, tagPolicyRepository.getServiceDef(), request);
                RangerAccessResult tagEvalResult = this.createAccessResult(tagEvalRequest, policyType);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("RangerPolicyEngineImpl.evaluateTagPolicies: Evaluating policies for tag (" + tag.getType() + ")"));
                }
                tagEvalResult.setAccessResultFrom(result);
                tagEvalResult.setAuditResultFrom(result);
                result.incrementEvaluatedPoliciesCount();
                evaluator.evaluate(tagEvalRequest, tagEvalResult);
                if (tagEvalResult.getIsAllowed() && !evaluator.hasDeny()) {
                    tagEvalResult.setIsAccessDetermined(true);
                }
                if (tagEvalResult.getIsAudited()) {
                    result.setAuditResultFrom(tagEvalResult);
                }
                if (!result.getIsAccessDetermined()) {
                    if (tagEvalResult.getIsAccessDetermined()) {
                        result.setAccessResultFrom(tagEvalResult);
                    } else if (!result.getIsAllowed() && tagEvalResult.getIsAllowed()) {
                        result.setAccessResultFrom(tagEvalResult);
                    }
                }
                if (!result.getIsAuditedDetermined() || !result.getIsAccessDetermined()) continue;
                break;
            }
        }
        if (result.getIsAllowed()) {
            result.setIsAccessDetermined(true);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.evaluateTagPolicies(" + request + ", policyType =" + policyType + ", zoneName=" + zoneName + ", " + result + ")"));
        }
    }

    private RangerAccessResult createAccessResult(RangerAccessRequest request, int policyType) {
        RangerPolicyRepository repository = this.policyEngine.getPolicyRepository();
        RangerAccessResult ret = new RangerAccessResult(policyType, repository.getServiceName(), repository.getServiceDef(), request);
        switch (repository.getAuditModeEnum()) {
            case AUDIT_ALL: {
                ret.setIsAudited(true);
                break;
            }
            case AUDIT_NONE: {
                ret.setIsAudited(false);
                break;
            }
            default: {
                if (!CollectionUtils.isEmpty(repository.getPolicies()) || this.policyEngine.getTagPolicyRepository() != null) break;
                ret.setIsAudited(true);
            }
        }
        if (this.isAuditExcludedUser(request.getUser(), request.getUserGroups(), RangerAccessRequestUtil.getCurrentUserRolesFromContext(request.getContext()))) {
            ret.setIsAudited(false);
        }
        return ret;
    }

    private boolean isAuditExcludedUser(String userName, Set<String> userGroups, Set<String> userRoles) {
        boolean ret = this.serviceConfig.isAuditExcludedUser(userName);
        if (!ret) {
            RangerPluginConfig pluginConfig = this.policyEngine.getPluginContext().getConfig();
            ret = pluginConfig.isAuditExcludedUser(userName);
            if (!ret && userGroups != null && userGroups.size() > 0) {
                boolean bl = ret = this.serviceConfig.hasAuditExcludedGroup(userGroups) || pluginConfig.hasAuditExcludedGroup(userGroups);
            }
            if (!ret && userRoles != null && userRoles.size() > 0) {
                ret = this.serviceConfig.hasAuditExcludedRole(userRoles) || pluginConfig.hasAuditExcludedRole(userRoles);
            }
        }
        return ret;
    }

    private boolean isSuperUser(String userName, Set<String> userGroups) {
        RangerPluginConfig pluginConfig;
        boolean ret = this.serviceConfig.isSuperUser(userName);
        if (!ret && !(ret = (pluginConfig = this.policyEngine.getPluginContext().getConfig()).isSuperUser(userName)) && userGroups != null && userGroups.size() > 0) {
            ret = this.serviceConfig.hasSuperGroup(userGroups) || pluginConfig.hasSuperGroup(userGroups);
        }
        return ret;
    }

    private void getResourceACLEvaluatorsForZone(RangerAccessRequest request, String zoneName, List<RangerPolicyEvaluator> allEvaluators, Map<Long, RangerPolicyResourceMatcher.MatchType> tagMatchTypeMap, Set<Long> policyIdForTemporalTags) {
        RangerPolicyRepository matchedRepository = this.policyEngine.getRepositoryForZone(zoneName);
        if (matchedRepository == null) {
            LOG.error((Object)("policyRepository for zoneName:[" + zoneName + "],  serviceName:[" + this.policyEngine.getPolicyRepository().getServiceName() + "], policyVersion:[" + this.getPolicyVersion() + "] is null!! ERROR!"));
        } else {
            List<PolicyEvaluatorForTag> tagPolicyEvaluators;
            Set<RangerTagForEval> tags = RangerAccessRequestUtil.getRequestTagsFromContext(request.getContext());
            List<PolicyEvaluatorForTag> list = tagPolicyEvaluators = this.policyEngine.getTagPolicyRepository() == null ? null : this.policyEngine.getTagPolicyRepository().getLikelyMatchPolicyEvaluators(request, tags, 0, null);
            if (CollectionUtils.isNotEmpty(tagPolicyEvaluators)) {
                boolean useTagPoliciesFromDefaultZone = !this.policyEngine.isResourceZoneAssociatedWithTagService(zoneName);
                for (PolicyEvaluatorForTag tagEvaluator : tagPolicyEvaluators) {
                    RangerPolicyEvaluator evaluator = tagEvaluator.getEvaluator();
                    String policyZoneName = evaluator.getPolicy().getZoneName();
                    if (useTagPoliciesFromDefaultZone) {
                        if (StringUtils.isNotEmpty((String)policyZoneName)) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug((Object)("Tag policy [zone:" + policyZoneName + "] does not belong to default zone. Not evaluating this policy:[" + evaluator.getPolicy() + "]"));
                            continue;
                        }
                    } else if (!StringUtils.equals((String)zoneName, (String)policyZoneName)) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Tag policy [zone:" + policyZoneName + "] does not belong to the zone:[" + zoneName + "] of the accessed resource. Not evaluating this policy:[" + evaluator.getPolicy() + "]"));
                        continue;
                    }
                    RangerTagForEval tag = tagEvaluator.getTag();
                    allEvaluators.add(evaluator);
                    tagMatchTypeMap.put(evaluator.getId(), tag.getMatchType());
                    if (!CollectionUtils.isNotEmpty(tag.getValidityPeriods())) continue;
                    policyIdForTemporalTags.add(evaluator.getId());
                }
            }
            List<RangerPolicyEvaluator> resourcePolicyEvaluators = matchedRepository.getLikelyMatchPolicyEvaluators(request, 0);
            allEvaluators.addAll(resourcePolicyEvaluators);
        }
    }

    private void getResourceAccessInfoForZone(RangerAccessRequest request, RangerResourceAccessInfo ret, String zoneName) {
        RangerPolicyRepository matchedRepository = this.policyEngine.getRepositoryForZone(zoneName);
        if (matchedRepository == null) {
            LOG.error((Object)("policyRepository for zoneName:[" + zoneName + "],  serviceName:[" + this.policyEngine.getPolicyRepository().getServiceName() + "], policyVersion:[" + this.getPolicyVersion() + "] is null!! ERROR!"));
        } else {
            List<RangerPolicyEvaluator> resPolicyEvaluators;
            Set<RangerTagForEval> tags;
            List<RangerPolicyEvaluator> tagPolicyEvaluators;
            List<RangerPolicyEvaluator> list = tagPolicyEvaluators = this.policyEngine.getTagPolicyRepository() == null ? null : this.policyEngine.getTagPolicyRepository().getPolicyEvaluators();
            if (CollectionUtils.isNotEmpty(tagPolicyEvaluators) && CollectionUtils.isNotEmpty(tags = RangerAccessRequestUtil.getRequestTagsFromContext(request.getContext()))) {
                boolean useTagPoliciesFromDefaultZone = !this.policyEngine.isResourceZoneAssociatedWithTagService(zoneName);
                for (RangerTagForEval tag : tags) {
                    RangerTagAccessRequest tagEvalRequest = new RangerTagAccessRequest(tag, this.policyEngine.getTagPolicyRepository().getServiceDef(), request);
                    List<RangerPolicyEvaluator> evaluators = this.policyEngine.getTagPolicyRepository().getLikelyMatchPolicyEvaluators(tagEvalRequest, 0);
                    for (RangerPolicyEvaluator evaluator : evaluators) {
                        String policyZoneName = evaluator.getPolicy().getZoneName();
                        if (useTagPoliciesFromDefaultZone) {
                            if (StringUtils.isNotEmpty((String)policyZoneName)) {
                                if (!LOG.isDebugEnabled()) continue;
                                LOG.debug((Object)("Tag policy [zone:" + policyZoneName + "] does not belong to default zone. Not evaluating this policy:[" + evaluator.getPolicy() + "]"));
                                continue;
                            }
                        } else if (!StringUtils.equals((String)zoneName, (String)policyZoneName)) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug((Object)("Tag policy [zone:" + policyZoneName + "] does not belong to the zone:[" + zoneName + "] of the accessed resource. Not evaluating this policy:[" + evaluator.getPolicy() + "]"));
                            continue;
                        }
                        evaluator.getResourceAccessInfo(tagEvalRequest, ret);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(resPolicyEvaluators = matchedRepository.getLikelyMatchPolicyEvaluators(request, 0))) {
                for (RangerPolicyEvaluator evaluator : resPolicyEvaluators) {
                    evaluator.getResourceAccessInfo(request, ret);
                }
            }
            ret.getAllowedUsers().removeAll(ret.getDeniedUsers());
            ret.getAllowedGroups().removeAll(ret.getDeniedGroups());
        }
    }

    private void evaluateTagAuditPolicies(RangerAccessRequest request, RangerAccessResult result, RangerPolicyRepository tagPolicyRepository) {
        Date accessTime;
        List<PolicyEvaluatorForTag> evaluators;
        Set<RangerTagForEval> tags;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.evaluateTagAuditPolicies(request=" + request + ", result=" + result + ")"));
        }
        if (CollectionUtils.isNotEmpty(tags = RangerAccessRequestUtil.getRequestTagsFromContext(request.getContext())) && CollectionUtils.isNotEmpty(evaluators = tagPolicyRepository.getLikelyMatchPolicyEvaluators(request, tags, 3, accessTime = request.getAccessTime() != null ? request.getAccessTime() : new Date()))) {
            for (PolicyEvaluatorForTag policyEvaluator : evaluators) {
                RangerPolicyEvaluator evaluator = policyEvaluator.getEvaluator();
                RangerTagForEval tag = policyEvaluator.getTag();
                RangerTagAccessRequest tagEvalRequest = new RangerTagAccessRequest(tag, tagPolicyRepository.getServiceDef(), request);
                RangerAccessResult tagEvalResult = this.createAccessResult(tagEvalRequest, 3);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("RangerPolicyEngineImpl.evaluateTagAuditPolicies: Evaluating Audit policies for tag (" + tag.getType() + ")Tag Evaluator: " + policyEvaluator));
                }
                tagEvalResult.setAccessResultFrom(result);
                result.incrementEvaluatedPoliciesCount();
                evaluator.evaluate(tagEvalRequest, tagEvalResult);
                if (!tagEvalResult.getIsAuditedDetermined()) continue;
                result.setIsAudited(tagEvalResult.getIsAudited());
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.evaluateTagAuditPolicies(request=" + request + ", result=" + result + ")"));
        }
    }

    private boolean evaluateResourceAuditPolicies(RangerAccessRequest request, RangerAccessResult result, RangerPolicyRepository policyRepository) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.evaluateResourceAuditPolicies(request=" + request + ", result=" + result + ")"));
        }
        boolean ret = false;
        List<RangerPolicyEvaluator> evaluators = policyRepository.getLikelyMatchAuditPolicyEvaluators(request);
        if (CollectionUtils.isNotEmpty(evaluators)) {
            for (RangerPolicyEvaluator evaluator : evaluators) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("==> RangerPolicyEngineImpl.evaluateResourceAuditPolicies(): Evaluating RangerPolicyEvaluator...: " + evaluator));
                }
                result.incrementEvaluatedPoliciesCount();
                evaluator.evaluate(request, result);
                if (!result.getIsAuditedDetermined()) continue;
                ret = true;
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.evaluateResourceAuditPolicies(request=" + request + ", result=" + result + "): ret=" + ret));
        }
        return ret;
    }

    private boolean getIsFallbackSupported() {
        return this.policyEngine.getPluginContext().getConfig().getIsFallbackSupported();
    }

    private static class ServiceConfig {
        private final Set<String> auditExcludedUsers;
        private final Set<String> auditExcludedGroups;
        private final Set<String> auditExcludedRoles;
        private final Set<String> superUsers;
        private final Set<String> superGroups;

        public ServiceConfig(Map<String, String> svcConfig) {
            if (svcConfig != null) {
                this.auditExcludedUsers = StringUtil.toSet(svcConfig.get("ranger.plugin.audit.exclude.users"));
                this.auditExcludedGroups = StringUtil.toSet(svcConfig.get("ranger.plugin.audit.exclude.groups"));
                this.auditExcludedRoles = StringUtil.toSet(svcConfig.get("ranger.plugin.audit.exclude.roles"));
                this.superUsers = StringUtil.toSet(svcConfig.get("ranger.plugin.super.users"));
                this.superGroups = StringUtil.toSet(svcConfig.get("ranger.plugin.super.groups"));
            } else {
                this.auditExcludedUsers = Collections.emptySet();
                this.auditExcludedGroups = Collections.emptySet();
                this.auditExcludedRoles = Collections.emptySet();
                this.superUsers = Collections.emptySet();
                this.superGroups = Collections.emptySet();
            }
        }

        public ServiceConfig(ServiceConfig other) {
            this.auditExcludedUsers = other == null || CollectionUtils.isEmpty(other.auditExcludedUsers) ? Collections.emptySet() : new HashSet<String>(other.auditExcludedUsers);
            this.auditExcludedGroups = other == null || CollectionUtils.isEmpty(other.auditExcludedGroups) ? Collections.emptySet() : new HashSet<String>(other.auditExcludedGroups);
            this.auditExcludedRoles = other == null || CollectionUtils.isEmpty(other.auditExcludedRoles) ? Collections.emptySet() : new HashSet<String>(other.auditExcludedRoles);
            this.superUsers = other == null || CollectionUtils.isEmpty(other.superUsers) ? Collections.emptySet() : new HashSet<String>(other.superUsers);
            this.superGroups = other == null || CollectionUtils.isEmpty(other.superGroups) ? Collections.emptySet() : new HashSet<String>(other.superGroups);
        }

        public boolean isAuditExcludedUser(String userName) {
            return this.auditExcludedUsers.contains(userName);
        }

        public boolean hasAuditExcludedGroup(Set<String> userGroups) {
            return userGroups != null && userGroups.size() > 0 && this.auditExcludedGroups.size() > 0 && CollectionUtils.containsAny(userGroups, this.auditExcludedGroups);
        }

        public boolean hasAuditExcludedRole(Set<String> userRoles) {
            return userRoles != null && userRoles.size() > 0 && this.auditExcludedRoles.size() > 0 && CollectionUtils.containsAny(userRoles, this.auditExcludedRoles);
        }

        public boolean isSuperUser(String userName) {
            return this.superUsers.contains(userName);
        }

        public boolean hasSuperGroup(Set<String> userGroups) {
            return userGroups != null && userGroups.size() > 0 && this.superGroups.size() > 0 && CollectionUtils.containsAny(userGroups, this.superGroups);
        }
    }
}

