/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.admin.client.RangerAdminClient;
import org.apache.ranger.admin.client.RangerAdminRESTClient;
import org.apache.ranger.audit.provider.AuditHandler;
import org.apache.ranger.audit.provider.AuditProviderFactory;
import org.apache.ranger.audit.provider.StandAloneAuditProviderFactory;
import org.apache.ranger.authorization.hadoop.config.RangerAuditConfig;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.conditionevaluator.RangerScriptExecutionContext;
import org.apache.ranger.plugin.contextenricher.RangerContextEnricher;
import org.apache.ranger.plugin.contextenricher.RangerTagEnricher;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerRole;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngine;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineImpl;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.policyengine.RangerResourceAccessInfo;
import org.apache.ranger.plugin.service.RangerAuthContext;
import org.apache.ranger.plugin.service.RangerAuthContextListener;
import org.apache.ranger.plugin.service.RangerChainedPlugin;
import org.apache.ranger.plugin.store.EmbeddedServiceDefsUtil;
import org.apache.ranger.plugin.util.DownloadTrigger;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.GrantRevokeRoleRequest;
import org.apache.ranger.plugin.util.PolicyRefresher;
import org.apache.ranger.plugin.util.RangerPolicyDeltaUtil;
import org.apache.ranger.plugin.util.RangerRoles;
import org.apache.ranger.plugin.util.ServicePolicies;

public class RangerBasePlugin {
    private static final Log LOG = LogFactory.getLog(RangerBasePlugin.class);
    private final RangerPluginConfig pluginConfig;
    private final RangerPluginContext pluginContext;
    private final Map<String, LogHistory> logHistoryList = new Hashtable<String, LogHistory>();
    private final int logInterval = 30000;
    private final DownloadTrigger accessTrigger = new DownloadTrigger();
    private PolicyRefresher refresher;
    private RangerPolicyEngine policyEngine;
    private RangerAuthContext currentAuthContext;
    private RangerAccessResultProcessor resultProcessor;
    private RangerRoles roles;
    private final List<RangerChainedPlugin> chainedPlugins;

    public RangerBasePlugin(String serviceType, String appId) {
        this(new RangerPluginConfig(serviceType, null, appId, null, null, null));
    }

    public RangerBasePlugin(String serviceType, String serviceName, String appId) {
        this(new RangerPluginConfig(serviceType, serviceName, appId, null, null, null));
    }

    public RangerBasePlugin(RangerPluginConfig pluginConfig) {
        this.pluginConfig = pluginConfig;
        this.pluginContext = new RangerPluginContext(pluginConfig);
        Set<String> superUsers = this.toSet(pluginConfig.get(pluginConfig.getPropertyPrefix() + ".super.users"));
        Set<String> superGroups = this.toSet(pluginConfig.get(pluginConfig.getPropertyPrefix() + ".super.groups"));
        Set<String> auditExcludeUsers = this.toSet(pluginConfig.get(pluginConfig.getPropertyPrefix() + ".audit.exclude.users"));
        Set<String> auditExcludeGroups = this.toSet(pluginConfig.get(pluginConfig.getPropertyPrefix() + ".audit.exclude.groups"));
        Set<String> auditExcludeRoles = this.toSet(pluginConfig.get(pluginConfig.getPropertyPrefix() + ".audit.exclude.roles"));
        this.setSuperUsersAndGroups(superUsers, superGroups);
        this.setAuditExcludedUsersGroupsRoles(auditExcludeUsers, auditExcludeGroups, auditExcludeRoles);
        this.setIsFallbackSupported(pluginConfig.getBoolean(pluginConfig.getPropertyPrefix() + ".is.fallback.supported", false));
        RangerScriptExecutionContext.init(pluginConfig);
        this.chainedPlugins = this.initChainedPlugins();
    }

    public static AuditHandler getAuditProvider(String serviceName) {
        AuditProviderFactory providerFactory = RangerBasePlugin.getAuditProviderFactory(serviceName);
        AuditHandler ret = providerFactory.getAuditProvider();
        return ret;
    }

    public String getServiceType() {
        return this.pluginConfig.getServiceType();
    }

    public String getAppId() {
        return this.pluginConfig.getAppId();
    }

    public RangerPluginConfig getConfig() {
        return this.pluginConfig;
    }

    public String getClusterName() {
        return this.pluginConfig.getClusterName();
    }

    public RangerAuthContext getCurrentRangerAuthContext() {
        return this.currentAuthContext;
    }

    public RangerAuthContext createRangerAuthContext() {
        return this.currentAuthContext;
    }

    public RangerRoles getRoles() {
        return this.roles;
    }

    public void setRoles(RangerRoles roles) {
        this.roles = roles;
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            policyEngine.setRoles(roles);
        }
        this.pluginContext.notifyAuthContextChanged();
    }

    public void setAuditExcludedUsersGroupsRoles(Set<String> users, Set<String> groups, Set<String> roles) {
        this.pluginConfig.setAuditExcludedUsersGroupsRoles(users, groups, roles);
    }

    public void setSuperUsersAndGroups(Set<String> users, Set<String> groups) {
        this.pluginConfig.setSuperUsersGroups(users, groups);
    }

    public void setIsFallbackSupported(boolean isFallbackSupported) {
        this.pluginConfig.setIsFallbackSupported(isFallbackSupported);
    }

    public RangerServiceDef getServiceDef() {
        RangerPolicyEngine policyEngine = this.policyEngine;
        return policyEngine != null ? policyEngine.getServiceDef() : null;
    }

    public int getServiceDefId() {
        RangerServiceDef serviceDef = this.getServiceDef();
        return serviceDef != null && serviceDef.getId() != null ? serviceDef.getId().intValue() : -1;
    }

    public String getServiceName() {
        return this.pluginConfig.getServiceName();
    }

    public AuditProviderFactory getAuditProviderFactory() {
        return RangerBasePlugin.getAuditProviderFactory(this.getServiceName());
    }

    public void init() {
        this.cleanup();
        AuditProviderFactory providerFactory = AuditProviderFactory.getInstance();
        if (!providerFactory.isInitDone()) {
            if (this.pluginConfig.getProperties() != null) {
                providerFactory.init(this.pluginConfig.getProperties(), this.getAppId());
            } else {
                LOG.error((Object)"Audit subsystem is not initialized correctly. Please check audit configuration. ");
                LOG.error((Object)"No authorization audits will be generated. ");
            }
        }
        this.refresher = new PolicyRefresher(this);
        LOG.info((Object)("Created PolicyRefresher Thread(" + this.refresher.getName() + ")"));
        this.refresher.setDaemon(true);
        this.refresher.startRefresher();
        for (RangerChainedPlugin chainedPlugin : this.chainedPlugins) {
            chainedPlugin.init();
        }
    }

    public void setPolicies(ServicePolicies policies) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> setPolicies(" + policies + ")"));
        }
        try {
            RangerPolicyEngine oldPolicyEngine = this.policyEngine;
            ServicePolicies servicePolicies = null;
            boolean isNewEngineNeeded = true;
            boolean usePolicyDeltas = false;
            if (policies == null) {
                policies = this.getDefaultSvcPolicies();
                if (policies == null) {
                    LOG.error((Object)"Could not get default Service Policies. Keeping old policy-engine!");
                    isNewEngineNeeded = false;
                }
            } else {
                Boolean hasPolicyDeltas = RangerPolicyDeltaUtil.hasPolicyDeltas(policies);
                if (hasPolicyDeltas == null) {
                    LOG.info((Object)("Downloaded policies do not require policy change !! [" + policies + "]"));
                    if (this.policyEngine == null) {
                        LOG.info((Object)"There are no material changes, and current policy-engine is null! Creating a policy-engine with default service policies");
                        ServicePolicies defaultSvcPolicies = this.getDefaultSvcPolicies();
                        if (defaultSvcPolicies == null) {
                            LOG.error((Object)"Could not get default Service Policies. Keeping old policy-engine! This is a FATAL error as the old policy-engine is null!");
                            isNewEngineNeeded = false;
                        } else {
                            defaultSvcPolicies.setPolicyVersion(policies.getPolicyVersion());
                            policies = defaultSvcPolicies;
                            isNewEngineNeeded = true;
                        }
                    } else {
                        LOG.info((Object)"Keeping old policy-engine!");
                        isNewEngineNeeded = false;
                    }
                } else if (hasPolicyDeltas.equals(Boolean.TRUE)) {
                    RangerPolicyEngineImpl policyEngine = (RangerPolicyEngineImpl)oldPolicyEngine;
                    servicePolicies = ServicePolicies.applyDelta(policies, policyEngine);
                    if (servicePolicies != null) {
                        usePolicyDeltas = true;
                    } else {
                        LOG.error((Object)("Could not apply deltas=" + Arrays.toString(policies.getPolicyDeltas().toArray())));
                        LOG.warn((Object)"Keeping old policy-engine!");
                        isNewEngineNeeded = false;
                    }
                } else if (policies.getPolicies() == null) {
                    policies.setPolicies(new ArrayList<RangerPolicy>());
                }
            }
            if (isNewEngineNeeded) {
                RangerPolicyEngine newPolicyEngine = null;
                boolean isPolicyEngineShared = false;
                if (!usePolicyDeltas) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Creating engine from policies");
                    }
                    newPolicyEngine = new RangerPolicyEngineImpl(policies, this.pluginContext, this.roles);
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"policy-deltas are not null");
                    }
                    if (CollectionUtils.isNotEmpty(policies.getPolicyDeltas()) || MapUtils.isNotEmpty(policies.getSecurityZones())) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Non empty policy-deltas found. Cloning engine using policy-deltas");
                        }
                        if (oldPolicyEngine != null) {
                            RangerPolicyEngineImpl oldPolicyEngineImpl = (RangerPolicyEngineImpl)oldPolicyEngine;
                            newPolicyEngine = RangerPolicyEngineImpl.getPolicyEngine(oldPolicyEngineImpl, policies);
                        }
                        if (newPolicyEngine != null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Applied policyDeltas=" + Arrays.toString(policies.getPolicyDeltas().toArray()) + ")"));
                            }
                            isPolicyEngineShared = true;
                        } else {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Failed to apply policyDeltas=" + Arrays.toString(policies.getPolicyDeltas().toArray()) + "), Creating engine from policies"));
                                LOG.debug((Object)("Creating new engine from servicePolicies:[" + servicePolicies + "]"));
                            }
                            newPolicyEngine = new RangerPolicyEngineImpl(servicePolicies, this.pluginContext, this.roles);
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Empty policy-deltas. No need to change policy engine");
                    }
                }
                if (newPolicyEngine != null) {
                    if (!isPolicyEngineShared) {
                        newPolicyEngine.setUseForwardedIPAddress(this.pluginConfig.isUseForwardedIPAddress());
                        newPolicyEngine.setTrustedProxyAddresses(this.pluginConfig.getTrustedProxyAddresses());
                    }
                    this.policyEngine = newPolicyEngine;
                    this.currentAuthContext = this.pluginContext.getAuthContext();
                    this.pluginContext.notifyAuthContextChanged();
                    if (oldPolicyEngine != null && oldPolicyEngine != newPolicyEngine) {
                        ((RangerPolicyEngineImpl)oldPolicyEngine).releaseResources(!isPolicyEngineShared);
                    }
                    if (this.refresher != null) {
                        this.refresher.saveToCache(usePolicyDeltas ? servicePolicies : policies);
                    }
                }
            } else {
                LOG.warn((Object)"Leaving current policy engine as-is");
                LOG.warn((Object)"Policies are not saved to cache. policyVersion in the policy-cache may be different than in Ranger-admin, even though the policies are the same!");
                LOG.warn((Object)("Ranger-PolicyVersion:[" + (policies != null ? policies.getPolicyVersion() : -1L) + "], Cached-PolicyVersion:[" + (this.policyEngine != null ? this.policyEngine.getPolicyVersion() : -1L) + "]"));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"setPolicies: policy engine initialization failed!  Leaving current policy engine as-is. Exception : ", (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== setPolicies(" + policies + ")"));
        }
    }

    public void cleanup() {
        PolicyRefresher refresher = this.refresher;
        this.refresher = null;
        RangerPolicyEngine policyEngine = this.policyEngine;
        this.policyEngine = null;
        if (refresher != null) {
            refresher.stopRefresher();
        }
        if (policyEngine != null) {
            ((RangerPolicyEngineImpl)policyEngine).releaseResources(true);
        }
    }

    public void setResultProcessor(RangerAccessResultProcessor resultProcessor) {
        this.resultProcessor = resultProcessor;
    }

    public RangerAccessResultProcessor getResultProcessor() {
        return this.resultProcessor;
    }

    public RangerAccessResult isAccessAllowed(RangerAccessRequest request) {
        return this.isAccessAllowed(request, this.resultProcessor);
    }

    public Collection<RangerAccessResult> isAccessAllowed(Collection<RangerAccessRequest> requests) {
        return this.isAccessAllowed(requests, this.resultProcessor);
    }

    public RangerAccessResult isAccessAllowed(RangerAccessRequest request, RangerAccessResultProcessor resultProcessor) {
        RangerAccessResult ret = null;
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            ret = policyEngine.evaluatePolicies(request, 0, null);
        }
        if (ret != null) {
            for (RangerChainedPlugin chainedPlugin : this.chainedPlugins) {
                RangerAccessResult chainedResult = chainedPlugin.isAccessAllowed(request);
                if (chainedResult == null) continue;
                this.updateResultFromChainedResult(ret, chainedResult);
            }
        }
        if (policyEngine != null) {
            policyEngine.evaluateAuditPolicies(ret);
        }
        if (resultProcessor != null) {
            resultProcessor.processResult(ret);
        }
        return ret;
    }

    public Collection<RangerAccessResult> isAccessAllowed(Collection<RangerAccessRequest> requests, RangerAccessResultProcessor resultProcessor) {
        Collection<RangerAccessResult> ret = null;
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            ret = policyEngine.evaluatePolicies(requests, 0, null);
        }
        if (CollectionUtils.isNotEmpty(ret)) {
            for (RangerChainedPlugin chainedPlugin : this.chainedPlugins) {
                Collection<RangerAccessResult> chainedResults = chainedPlugin.isAccessAllowed(requests);
                if (!CollectionUtils.isNotEmpty(chainedResults)) continue;
                Iterator<RangerAccessResult> iterRet = ret.iterator();
                Iterator<RangerAccessResult> iterChainedResults = chainedResults.iterator();
                while (iterRet.hasNext() && iterChainedResults.hasNext()) {
                    RangerAccessResult result = iterRet.next();
                    RangerAccessResult chainedResult = iterChainedResults.next();
                    if (result == null || chainedResult == null) continue;
                    this.updateResultFromChainedResult(result, chainedResult);
                }
            }
        }
        if (policyEngine != null && CollectionUtils.isNotEmpty(ret)) {
            for (RangerAccessResult result : ret) {
                policyEngine.evaluateAuditPolicies(result);
            }
        }
        if (resultProcessor != null) {
            resultProcessor.processResults(ret);
        }
        return ret;
    }

    public RangerAccessResult evalDataMaskPolicies(RangerAccessRequest request, RangerAccessResultProcessor resultProcessor) {
        RangerPolicyEngine policyEngine = this.policyEngine;
        RangerAccessResult ret = null;
        if (policyEngine != null) {
            ret = policyEngine.evaluatePolicies(request, 1, resultProcessor);
            policyEngine.evaluateAuditPolicies(ret);
        }
        return ret;
    }

    public RangerAccessResult evalRowFilterPolicies(RangerAccessRequest request, RangerAccessResultProcessor resultProcessor) {
        RangerPolicyEngine policyEngine = this.policyEngine;
        RangerAccessResult ret = null;
        if (policyEngine != null) {
            ret = policyEngine.evaluatePolicies(request, 2, resultProcessor);
            policyEngine.evaluateAuditPolicies(ret);
        }
        return ret;
    }

    public void evalAuditPolicies(RangerAccessResult result) {
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            policyEngine.evaluateAuditPolicies(result);
        }
    }

    public RangerResourceAccessInfo getResourceAccessInfo(RangerAccessRequest request) {
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            return policyEngine.getResourceAccessInfo(request);
        }
        return null;
    }

    public RangerResourceACLs getResourceACLs(RangerAccessRequest request) {
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            return policyEngine.getResourceACLs(request);
        }
        return null;
    }

    public Set<String> getRolesFromUserAndGroups(String user, Set<String> groups) {
        RangerPolicyEngine policyEngine = this.policyEngine;
        if (policyEngine != null) {
            return policyEngine.getRolesFromUserAndGroups(user, groups);
        }
        return null;
    }

    public RangerRole createRole(RangerRole request, RangerAccessResultProcessor resultProcessor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerBasePlugin.createRole(" + request + ")"));
        }
        RangerRole ret = this.getAdminClient().createRole(request);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerBasePlugin.createRole(" + request + ")"));
        }
        return ret;
    }

    public void dropRole(String execUser, String roleName, RangerAccessResultProcessor resultProcessor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerBasePlugin.dropRole(" + roleName + ")"));
        }
        this.getAdminClient().dropRole(execUser, roleName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerBasePlugin.dropRole(" + roleName + ")"));
        }
    }

    public List<String> getUserRoles(String execUser, RangerAccessResultProcessor resultProcessor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerBasePlugin.getUserRoleNames(" + execUser + ")"));
        }
        List<String> ret = this.getAdminClient().getUserRoles(execUser);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerBasePlugin.getUserRoleNames(" + execUser + ")"));
        }
        return ret;
    }

    public List<String> getAllRoles(String execUser, RangerAccessResultProcessor resultProcessor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerBasePlugin.getAllRoles()");
        }
        List<String> ret = this.getAdminClient().getAllRoles(execUser);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerBasePlugin.getAllRoles()");
        }
        return ret;
    }

    public RangerRole getRole(String execUser, String roleName, RangerAccessResultProcessor resultProcessor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerBasePlugin.getPrincipalsForRole(" + roleName + ")"));
        }
        RangerRole ret = this.getAdminClient().getRole(execUser, roleName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerBasePlugin.getPrincipalsForRole(" + roleName + ")"));
        }
        return ret;
    }

    public void grantRole(GrantRevokeRoleRequest request, RangerAccessResultProcessor resultProcessor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerBasePlugin.grantRole(" + request + ")"));
        }
        this.getAdminClient().grantRole(request);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerBasePlugin.grantRole(" + request + ")"));
        }
    }

    public void revokeRole(GrantRevokeRoleRequest request, RangerAccessResultProcessor resultProcessor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerBasePlugin.revokeRole(" + request + ")"));
        }
        this.getAdminClient().revokeRole(request);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerBasePlugin.revokeRole(" + request + ")"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantAccess(GrantRevokeRequest request, RangerAccessResultProcessor resultProcessor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerBasePlugin.grantAccess(" + request + ")"));
        }
        boolean isSuccess = false;
        try {
            RangerPolicyEngine policyEngine = this.policyEngine;
            if (policyEngine != null) {
                request.setZoneName(policyEngine.getUniquelyMatchedZoneName(request));
            }
            this.getAdminClient().grantAccess(request);
            isSuccess = true;
        }
        finally {
            this.auditGrantRevoke(request, "grant", isSuccess, resultProcessor);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerBasePlugin.grantAccess(" + request + ")"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeAccess(GrantRevokeRequest request, RangerAccessResultProcessor resultProcessor) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerBasePlugin.revokeAccess(" + request + ")"));
        }
        boolean isSuccess = false;
        try {
            RangerPolicyEngine policyEngine = this.policyEngine;
            if (policyEngine != null) {
                request.setZoneName(policyEngine.getUniquelyMatchedZoneName(request));
            }
            this.getAdminClient().revokeAccess(request);
            isSuccess = true;
        }
        finally {
            this.auditGrantRevoke(request, "revoke", isSuccess, resultProcessor);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerBasePlugin.revokeAccess(" + request + ")"));
        }
    }

    public void registerAuthContextEventListener(RangerAuthContextListener authContextListener) {
        this.pluginContext.setAuthContextListener(authContextListener);
    }

    public static RangerAdminClient createAdminClient(RangerPluginConfig pluginConfig) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerBasePlugin.createAdminClient(" + pluginConfig.getServiceName() + ", " + pluginConfig.getAppId() + ", " + pluginConfig.getPropertyPrefix() + ")"));
        }
        RangerAdminClient ret = null;
        String propertyName = pluginConfig.getPropertyPrefix() + ".policy.source.impl";
        String policySourceImpl = pluginConfig.get(propertyName);
        if (StringUtils.isEmpty((String)policySourceImpl)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Value for property[%s] was null or empty. Unexpected! Will use policy source of type[%s]", propertyName, RangerAdminRESTClient.class.getName()));
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Value for property[%s] was [%s].", propertyName, policySourceImpl));
            }
            try {
                Class<?> adminClass = Class.forName(policySourceImpl);
                ret = (RangerAdminClient)adminClass.newInstance();
            }
            catch (Exception excp) {
                LOG.error((Object)("failed to instantiate policy source of type '" + policySourceImpl + "'. Will use policy source of type '" + RangerAdminRESTClient.class.getName() + "'"), (Throwable)excp);
            }
        }
        if (ret == null) {
            ret = new RangerAdminRESTClient();
        }
        ret.init(pluginConfig.getServiceName(), pluginConfig.getAppId(), pluginConfig.getPropertyPrefix(), pluginConfig);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerBasePlugin.createAdminClient(" + pluginConfig.getServiceName() + ", " + pluginConfig.getAppId() + ", " + pluginConfig.getPropertyPrefix() + "): policySourceImpl=" + policySourceImpl + ", client=" + ret));
        }
        return ret;
    }

    public void refreshPoliciesAndTags() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> refreshPoliciesAndTags()");
        }
        try {
            RangerTagEnricher tagEnricher;
            RangerPolicyEngine policyEngine = this.policyEngine;
            long oldPolicyVersion = policyEngine.getPolicyVersion();
            this.refresher.syncPoliciesWithAdmin(this.accessTrigger);
            policyEngine = this.policyEngine;
            long newPolicyVersion = policyEngine.getPolicyVersion();
            if (oldPolicyVersion == newPolicyVersion && (tagEnricher = this.getTagEnricher()) != null) {
                tagEnricher.syncTagsWithAdmin(this.accessTrigger);
            }
        }
        catch (InterruptedException exception) {
            LOG.error((Object)"Failed to update policy-engine, continuing to use old policy-engine and/or tags", (Throwable)exception);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== refreshPoliciesAndTags()");
        }
    }

    private void auditGrantRevoke(GrantRevokeRequest request, String action, boolean isSuccess, RangerAccessResultProcessor resultProcessor) {
        if (request != null && resultProcessor != null) {
            RangerAccessRequestImpl accessRequest = new RangerAccessRequestImpl();
            accessRequest.setResource(new RangerAccessResourceImpl(StringUtil.toStringObjectMap(request.getResource())));
            accessRequest.setUser(request.getGrantor());
            accessRequest.setAccessType("_any");
            accessRequest.setAction(action);
            accessRequest.setClientIPAddress(request.getClientIPAddress());
            accessRequest.setClientType(request.getClientType());
            accessRequest.setRequestData(request.getRequestData());
            accessRequest.setSessionId(request.getSessionId());
            RangerAccessResult accessResult = this.isAccessAllowed(accessRequest, null);
            if (accessResult != null && accessResult.getIsAudited()) {
                accessRequest.setAccessType(action);
                accessResult.setIsAllowed(isSuccess);
                if (!isSuccess) {
                    accessResult.setPolicyId(-1L);
                }
                resultProcessor.processResult(accessResult);
            }
        }
    }

    private RangerServiceDef getDefaultServiceDef() {
        RangerServiceDef ret = null;
        if (StringUtils.isNotBlank((String)this.getServiceType())) {
            try {
                ret = EmbeddedServiceDefsUtil.instance().getEmbeddedServiceDef(this.getServiceType());
            }
            catch (Exception exp) {
                LOG.error((Object)("Could not get embedded service-def for " + this.getServiceType()));
            }
        }
        return ret;
    }

    private ServicePolicies getDefaultSvcPolicies() {
        ServicePolicies ret = null;
        RangerServiceDef serviceDef = this.getServiceDef();
        if (serviceDef == null) {
            serviceDef = this.getDefaultServiceDef();
        }
        if (serviceDef != null) {
            ret = new ServicePolicies();
            ret.setServiceDef(serviceDef);
            ret.setServiceName(this.getServiceName());
            ret.setPolicies(new ArrayList<RangerPolicy>());
        }
        return ret;
    }

    public boolean logErrorMessage(String message) {
        LogHistory log = this.logHistoryList.get(message);
        if (log == null) {
            log = new LogHistory();
            this.logHistoryList.put(message, log);
        }
        if (System.currentTimeMillis() - log.lastLogTime > 30000L) {
            log.lastLogTime = System.currentTimeMillis();
            int counter = log.counter;
            log.counter = 0;
            if (counter > 0) {
                message = message + ". Messages suppressed before: " + counter;
            }
            LOG.error((Object)message);
            return true;
        }
        ++log.counter;
        return false;
    }

    private Set<String> toSet(String value) {
        return StringUtils.isNotBlank((String)value) ? StringUtil.toSet(value) : Collections.emptySet();
    }

    private RangerTagEnricher getTagEnricher() {
        Map<RangerContextEnricher, Object> contextEnricherMap;
        RangerTagEnricher ret = null;
        RangerAuthContext authContext = this.getCurrentRangerAuthContext();
        if (authContext != null && MapUtils.isNotEmpty(contextEnricherMap = authContext.getRequestContextEnrichers())) {
            Set<RangerContextEnricher> contextEnrichers = contextEnricherMap.keySet();
            for (RangerContextEnricher enricher : contextEnrichers) {
                if (!(enricher instanceof RangerTagEnricher)) continue;
                ret = (RangerTagEnricher)enricher;
                break;
            }
        }
        return ret;
    }

    private RangerAdminClient getAdminClient() throws Exception {
        RangerAdminClient admin;
        PolicyRefresher refresher = this.refresher;
        RangerAdminClient rangerAdminClient = admin = refresher == null ? null : refresher.getRangerAdminClient();
        if (admin == null) {
            throw new Exception("ranger-admin client is null");
        }
        return admin;
    }

    private List<RangerChainedPlugin> initChainedPlugins() {
        ArrayList<RangerChainedPlugin> ret = new ArrayList<RangerChainedPlugin>();
        String chainedServicePropPrefix = this.pluginConfig.getPropertyPrefix() + ".chained.services";
        for (String chainedService : StringUtil.toList(this.pluginConfig.get(chainedServicePropPrefix))) {
            if (StringUtils.isBlank((String)chainedService)) continue;
            String className = this.pluginConfig.get(chainedServicePropPrefix + "." + chainedService + ".impl");
            if (StringUtils.isBlank((String)className)) {
                LOG.error((Object)("Ignoring chained service " + chainedService + ": no impl class specified"));
                continue;
            }
            try {
                Class<?> pluginClass = Class.forName(className);
                RangerChainedPlugin chainedPlugin = (RangerChainedPlugin)pluginClass.getConstructor(RangerBasePlugin.class, String.class).newInstance(this, chainedService);
                ret.add(chainedPlugin);
            }
            catch (Throwable t) {
                LOG.error((Object)("initChainedPlugins(): error instantiating plugin impl " + className), t);
            }
        }
        return ret;
    }

    private void updateResultFromChainedResult(RangerAccessResult result, RangerAccessResult chainedResult) {
        boolean overrideResult = false;
        if (chainedResult.getIsAccessDetermined()) {
            boolean bl = overrideResult = !result.getIsAccessDetermined() || chainedResult.getPolicyPriority() > result.getPolicyPriority();
            if (!overrideResult && chainedResult.getPolicyPriority() == result.getPolicyPriority() && !chainedResult.getIsAllowed() && result.getIsAllowed()) {
                overrideResult = true;
            }
        }
        if (overrideResult) {
            result.setIsAllowed(chainedResult.getIsAllowed());
            result.setIsAccessDetermined(chainedResult.getIsAccessDetermined());
            result.setPolicyId(chainedResult.getPolicyId());
            result.setPolicyVersion(chainedResult.getPolicyVersion());
            result.setPolicyPriority(chainedResult.getPolicyPriority());
            result.setZoneName(chainedResult.getZoneName());
        }
        if (!result.getIsAuditedDetermined() && chainedResult.getIsAuditedDetermined()) {
            result.setIsAudited(chainedResult.getIsAudited());
            result.setAuditPolicyId(chainedResult.getAuditPolicyId());
        }
    }

    private static AuditProviderFactory getAuditProviderFactory(String serviceName) {
        AuditProviderFactory ret = AuditProviderFactory.getInstance();
        if (!ret.isInitDone()) {
            RangerAuditConfig conf;
            LOG.warn((Object)("RangerBasePlugin.getAuditProviderFactory(serviceName=" + serviceName + "): audit not initialized yet. Will use stand-alone audit factory"));
            ret = StandAloneAuditProviderFactory.getInstance();
            if (!ret.isInitDone() && (conf = new RangerAuditConfig()).isInitSuccess()) {
                ret.init(conf.getProperties(), "StandAlone");
            }
        }
        return ret;
    }

    private static final class LogHistory {
        long lastLogTime;
        int counter;

        private LogHistory() {
        }
    }
}

