/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.service;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.service.RangerBasePlugin;

public abstract class RangerChainedPlugin {
    private static final Log LOG = LogFactory.getLog(RangerChainedPlugin.class);
    protected final RangerBasePlugin rootPlugin;
    protected final String serviceType;
    protected final String serviceName;
    protected final RangerBasePlugin plugin;

    protected RangerChainedPlugin(RangerBasePlugin rootPlugin, String serviceType, String serviceName) {
        LOG.info((Object)("RangerChainedPlugin(" + serviceType + ", " + serviceName + ")"));
        this.rootPlugin = rootPlugin;
        this.serviceType = serviceType;
        this.serviceName = serviceName;
        this.plugin = this.buildChainedPlugin(serviceType, serviceName, rootPlugin.getAppId());
    }

    public void init() {
        LOG.info((Object)("==> RangerChainedPlugin.init(" + this.serviceType + ", " + this.serviceName + ")"));
        this.plugin.init();
        LOG.info((Object)("<== RangerChainedPlugin.init(" + this.serviceType + ", " + this.serviceName + ")"));
    }

    protected RangerBasePlugin buildChainedPlugin(String serviceType, String serviceName, String appId) {
        return new RangerBasePlugin(serviceType, serviceName, appId);
    }

    public abstract RangerAccessResult isAccessAllowed(RangerAccessRequest var1);

    public abstract Collection<RangerAccessResult> isAccessAllowed(Collection<RangerAccessRequest> var1);
}

