/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.admin.client.RangerAdminClient;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.ranger.plugin.util.DownloadTrigger;
import org.apache.ranger.plugin.util.DownloaderTask;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerRolesProvider;
import org.apache.ranger.plugin.util.RangerServiceNotFoundException;
import org.apache.ranger.plugin.util.ServicePolicies;

public class PolicyRefresher
extends Thread {
    private static final Log LOG = LogFactory.getLog(PolicyRefresher.class);
    private static final Log PERF_POLICYENGINE_INIT_LOG = RangerPerfTracer.getPerfLogger("policyengine.init");
    private final RangerBasePlugin plugIn;
    private final String serviceType;
    private final String serviceName;
    private final RangerAdminClient rangerAdmin;
    private final RangerRolesProvider rolesProvider;
    private final long pollingIntervalMs;
    private final String cacheFileName;
    private final String cacheDir;
    private final Gson gson;
    private final BlockingQueue<DownloadTrigger> policyDownloadQueue = new LinkedBlockingQueue<DownloadTrigger>();
    private Timer policyDownloadTimer;
    private long lastKnownVersion = -1L;
    private long lastActivationTimeInMillis;
    private boolean policiesSetInPlugin;
    private boolean serviceDefSetInPlugin;

    public PolicyRefresher(RangerBasePlugin plugIn) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> PolicyRefresher(serviceName=" + plugIn.getServiceName() + ").PolicyRefresher()"));
        }
        RangerPluginConfig pluginConfig = plugIn.getConfig();
        String propertyPrefix = pluginConfig.getPropertyPrefix();
        this.plugIn = plugIn;
        this.serviceType = plugIn.getServiceType();
        this.serviceName = plugIn.getServiceName();
        this.cacheDir = pluginConfig.get(propertyPrefix + ".policy.cache.dir");
        String appId = StringUtils.isEmpty((String)plugIn.getAppId()) ? this.serviceType : plugIn.getAppId();
        String cacheFilename = String.format("%s_%s.json", appId, this.serviceName);
        cacheFilename = cacheFilename.replace(File.separatorChar, '_');
        this.cacheFileName = cacheFilename = cacheFilename.replace(File.pathSeparatorChar, '_');
        Gson gson = null;
        try {
            gson = new GsonBuilder().setDateFormat("yyyyMMdd-HH:mm:ss.SSS-Z").create();
        }
        catch (Throwable excp) {
            LOG.fatal((Object)"PolicyRefresher(): failed to create GsonBuilder object", excp);
        }
        this.gson = gson;
        this.rangerAdmin = RangerBasePlugin.createAdminClient(pluginConfig);
        this.rolesProvider = new RangerRolesProvider(this.getServiceType(), appId, this.getServiceName(), this.rangerAdmin, this.cacheDir, pluginConfig);
        this.pollingIntervalMs = pluginConfig.getLong(propertyPrefix + ".policy.pollIntervalMs", 30000L);
        this.setName("PolicyRefresher(serviceName=" + this.serviceName + ")-" + this.getId());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyRefresher(serviceName=" + this.serviceName + ").PolicyRefresher()"));
        }
    }

    public RangerBasePlugin getPlugin() {
        return this.plugIn;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public RangerAdminClient getRangerAdminClient() {
        return this.rangerAdmin;
    }

    public long getLastActivationTimeInMillis() {
        return this.lastActivationTimeInMillis;
    }

    public void setLastActivationTimeInMillis(long lastActivationTimeInMillis) {
        this.lastActivationTimeInMillis = lastActivationTimeInMillis;
    }

    public void startRefresher() {
        this.loadRoles();
        this.loadPolicy();
        super.start();
        this.policyDownloadTimer = new Timer("policyDownloadTimer", true);
        try {
            this.policyDownloadTimer.schedule((TimerTask)new DownloaderTask(this.policyDownloadQueue), this.pollingIntervalMs, this.pollingIntervalMs);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Scheduled policyDownloadRefresher to download policies every " + this.pollingIntervalMs + " milliseconds"));
            }
        }
        catch (IllegalStateException exception) {
            LOG.error((Object)"Error scheduling policyDownloadTimer:", (Throwable)exception);
            LOG.error((Object)("*** Policies will NOT be downloaded every " + this.pollingIntervalMs + " milliseconds ***"));
            this.policyDownloadTimer = null;
        }
    }

    public void stopRefresher() {
        Timer policyDownloadTimer = this.policyDownloadTimer;
        this.policyDownloadTimer = null;
        if (policyDownloadTimer != null) {
            policyDownloadTimer.cancel();
        }
        if (super.isAlive()) {
            super.interrupt();
            boolean setInterrupted = false;
            boolean isJoined = false;
            while (!isJoined) {
                try {
                    super.join();
                    isJoined = true;
                }
                catch (InterruptedException excp) {
                    LOG.warn((Object)("PolicyRefresher(serviceName=" + this.serviceName + "): error while waiting for thread to exit"), (Throwable)excp);
                    LOG.warn((Object)"Retrying Thread.join(). Current thread will be marked as 'interrupted' after Thread.join() returns");
                    setInterrupted = true;
                }
            }
            if (setInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> PolicyRefresher(serviceName=" + this.serviceName + ").run()"));
        }
        while (true) {
            DownloadTrigger trigger = null;
            try {
                trigger = this.policyDownloadQueue.take();
                this.loadRoles();
                this.loadPolicy();
                continue;
            }
            catch (InterruptedException excp) {
                LOG.info((Object)("PolicyRefresher(serviceName=" + this.serviceName + ").run(): interrupted! Exiting thread"), (Throwable)excp);
            }
            finally {
                if (trigger == null) continue;
                trigger.signalCompletion();
                continue;
            }
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyRefresher(serviceName=" + this.serviceName + ").run()"));
        }
    }

    public void syncPoliciesWithAdmin(DownloadTrigger token) throws InterruptedException {
        this.policyDownloadQueue.put(token);
        token.waitForCompletion();
    }

    private void loadPolicy() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> PolicyRefresher(serviceName=" + this.serviceName + ").loadPolicy()"));
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "PolicyRefresher.loadPolicy(serviceName=" + this.serviceName + ")");
            long freeMemory = Runtime.getRuntime().freeMemory();
            long totalMemory = Runtime.getRuntime().totalMemory();
            PERF_POLICYENGINE_INIT_LOG.debug((Object)("In-Use memory: " + (totalMemory - freeMemory) + ", Free memory:" + freeMemory));
        }
        try {
            ServicePolicies svcPolicies = this.loadPolicyfromPolicyAdmin();
            if (svcPolicies == null && !this.policiesSetInPlugin) {
                svcPolicies = this.loadFromCache();
            }
            if (PERF_POLICYENGINE_INIT_LOG.isDebugEnabled()) {
                long freeMemory = Runtime.getRuntime().freeMemory();
                long totalMemory = Runtime.getRuntime().totalMemory();
                PERF_POLICYENGINE_INIT_LOG.debug((Object)("In-Use memory: " + (totalMemory - freeMemory) + ", Free memory:" + freeMemory));
            }
            if (svcPolicies != null) {
                this.plugIn.setPolicies(svcPolicies);
                this.policiesSetInPlugin = true;
                this.serviceDefSetInPlugin = false;
                this.setLastActivationTimeInMillis(System.currentTimeMillis());
                this.lastKnownVersion = svcPolicies.getPolicyVersion() != null ? svcPolicies.getPolicyVersion() : -1L;
            } else if (!this.policiesSetInPlugin && !this.serviceDefSetInPlugin) {
                this.plugIn.setPolicies(null);
                this.serviceDefSetInPlugin = true;
            }
        }
        catch (RangerServiceNotFoundException snfe) {
            if (!this.serviceDefSetInPlugin) {
                this.disableCache();
                this.plugIn.setPolicies(null);
                this.serviceDefSetInPlugin = true;
                this.setLastActivationTimeInMillis(System.currentTimeMillis());
                this.lastKnownVersion = -1L;
            }
        }
        catch (Exception excp) {
            LOG.error((Object)"Encountered unexpected exception, ignoring..", (Throwable)excp);
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyRefresher(serviceName=" + this.serviceName + ").loadPolicy()"));
        }
    }

    private ServicePolicies loadPolicyfromPolicyAdmin() throws RangerServiceNotFoundException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> PolicyRefresher(serviceName=" + this.serviceName + ").loadPolicyfromPolicyAdmin()"));
        }
        ServicePolicies svcPolicies = null;
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "PolicyRefresher.loadPolicyFromPolicyAdmin(serviceName=" + this.serviceName + ")");
        }
        try {
            boolean isUpdated;
            svcPolicies = this.rangerAdmin.getServicePoliciesIfUpdated(this.lastKnownVersion, this.lastActivationTimeInMillis);
            boolean bl = isUpdated = svcPolicies != null;
            if (isUpdated) {
                long newVersion;
                long l = newVersion = svcPolicies.getPolicyVersion() == null ? -1L : svcPolicies.getPolicyVersion();
                if (!StringUtils.equals((String)this.serviceName, (String)svcPolicies.getServiceName())) {
                    LOG.warn((Object)("PolicyRefresher(serviceName=" + this.serviceName + "): ignoring unexpected serviceName '" + svcPolicies.getServiceName() + "' in service-store"));
                    svcPolicies.setServiceName(this.serviceName);
                }
                LOG.info((Object)("PolicyRefresher(serviceName=" + this.serviceName + "): found updated version. lastKnownVersion=" + this.lastKnownVersion + "; newVersion=" + newVersion));
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("PolicyRefresher(serviceName=" + this.serviceName + ").run(): no update found. lastKnownVersion=" + this.lastKnownVersion));
            }
        }
        catch (RangerServiceNotFoundException snfe) {
            LOG.error((Object)("PolicyRefresher(serviceName=" + this.serviceName + "): failed to find service. Will clean up local cache of policies (" + this.lastKnownVersion + ")"), (Throwable)snfe);
            throw snfe;
        }
        catch (Exception excp) {
            LOG.error((Object)("PolicyRefresher(serviceName=" + this.serviceName + "): failed to refresh policies. Will continue to use last known version of policies (" + this.lastKnownVersion + ")"), (Throwable)excp);
            svcPolicies = null;
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyRefresher(serviceName=" + this.serviceName + ").loadPolicyfromPolicyAdmin()"));
        }
        return svcPolicies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServicePolicies loadFromCache() {
        ServicePolicies policies;
        block18: {
            File cacheFile;
            block19: {
                RangerPerfTracer perf;
                FileReader reader;
                block17: {
                    policies = null;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("==> PolicyRefresher(serviceName=" + this.serviceName + ").loadFromCache()"));
                    }
                    File file = cacheFile = this.cacheDir == null ? null : new File(this.cacheDir + File.separator + this.cacheFileName);
                    if (cacheFile == null || !cacheFile.isFile() || !cacheFile.canRead()) break block19;
                    reader = null;
                    perf = null;
                    if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
                        perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "PolicyRefresher.loadFromCache(serviceName=" + this.serviceName + ")");
                    }
                    try {
                        reader = new FileReader(cacheFile);
                        policies = (ServicePolicies)this.gson.fromJson((Reader)reader, ServicePolicies.class);
                        if (policies == null) break block17;
                        if (!StringUtils.equals((String)this.serviceName, (String)policies.getServiceName())) {
                            LOG.warn((Object)("ignoring unexpected serviceName '" + policies.getServiceName() + "' in cache file '" + cacheFile.getAbsolutePath() + "'"));
                            policies.setServiceName(this.serviceName);
                        }
                        this.lastKnownVersion = policies.getPolicyVersion() == null ? -1L : policies.getPolicyVersion();
                    }
                    catch (Exception excp) {
                        try {
                            LOG.error((Object)("failed to load policies from cache file " + cacheFile.getAbsolutePath()), (Throwable)excp);
                        }
                        catch (Throwable throwable) {
                            RangerPerfTracer.log(perf);
                            if (reader != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Exception excp2) {
                                    LOG.error((Object)("error while closing opened cache file " + cacheFile.getAbsolutePath()), (Throwable)excp2);
                                }
                            }
                            throw throwable;
                        }
                        RangerPerfTracer.log(perf);
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Exception excp3) {
                                LOG.error((Object)("error while closing opened cache file " + cacheFile.getAbsolutePath()), (Throwable)excp3);
                            }
                        }
                        break block18;
                    }
                }
                RangerPerfTracer.log(perf);
                if (reader != null) {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Exception excp) {
                        LOG.error((Object)("error while closing opened cache file " + cacheFile.getAbsolutePath()), (Throwable)excp);
                    }
                }
                break block18;
            }
            LOG.warn((Object)("cache file does not exist or not readable '" + (cacheFile == null ? null : cacheFile.getAbsolutePath()) + "'"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyRefresher(serviceName=" + this.serviceName + ").loadFromCache()"));
        }
        return policies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToCache(ServicePolicies policies) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> PolicyRefresher(serviceName=" + this.serviceName + ").saveToCache()"));
        }
        if (policies != null) {
            File cacheFile = null;
            if (this.cacheDir != null) {
                File cacheDirTmp = new File(this.cacheDir);
                if (cacheDirTmp.exists()) {
                    cacheFile = new File(this.cacheDir + File.separator + this.cacheFileName);
                } else {
                    try {
                        cacheDirTmp.mkdirs();
                        cacheFile = new File(this.cacheDir + File.separator + this.cacheFileName);
                    }
                    catch (SecurityException ex) {
                        LOG.error((Object)"Cannot create cache directory", (Throwable)ex);
                    }
                }
            }
            if (cacheFile != null) {
                RangerPerfTracer perf = null;
                if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
                    perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "PolicyRefresher.saveToCache(serviceName=" + this.serviceName + ")");
                }
                FileWriter writer = null;
                try {
                    writer = new FileWriter(cacheFile);
                    this.gson.toJson((Object)policies, (Appendable)writer);
                }
                catch (Exception excp) {
                    LOG.error((Object)("failed to save policies to cache file '" + cacheFile.getAbsolutePath() + "'"), (Throwable)excp);
                }
                finally {
                    if (writer != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Exception excp) {
                            LOG.error((Object)("error while closing opened cache file '" + cacheFile.getAbsolutePath() + "'"), (Throwable)excp);
                        }
                    }
                }
                RangerPerfTracer.log(perf);
            }
        } else {
            LOG.info((Object)"policies is null. Nothing to save in cache");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyRefresher(serviceName=" + this.serviceName + ").saveToCache()"));
        }
    }

    private void disableCache() {
        File cacheFile;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> PolicyRefresher.disableCache(serviceName=" + this.serviceName + ")"));
        }
        File file = cacheFile = this.cacheDir == null ? null : new File(this.cacheDir + File.separator + this.cacheFileName);
        if (cacheFile != null && cacheFile.isFile() && cacheFile.canRead()) {
            LOG.warn((Object)"Cleaning up local cache");
            String renamedCacheFile = cacheFile.getAbsolutePath() + "_" + System.currentTimeMillis();
            if (!cacheFile.renameTo(new File(renamedCacheFile))) {
                LOG.error((Object)("Failed to move " + cacheFile.getAbsolutePath() + " to " + renamedCacheFile));
            } else {
                LOG.warn((Object)("Moved " + cacheFile.getAbsolutePath() + " to " + renamedCacheFile));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"No local policy cache found. No need to disable it!");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyRefresher.disableCache(serviceName=" + this.serviceName + ")"));
        }
    }

    private void loadRoles() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> PolicyRefresher(serviceName=" + this.serviceName + ").loadRoles()"));
        }
        this.rolesProvider.loadUserGroupRoles(this.plugIn);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyRefresher(serviceName=" + this.serviceName + ").loadRoles()"));
        }
    }
}

