/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.naaf;

import com.cloudera.naaf.FunctionIdProvider;
import com.cloudera.naaf.metering.CloudPlatform;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

public class StandardFunctionIdProvider
implements FunctionIdProvider {
    private static final String VERSION_SEPARATOR = "/v.";

    @Override
    public String generateFunctionId(String flowCrn, String functionName, CloudPlatform cloudPlatform) {
        if (flowCrn == null || functionName == null || cloudPlatform == null) {
            throw new IllegalArgumentException("The following fields are required: flowCrn, functionName, cloudPlatform");
        }
        int lastIndexOfVersionSeparator = flowCrn.lastIndexOf(VERSION_SEPARATOR);
        boolean isFlowVersionCrn = lastIndexOfVersionSeparator >= 0;
        String normalizedFlowCrn = isFlowVersionCrn ? flowCrn.substring(0, lastIndexOfVersionSeparator).trim().toLowerCase() : flowCrn.trim().toLowerCase();
        String normalizedFunctionName = functionName.trim().toLowerCase();
        String normalizedCloudProvider = cloudPlatform.getCloudProvider();
        if (normalizedFlowCrn.isEmpty() || normalizedFunctionName.isEmpty() || normalizedCloudProvider.isEmpty()) {
            throw new IllegalArgumentException("The following fields cannot be blank: flowCrn, functionName, cloudPlatform");
        }
        String functionIdInputString = String.format("%s+%s+%s", normalizedFlowCrn, normalizedFunctionName, normalizedCloudProvider);
        String functionId = UUID.nameUUIDFromBytes(functionIdInputString.getBytes(StandardCharsets.UTF_8)).toString();
        return functionId;
    }
}

