/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.naaf;

import com.cloudera.naaf.StandardFunctionIdProvider;
import com.cloudera.naaf.StatelessFunctionConfiguration;
import com.cloudera.naaf.StatelessNiFiFunction;
import com.cloudera.naaf.StatelessNiFiStateProvider;
import com.cloudera.naaf.StatelessNiFiUtil;
import com.cloudera.naaf.download.DfxFlowDownload;
import com.cloudera.naaf.metering.Invocation;
import com.cloudera.naaf.metering.MeteringException;
import com.cloudera.naaf.metering.MeteringPublisher;
import com.cloudera.naaf.metering.StandardInvocation;
import com.cloudera.naaf.resources.ResourceDownloader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.stateless.bootstrap.StatelessBootstrap;
import org.apache.nifi.stateless.config.ExtensionClientDefinition;
import org.apache.nifi.stateless.config.SslContextDefinition;
import org.apache.nifi.stateless.engine.StatelessEngineConfiguration;
import org.apache.nifi.stateless.flow.DataflowDefinition;
import org.apache.nifi.stateless.flow.DataflowTrigger;
import org.apache.nifi.stateless.flow.StatelessDataflow;
import org.apache.nifi.stateless.flow.TriggerResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardStatelessNiFiFunction
implements StatelessNiFiFunction {
    private static final Logger logger = LoggerFactory.getLogger(StandardStatelessNiFiFunction.class);
    private static final String DEFAULT_DFX_URL = "https://api.us-west-1.cdp.cloudera.com";
    private static final String BILLING_PUBLISHER_CLASS = "com.cloudera.naaf.metering.DbusMeteringPublisher";
    private static final String DEFAULT_SENSITIVE_PROPS_VALUE = "nifi-function";
    private static final String DEFAULT_NEXUS_BASE_URL = "https://repository.cloudera.com/artifactory/cloudera-repos/";
    private static final String SNAPSHOT_CONTENTS_PROPERTY_NAME = "nifi.stateless.flow.snapshot.contents";
    private static final String FAILURE_PORT_NAMES_PROPERTY_NAME = "nifi.stateless.failure.port.names";
    private static final String STATELESS_FUNCTION_BOOTSTRAP_LIB = "stateless-function-bootstrap-lib";
    private static final File DEFAULT_WORKING_DIRECTORY = new File(StatelessNiFiFunction.TEMP_DIR, "working");
    private static final String HASH_FILENAME = "nar-digest";
    private static final String NAR_UNPACKED_SUFFIX = "nar-unpacked";
    private final MeteringPublisher meteringPublisher;
    private ClassLoader rootClassLoader;
    private ClassLoader functionBootstrapClassLoader;
    private static final ConcurrentMap<String, StatelessDataflow> dataflowMap = new ConcurrentHashMap<String, StatelessDataflow>();
    private StatelessDataflow dataflow;
    private String outputPortOfInterest;
    private String flowVersionCrn;
    private String functionId;
    private final String functionName;
    private final String functionVersion;
    private final StatelessFunctionConfiguration statelessFunctionConfiguration;
    private StatelessNiFiStateProvider stateProvider = null;

    public StandardStatelessNiFiFunction(String functionName, String functionVersion, StatelessFunctionConfiguration statelessFunctionConfiguration) throws IOException {
        if (functionName == null || functionVersion == null) {
            throw new IllegalArgumentException("Function name and version must be provided");
        }
        this.functionName = functionName;
        this.functionVersion = functionVersion;
        this.statelessFunctionConfiguration = statelessFunctionConfiguration;
        this.meteringPublisher = (MeteringPublisher)this.instantiateWithBoostrapClassloader(BILLING_PUBLISHER_CLASS);
        this.initialize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TriggerResult trigger(String instanceId, InputStream inputStream, Map<String, String> inputAttributes) {
        TriggerResult triggerResult2;
        long startNanos = System.nanoTime();
        Instant startInstant = Instant.now();
        boolean successfulInvocation = false;
        TriggerResult triggerResult = null;
        try {
            logger.info("Triggering Stateless NiFi Function {} version {} for Dataflow {}", new Object[]{this.functionName, this.functionVersion, this.flowVersionCrn});
            if (this.stateProvider == null && this.dataflow.isStateful()) {
                logger.warn("The dataflow stores state, but the StateProvider is not enabled");
            }
            this.setDataflowState(instanceId, Scope.LOCAL);
            this.setDataflowState(instanceId, Scope.CLUSTER);
            if (this.dataflow.getInputPortNames().isEmpty()) {
                logger.info("Ignoring input, since this dataflow has no Input Ports");
            } else {
                this.enqueueFlowFile(inputStream, inputAttributes);
            }
            DataflowTrigger trigger = this.dataflow.trigger();
            triggerResult = trigger.getResult();
            if (triggerResult.isSuccessful()) {
                successfulInvocation = true;
            }
            this.storeDataflowState(instanceId, Scope.LOCAL);
            this.storeDataflowState(instanceId, Scope.CLUSTER);
            logger.debug("Returning {} trigger result", (Object)(successfulInvocation ? "successful" : "failure"));
            triggerResult2 = triggerResult;
        }
        catch (InterruptedException e) {
            try {
                Thread.currentThread().interrupt();
                logger.error("Interrupted while running dataflow", (Throwable)e);
                throw new RuntimeException("Interrupted while running dataflow", e);
            }
            catch (Throwable throwable) {
                StandardInvocation invocation2 = StandardInvocation.builder().durationNanos(System.nanoTime() - startNanos).startTime(startInstant).functionId(this.functionId).functionName(this.functionName).region(this.statelessFunctionConfiguration.getRegion()).cloudPlatform(this.statelessFunctionConfiguration.getCloudPlatform()).flowCrn(this.flowVersionCrn).successful(successfulInvocation).build();
                try {
                    this.withFunctionBootstrapClassloader(() -> this.lambda$trigger$0((Invocation)invocation2));
                    throw throwable;
                }
                catch (MeteringException e2) {
                    logger.error(e2.isInvocationSuccess() ? "Dataflow completed successfully, but failed to publish to metering" : "Dataflow execution failed, and failed to publish to metering", (Throwable)e2);
                    return new DelegatingTriggerResult(triggerResult, e2.isInvocationSuccess(), e2);
                }
            }
        }
        StandardInvocation invocation = StandardInvocation.builder().durationNanos(System.nanoTime() - startNanos).startTime(startInstant).functionId(this.functionId).functionName(this.functionName).region(this.statelessFunctionConfiguration.getRegion()).cloudPlatform(this.statelessFunctionConfiguration.getCloudPlatform()).flowCrn(this.flowVersionCrn).successful(successfulInvocation).build();
        try {
            this.withFunctionBootstrapClassloader(() -> this.lambda$trigger$0((Invocation)invocation));
            return triggerResult2;
        }
        catch (MeteringException e) {
            logger.error(e.isInvocationSuccess() ? "Dataflow completed successfully, but failed to publish to metering" : "Dataflow execution failed, and failed to publish to metering", (Throwable)e);
            return new DelegatingTriggerResult(triggerResult, e.isInvocationSuccess(), e);
        }
    }

    public void trigger(String instanceId, InputStream inputStream, Map<String, String> inputAttributes, OutputStream outputStream) throws IOException {
        TriggerResult triggerResult = this.trigger(instanceId, inputStream, inputAttributes);
        FlowFile outputFlowFile = this.getOutputFlowfile(triggerResult);
        StatelessNiFiUtil.copyOutput(outputFlowFile, triggerResult, outputStream);
        StatelessNiFiUtil.handleTriggerResult(triggerResult);
    }

    private void initialize() throws IOException {
        String dfxUrl = System.getenv("DF_SERVICE_URL");
        if (dfxUrl == null) {
            dfxUrl = DEFAULT_DFX_URL;
        }
        this.flowVersionCrn = this.getRequiredEnv("FLOW_CRN");
        String privateKey = this.getRequiredEnv("DF_PRIVATE_KEY");
        String accessKey = this.getRequiredEnv("DF_ACCESS_KEY");
        this.functionId = new StandardFunctionIdProvider().generateFunctionId(this.flowVersionCrn, this.functionName, this.statelessFunctionConfiguration.getCloudPlatform());
        this.checkWorkingDirectoryIntegrity();
        StatelessDataflow existingDataflow = (StatelessDataflow)dataflowMap.get(this.flowVersionCrn);
        if (existingDataflow == null) {
            logger.info("Creating dataflow for CRN {}", (Object)this.flowVersionCrn);
            byte[] dataflowContents = this.fetchDataflow(dfxUrl, this.flowVersionCrn, privateKey, accessKey);
            String dataflowJson = new String(dataflowContents, StandardCharsets.UTF_8);
            logger.debug("Downloaded the following definition for Flow CRN {}:\n{}", (Object)this.flowVersionCrn, (Object)dataflowJson);
            StatelessDataflow createdDataflow = this.createDataflow(dataflowJson);
            createdDataflow.initialize();
            dataflowMap.put(this.flowVersionCrn, createdDataflow);
            this.dataflow = createdDataflow;
        } else {
            logger.info("Dataflow already exists for CRN {}. Will use cached dataflow.", (Object)this.flowVersionCrn);
            this.dataflow = existingDataflow;
        }
        this.validatePortNames();
        this.outputPortOfInterest = this.getOutputPortOfInterest(this.dataflow);
        this.initializeStateProvider();
        this.withFunctionBootstrapClassloader(() -> this.meteringPublisher.initialize());
    }

    private void checkWorkingDirectoryIntegrity() {
        File workingDirectory = this.getWorkingDirectory();
        this.purgeIncompleteUnpackedNars(new File(workingDirectory, "nar/extensions"));
        this.purgeIncompleteUnpackedNars(new File(workingDirectory, "extensions"));
    }

    private void purgeIncompleteUnpackedNars(File directory) {
        File[] unpackedDirs = directory.listFiles(file -> file.isDirectory() && file.getName().endsWith(NAR_UNPACKED_SUFFIX));
        if (unpackedDirs == null || unpackedDirs.length == 0) {
            logger.debug("Found no unpacked NARs in {}", (Object)directory);
            logger.debug("Directory contains: {}", (Object)Arrays.deepToString(directory.listFiles()));
            return;
        }
        for (File unpackedDir : unpackedDirs) {
            File narHashFile = new File(unpackedDir, HASH_FILENAME);
            if (!narHashFile.exists()) {
                this.purgeDirectory(unpackedDir);
                continue;
            }
            logger.debug("Already successfully unpacked {}", (Object)unpackedDir);
        }
    }

    private void purgeDirectory(File directory) {
        if (directory.exists()) {
            StandardStatelessNiFiFunction.deleteRecursively(directory);
            logger.debug("Cleaned up {}", (Object)directory);
        }
    }

    private static void deleteRecursively(File fileOrDirectory) {
        File[] files;
        if (fileOrDirectory.isDirectory() && (files = fileOrDirectory.listFiles()) != null) {
            for (File file : files) {
                StandardStatelessNiFiFunction.deleteRecursively(file);
            }
        }
        StandardStatelessNiFiFunction.deleteOrDebug(fileOrDirectory);
    }

    private static void deleteOrDebug(File file) {
        boolean deleted = file.delete();
        if (!deleted) {
            logger.debug("Failed to cleanup temporary file {}", (Object)file);
        }
    }

    protected String getRequiredEnv(String environmentVariableName) {
        String value = System.getenv(environmentVariableName);
        if (value == null) {
            throw new IllegalStateException("Invalid Function Configuration: The " + environmentVariableName + " Environment Variable must be specified");
        }
        return value;
    }

    private void validatePortNames() {
        String inputPortName = System.getenv("INPUT_PORT");
        if (inputPortName != null) {
            Set inputPorts = this.dataflow.getInputPortNames();
            if (inputPorts.isEmpty()) {
                throw new IllegalArgumentException(String.format("The %s Environment Variable indicates that the dataflow should enqueue data to the '%s' Input Port, but the configured dataflow has no Input Ports", "INPUT_PORT"));
            }
            if (!inputPorts.contains(inputPortName)) {
                throw new IllegalArgumentException(String.format("The %s Environment Variable indicates that the dataflow should enqueue data to the '%s' Input Port, but the configured dataflow does not have an Input Port with this name. Valid Ports: %s", "INPUT_PORT", inputPortName, inputPorts));
            }
        } else if (this.dataflow.getInputPortNames().size() > 1) {
            throw new IllegalArgumentException(String.format("Since the dataflow contains more than one Input Port, the %s Environment Variable is required", "INPUT_PORT"));
        }
    }

    private ClassLoader getRootClassLoader() throws IOException {
        if (this.rootClassLoader == null) {
            this.rootClassLoader = this.createRootClassLoader();
        }
        return this.rootClassLoader;
    }

    private ClassLoader createRootClassLoader() throws IOException {
        return this.createURLClassLoader(this.detectNarDirectory(), StandardStatelessNiFiFunction.class.getClassLoader());
    }

    private ClassLoader createFunctionBootstrapClassLoader(ClassLoader systemClassLoader) throws IOException {
        return this.createURLClassLoader(new File(this.detectNarDirectory(), STATELESS_FUNCTION_BOOTSTRAP_LIB), systemClassLoader);
    }

    private ClassLoader getFunctionBootstrapClassLoader() {
        if (this.functionBootstrapClassLoader == null) {
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader functionSystemClassLoader = this.statelessFunctionConfiguration.getSystemClassLoader();
            try {
                this.functionBootstrapClassLoader = functionSystemClassLoader == null ? originalClassLoader : this.createFunctionBootstrapClassLoader(this.statelessFunctionConfiguration.getSystemClassLoader());
            }
            catch (IOException e) {
                logger.error("Could not create function bootstrap classloader", (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return this.functionBootstrapClassLoader;
    }

    private ClassLoader createURLClassLoader(File libraryDirectory, ClassLoader systemClassLoader) throws IOException {
        File[] jarFiles = libraryDirectory.listFiles(file -> file.getName().endsWith(".jar"));
        if (jarFiles == null) {
            throw new IOException("Could not access library directory " + libraryDirectory.getAbsolutePath());
        }
        int i = 0;
        URL[] urls = new URL[jarFiles.length];
        for (File jarFile : jarFiles) {
            URL url = jarFile.toURI().toURL();
            urls[i++] = url;
        }
        logger.debug("Constructing function bootstrap classloader from URLs: {}", Arrays.asList(urls));
        return new URLClassLoader(urls, systemClassLoader);
    }

    private void initializeStateProvider() {
        String disableStateProvider = System.getenv("DISABLE_STATE_PROVIDER");
        boolean disabled = Boolean.TRUE.toString().equalsIgnoreCase(disableStateProvider);
        if (!this.dataflow.isStateful() || disabled || this.statelessFunctionConfiguration.getStateProviderType() == null) {
            if (!this.dataflow.isStateful()) {
                logger.info("Dataflow is not stateful, so the State Provider will not be configured.");
            }
            if (disabled) {
                logger.info("State Provider is disabled.");
            }
            return;
        }
        logger.info("Dataflow is stateful: initializing State Provider");
        this.stateProvider = (StatelessNiFiStateProvider)this.instantiateWithBoostrapClassloader(this.statelessFunctionConfiguration.getStateProviderType());
    }

    private void setDataflowState(String instanceId, Scope scope) {
        if (this.stateProvider == null) {
            return;
        }
        if (instanceId == null || scope == null) {
            throw new IllegalArgumentException("Function Instance Identifier and scope are required");
        }
        StatelessNiFiStateProvider.StateScope stateScope = StatelessNiFiStateProvider.StateScope.valueOf((String)scope.name());
        Map state = null;
        try {
            state = this.getWithFunctionBootstrapClassloader(() -> this.stateProvider.retrieveState(instanceId, stateScope));
        }
        catch (Throwable t) {
            logger.error("Could not retrieve {} state for instance {}", new Object[]{scope, instanceId, t});
        }
        if (state != null) {
            this.dataflow.setComponentStates(state, scope);
        }
    }

    private void storeDataflowState(String instanceId, Scope scope) {
        if (this.stateProvider == null) {
            return;
        }
        if (instanceId == null || scope == null) {
            throw new IllegalArgumentException("Function Instance Identifier and scope is required");
        }
        StatelessNiFiStateProvider.StateScope stateScope = StatelessNiFiStateProvider.StateScope.valueOf((String)scope.name());
        Map state = this.dataflow.getComponentStates(scope);
        this.withFunctionBootstrapClassloader(() -> this.stateProvider.storeState(instanceId, stateScope, state));
        try {
            this.stateProvider.storeState(instanceId, stateScope, state);
        }
        catch (Throwable t) {
            logger.error("Could not store {} state for instance {}", new Object[]{scope, instanceId, t});
        }
    }

    private synchronized void download(String sourceDirectory, File downloadDirectory) {
        if (sourceDirectory == null || downloadDirectory == null) {
            return;
        }
        ResourceDownloader resourceDownloader = (ResourceDownloader)this.instantiateWithBoostrapClassloader(this.statelessFunctionConfiguration.getResourceDownloaderType());
        try {
            this.withFunctionBootstrapClassloader(() -> resourceDownloader.download(sourceDirectory, downloadDirectory));
        }
        catch (Throwable t) {
            logger.error("Failed to download {}", (Object)sourceDirectory, (Object)t);
        }
    }

    private StatelessDataflow createDataflow(String dataflowJson) throws IOException {
        StatelessEngineConfiguration engineConfiguration = this.createEngineConfiguration();
        try {
            ClassLoader rootClassLoader;
            StatelessBootstrap bootstrap;
            DataflowDefinition dataflowDefinition;
            Set<String> failurePortNames;
            HashMap<String, String> dataflowDefinitionProperties = new HashMap<String, String>();
            dataflowDefinitionProperties.put(SNAPSHOT_CONTENTS_PROPERTY_NAME, dataflowJson.trim());
            this.statelessFunctionConfiguration.applyFlowDefinitionConfigAction(dataflowDefinitionProperties);
            if (this.statelessFunctionConfiguration.getResourcesSourceDirectory() != null) {
                this.download(this.statelessFunctionConfiguration.getResourcesSourceDirectory(), this.statelessFunctionConfiguration.getResourcesDirectory());
            }
            if (this.statelessFunctionConfiguration.getExtensionsSourceDirectory() != null) {
                this.download(this.statelessFunctionConfiguration.getExtensionsSourceDirectory(), engineConfiguration.getExtensionsDirectory());
            }
            if (!(failurePortNames = this.getFailurePorts((dataflowDefinition = (bootstrap = StatelessBootstrap.bootstrap((StatelessEngineConfiguration)engineConfiguration, (ClassLoader)(rootClassLoader = this.getRootClassLoader()))).parseDataflowDefinition(dataflowDefinitionProperties, Collections.emptyList())).getOutputPortNames())).isEmpty()) {
                String failurePortString = String.join((CharSequence)",", failurePortNames);
                dataflowDefinitionProperties.put(FAILURE_PORT_NAMES_PROPERTY_NAME, failurePortString);
                dataflowDefinition = bootstrap.parseDataflowDefinition(dataflowDefinitionProperties, Collections.emptyList());
            }
            return bootstrap.createDataflow(dataflowDefinition);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to bootstrap Stateless NiFi Engine", e);
        }
    }

    private String getOutputPortOfInterest(StatelessDataflow dataflow) {
        Set outputPortNames = dataflow.getOutputPortNames();
        Set<String> failurePorts = this.getFailurePorts(outputPortNames);
        HashSet successPorts = new HashSet(outputPortNames);
        successPorts.removeAll(failurePorts);
        if (successPorts.isEmpty()) {
            return null;
        }
        if (successPorts.size() > 1) {
            throw new IllegalStateException("Found multiple Output Ports that are not considered failure ports: " + successPorts);
        }
        return (String)successPorts.iterator().next();
    }

    private Set<String> getFailurePorts(Set<String> outPorts) {
        String explicitFailurePorts = System.getenv("FAILURE_PORTS");
        if (explicitFailurePorts != null) {
            return this.splitCommaSeparated(explicitFailurePorts);
        }
        String explicitOutputPort = System.getenv("OUTPUT_PORT");
        if (explicitOutputPort != null) {
            HashSet<String> portsNotSpecified = new HashSet<String>(outPorts);
            portsNotSpecified.remove(explicitOutputPort);
            return portsNotSpecified;
        }
        Set<String> namedFailure = outPorts.stream().filter(name -> name.trim().equalsIgnoreCase("failure")).collect(Collectors.toSet());
        HashSet<String> nonFailurePorts = new HashSet<String>(outPorts);
        nonFailurePorts.removeAll(namedFailure);
        if (nonFailurePorts.size() <= 1) {
            return namedFailure;
        }
        throw new IllegalArgumentException("Could not determine which Output Ports are considered successful and which are considered failures. The following ports are ambiguous: " + nonFailurePorts + ". Only one Output Port is allowed to be considered successful. The name of the successful Output Port must be set using the Environment Variable " + "OUTPUT_PORT");
    }

    private Set<String> splitCommaSeparated(String input) {
        HashSet<String> splits = new HashSet<String>();
        for (String value : input.split(",")) {
            splits.add(value.trim());
        }
        return splits;
    }

    protected byte[] fetchDataflow(String dfxBaseUrl, String flowVersionCrn, String privateKey, String accessKey) throws IOException {
        long start = System.nanoTime();
        try {
            byte[] flowContents;
            String flowUrlOverride = System.getenv("FLOW_URL_OVERRIDE");
            if (flowUrlOverride != null && !flowUrlOverride.isEmpty()) {
                flowContents = DfxFlowDownload.fetchDataflowFromUrl(flowUrlOverride);
            } else {
                DfxFlowDownload download = new DfxFlowDownload(dfxBaseUrl, privateKey, accessKey);
                flowContents = download.downloadFlow(flowVersionCrn);
            }
            long millis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            logger.info("Successfully downloaded Flow {} in {} millis", (Object)flowVersionCrn, (Object)millis);
            return flowContents;
        }
        catch (Exception e) {
            throw new IOException("Failed to fetch flow from Dataflow Service with provided information", e);
        }
    }

    protected File getWorkingDirectory() {
        File writableExtensionsDirectory;
        String workingDir = System.getenv("WORKING_DIR");
        File file = writableExtensionsDirectory = workingDir == null ? DEFAULT_WORKING_DIRECTORY : new File(workingDir);
        if (!writableExtensionsDirectory.exists() && !writableExtensionsDirectory.mkdirs()) {
            throw new RuntimeException("Extensions directory " + writableExtensionsDirectory.getAbsolutePath() + " does not exist and cannot be created");
        }
        return writableExtensionsDirectory;
    }

    private StatelessEngineConfiguration createEngineConfiguration() throws IOException {
        File workingDirectory = this.getWorkingDirectory();
        if (!workingDirectory.exists() && !workingDirectory.mkdirs()) {
            throw new IOException("Working directory " + workingDirectory.getAbsolutePath() + " does not exist and cannot be created");
        }
        final File narDirectory = this.detectNarDirectory();
        logger.debug("Detected NAR Directory of {}", (Object)narDirectory.getAbsolutePath());
        final File contentRepoDir = this.getContentRepoDirectory();
        final File writableExtensionsDirectory = this.getWritableExtensionsDirectory();
        final List<File> readOnlyExtensionsDirs = this.getReadOnlyExtensionDirectories();
        String krb5EnvVar = System.getenv("KRB5_FILE");
        final String krb5File = krb5EnvVar == null ? "/etc/krb5.conf" : krb5EnvVar;
        final String processorStartTimeout = System.getenv("PROCESSOR_START_TIMEOUT");
        final String componentEnableTimeout = System.getenv("COMPONENT_ENABLE_TIMEOUT");
        StatelessEngineConfiguration engineConfiguration = new StatelessEngineConfiguration(){

            public File getWorkingDirectory() {
                return StandardStatelessNiFiFunction.this.getWorkingDirectory();
            }

            public File getNarDirectory() {
                return narDirectory;
            }

            public File getExtensionsDirectory() {
                return writableExtensionsDirectory;
            }

            public Collection<File> getReadOnlyExtensionsDirectories() {
                return readOnlyExtensionsDirs;
            }

            public File getKrb5File() {
                return new File(krb5File);
            }

            public SslContextDefinition getSslContext() {
                return null;
            }

            public String getSensitivePropsKey() {
                String envVar = System.getenv("SENSITIVE_PROPS_KEY");
                return envVar == null ? StandardStatelessNiFiFunction.DEFAULT_SENSITIVE_PROPS_VALUE : envVar;
            }

            public List<ExtensionClientDefinition> getExtensionClients() {
                ArrayList<ExtensionClientDefinition> extensionClientDefinitions = new ArrayList<ExtensionClientDefinition>();
                String nexusEnvVar = System.getenv("NEXUS_URL");
                String nexusBaseUrl = nexusEnvVar == null ? StandardStatelessNiFiFunction.DEFAULT_NEXUS_BASE_URL : nexusEnvVar;
                ExtensionClientDefinition definition = new ExtensionClientDefinition();
                definition.setUseSslContext(false);
                definition.setExtensionClientType("nexus");
                definition.setCommsTimeout("30 secs");
                definition.setBaseUrl(nexusBaseUrl);
                extensionClientDefinitions.add(definition);
                return extensionClientDefinitions;
            }

            public Optional<File> getContentRepositoryDirectory() {
                return Optional.ofNullable(contentRepoDir);
            }

            public String getStatusTaskInterval() {
                return null;
            }

            public String getProcessorStartTimeout() {
                if (processorStartTimeout != null) {
                    logger.info("Setting processor start timeout to {}", (Object)processorStartTimeout);
                    return processorStartTimeout;
                }
                return super.getProcessorStartTimeout();
            }

            public String getComponentEnableTimeout() {
                if (componentEnableTimeout != null) {
                    logger.info("Setting component enable timeout to {}", (Object)componentEnableTimeout);
                    return componentEnableTimeout;
                }
                return super.getComponentEnableTimeout();
            }
        };
        return engineConfiguration;
    }

    private File getWritableExtensionsDirectory() {
        File writableExtensionsDirectory;
        String extensionsVar = System.getenv("EXTENSIONS_DOWNLOAD_DIR");
        File file = writableExtensionsDirectory = extensionsVar == null ? this.statelessFunctionConfiguration.getDefaultExtensionDirectory() : new File(extensionsVar);
        if (!writableExtensionsDirectory.exists() && !writableExtensionsDirectory.mkdirs()) {
            throw new RuntimeException("Extensions directory " + writableExtensionsDirectory.getAbsolutePath() + " does not exist and cannot be created");
        }
        return writableExtensionsDirectory;
    }

    private File getContentRepoDirectory() {
        String contentRepoVar = System.getenv("CONTENT_REPO");
        if (contentRepoVar == null) {
            return null;
        }
        File contentRepoRootDir = new File(contentRepoVar.trim());
        File functionDir = new File(contentRepoRootDir, this.functionName);
        File contentRepositoryDirectory = new File(functionDir, "content_repository");
        String timestamp = String.valueOf(System.currentTimeMillis());
        File contentRepoDir = new File(contentRepositoryDirectory, timestamp + "-" + UUID.randomUUID());
        logger.info("Will write FlowFile content to Content Repository directory {}", (Object)contentRepoDir);
        return contentRepoDir;
    }

    private List<File> getReadOnlyExtensionDirectories() {
        ArrayList<File> readOnlyExtensionsDirs = new ArrayList<File>();
        System.getenv().keySet().stream().filter(key -> key.startsWith("EXTENSIONS_DIR_")).map(System::getenv).filter(Objects::nonNull).filter(value -> !value.trim().equals("")).map(File::new).forEach(readOnlyExtensionsDirs::add);
        return readOnlyExtensionsDirs;
    }

    private static URLClassLoader getFunctionClassLoader() {
        ClassLoader classLoader = StandardStatelessNiFiFunction.class.getClassLoader();
        if (!(classLoader instanceof URLClassLoader)) {
            throw new IllegalStateException("Unable to determine the NAR directory");
        }
        return (URLClassLoader)classLoader;
    }

    protected File detectNarDirectory() {
        URL[] urls;
        File narDirectory = this.statelessFunctionConfiguration.getNarDirectory();
        if (narDirectory != null && narDirectory.exists()) {
            logger.info("Nar directory is specified as " + narDirectory.getAbsolutePath() + ".  Checking for NARs in it");
            File[] narFiles = narDirectory.listFiles(f -> f.getName().endsWith(".nar"));
            if (narFiles == null) {
                logger.warn("Found no NARs inside {}.  Attempting further detection of NARs.", (Object)narDirectory.getAbsolutePath());
            } else {
                return narDirectory;
            }
        }
        URLClassLoader urlClassLoader = StandardStatelessNiFiFunction.getFunctionClassLoader();
        for (URL url : urls = urlClassLoader.getURLs()) {
            String filename = url.getFile();
            if (filename == null || filename.equals("")) continue;
            File file = new File(filename);
            if (!file.exists()) {
                logger.warn("Found URL {} in ClassLoader but file {} does not exist", (Object)url, (Object)file.getAbsolutePath());
                continue;
            }
            if (file.isDirectory()) {
                File[] narFiles = file.listFiles(f -> f.getName().endsWith(".nar"));
                if (narFiles == null) {
                    logger.warn("Found URL {} in ClassLoader and {} is a directory but cannot access its files", (Object)url, (Object)file.getAbsolutePath());
                    continue;
                }
                if (narFiles.length <= 0) continue;
                logger.info("Detected NAR Directory to be {}", (Object)file.getAbsolutePath());
                return file;
            }
            if (!file.getName().endsWith(".jar")) continue;
            File directory = file.getParentFile();
            File[] narFiles = directory.listFiles(f -> f.getName().endsWith(".nar"));
            if (narFiles == null) {
                logger.warn("Found URL {} in ClassLoader but cannot access the files in its parent directory {}", (Object)url, (Object)directory);
                continue;
            }
            if (narFiles.length <= 0) continue;
            logger.debug("Detected NAR Directory to be {}", (Object)directory.getAbsolutePath());
            return directory;
        }
        logger.error("ClassLoader that loaded the function did not contain nifi-stateless-bootstrap. URLs that were present: {}", Arrays.asList(urlClassLoader.getURLs()));
        throw new IllegalStateException("Unable to determine the NAR directory");
    }

    public void cleanUp() {
    }

    public FlowFile getOutputFlowfile(TriggerResult triggerResult) {
        List flowFiles;
        if (this.outputPortOfInterest == null) {
            flowFiles = Collections.emptyList();
        } else {
            flowFiles = triggerResult.getOutputFlowFiles(this.outputPortOfInterest);
            if (flowFiles == null) {
                flowFiles = Collections.emptyList();
            }
        }
        if (flowFiles.size() > 1) {
            logger.info("Triggered dataflow but it returned multiple FlowFiles. Will not return any results from function: {}", (Object)triggerResult.getOutputFlowFiles());
            return null;
        }
        if (flowFiles.size() == 1) {
            FlowFile flowFile = (FlowFile)flowFiles.get(0);
            logger.info("Successfully triggered dataflow. Returning {} bytes", (Object)flowFile.getSize());
            return flowFile;
        }
        logger.info("Successfully triggered dataflow but there were no output FlowFiles. Will not return any result from function.");
        return null;
    }

    private void enqueueFlowFile(InputStream flowFileContents, Map<String, String> inputAttributes) {
        InputStream dataflowInput = flowFileContents == null ? new ByteArrayInputStream(new byte[0]) : flowFileContents;
        String inputPortName = this.getInputPortName();
        Map<Object, Object> attributes = inputAttributes == null ? Collections.emptyMap() : inputAttributes;
        this.dataflow.enqueue(dataflowInput, attributes, inputPortName);
        logger.info("Enqueued FlowFile for Input Port {}", (Object)inputPortName);
    }

    private String getInputPortName() {
        String inputPortNameVariable = System.getenv("INPUT_PORT");
        if (inputPortNameVariable != null) {
            return inputPortNameVariable;
        }
        Set inputPortNames = this.dataflow.getInputPortNames();
        if (inputPortNames.isEmpty()) {
            throw new RuntimeException("At least one Input Port is required in the dataflow");
        }
        if (inputPortNames.size() == 1) {
            String portName = (String)this.dataflow.getInputPortNames().iterator().next();
            return portName;
        }
        throw new RuntimeException("The configured dataflow has " + inputPortNames.size() + " Input Ports, and there is no " + "INPUT_PORT" + " Environment Variable set to indicate which one to use. This function needs to be configured with the '" + "INPUT_PORT" + "' Environment Variable.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getWithFunctionBootstrapClassloader(FrameworkAction<T> action) {
        ClassLoader functionBootstrapClassLoader = this.getFunctionBootstrapClassLoader();
        ClassLoader initialClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(functionBootstrapClassLoader);
            T t = action.execute();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(initialClassLoader);
        }
    }

    private void withFunctionBootstrapClassloader(Runnable action) {
        this.getWithFunctionBootstrapClassloader(() -> {
            action.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T instantiateWithBoostrapClassloader(String className) {
        ClassLoader initialClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader functionBootstrapClassLoader = this.getFunctionBootstrapClassLoader();
        try {
            Class<?> rawClass = Class.forName(className, true, functionBootstrapClassLoader);
            Thread.currentThread().setContextClassLoader(functionBootstrapClassLoader);
            Object obj = rawClass.newInstance();
            return (T)obj;
        }
        catch (Throwable t) {
            logger.error("Could not instantiate " + className, t);
            T t2 = null;
            return t2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(initialClassLoader);
        }
    }

    private /* synthetic */ void lambda$trigger$0(Invocation invocation) {
        this.meteringPublisher.publish(invocation);
    }

    private class DelegatingTriggerResult
    implements TriggerResult {
        private final TriggerResult delegate;
        private final boolean successful;
        private final Throwable failureCause;

        DelegatingTriggerResult(TriggerResult triggerResult, boolean successful, Throwable failureCauseOverride) {
            this.delegate = triggerResult;
            this.successful = successful;
            this.failureCause = failureCauseOverride;
        }

        public boolean isSuccessful() {
            return this.delegate == null ? this.successful : this.delegate.isSuccessful();
        }

        public boolean isCanceled() {
            return this.delegate == null ? false : this.delegate.isCanceled();
        }

        public Optional<Throwable> getFailureCause() {
            return this.failureCause != null ? Optional.of(this.failureCause) : this.delegate.getFailureCause();
        }

        public Map<String, List<FlowFile>> getOutputFlowFiles() {
            return this.delegate == null ? null : this.delegate.getOutputFlowFiles();
        }

        public List<FlowFile> getOutputFlowFiles(String s) {
            return this.delegate == null ? null : this.delegate.getOutputFlowFiles(s);
        }

        public InputStream readContent(FlowFile flowFile) throws IOException {
            return this.delegate == null ? null : this.delegate.readContent(flowFile);
        }

        public byte[] readContentAsByteArray(FlowFile flowFile) throws IOException {
            return this.delegate == null ? null : this.delegate.readContentAsByteArray(flowFile);
        }

        public void acknowledge() {
            if (this.delegate != null) {
                this.delegate.acknowledge();
            }
        }

        public void abort(Throwable throwable) {
            if (this.delegate != null) {
                this.delegate.abort(throwable);
            }
        }

        public List<ProvenanceEventRecord> getProvenanceEvents() throws IOException {
            return this.delegate == null ? null : this.delegate.getProvenanceEvents();
        }
    }

    private static interface FrameworkAction<T> {
        public T execute();
    }
}

