/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.naaf;

import com.cloudera.naaf.StatelessNiFiFunction;
import com.cloudera.naaf.metering.CloudPlatform;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

public class StatelessFunctionConfiguration {
    private static final File DEFAULT_EXTENSION_DIRECTORY = new File(StatelessNiFiFunction.TEMP_DIR, "extensions");
    private final Consumer<Map<String, String>> flowDefinitionConfigAction;
    private final String region;
    private final CloudPlatform cloudPlatform;
    private final ClassLoader systemClassLoader;
    private final String resourceDownloaderType;
    private final String stateProviderType;
    private final File resourcesDirectory;
    private final String resourcesSourceDirectory;
    private final String extensionsSourceDirectory;
    private final File defaultExtensionDirectory;
    private final File narDirectory;

    private StatelessFunctionConfiguration(Builder builder) {
        this.flowDefinitionConfigAction = builder.flowDefinitionConfigAction;
        this.defaultExtensionDirectory = builder.defaultExtensionDirectory;
        this.resourcesDirectory = builder.resourcesDirectory;
        this.resourcesSourceDirectory = builder.resourcesSourceDirectory;
        this.extensionsSourceDirectory = builder.extensionsSourceDirectory;
        this.systemClassLoader = builder.systemClassLoader;
        this.resourceDownloaderType = builder.resourceDownloaderType;
        this.stateProviderType = builder.stateProviderType;
        this.narDirectory = builder.narDirectory;
        this.region = builder.region;
        this.cloudPlatform = builder.cloudPlatform;
    }

    public void applyFlowDefinitionConfigAction(Map<String, String> flowDefinition) {
        Optional.ofNullable(this.flowDefinitionConfigAction).ifPresent(action -> action.accept(flowDefinition));
    }

    public File getDefaultExtensionDirectory() {
        return Optional.ofNullable(this.defaultExtensionDirectory).orElse(DEFAULT_EXTENSION_DIRECTORY);
    }

    public ClassLoader getSystemClassLoader() {
        return this.systemClassLoader;
    }

    public File getResourcesDirectory() {
        return this.resourcesDirectory;
    }

    public File getNarDirectory() {
        return this.narDirectory;
    }

    public String getResourceDownloaderType() {
        return this.resourceDownloaderType;
    }

    public String getStateProviderType() {
        return this.stateProviderType;
    }

    public String getResourcesSourceDirectory() {
        return this.resourcesSourceDirectory;
    }

    public String getExtensionsSourceDirectory() {
        return this.extensionsSourceDirectory;
    }

    public CloudPlatform getCloudPlatform() {
        return this.cloudPlatform;
    }

    public String getRegion() {
        return this.region;
    }

    public static class Builder {
        private Consumer<Map<String, String>> flowDefinitionConfigAction;
        private String region;
        private File resourcesDirectory;
        private String resourcesSourceDirectory;
        private String extensionsSourceDirectory;
        private File narDirectory;
        private File defaultExtensionDirectory;
        private String resourceDownloaderType;
        private String stateProviderType;
        private ClassLoader systemClassLoader;
        private CloudPlatform cloudPlatform;

        public Builder flowDefinitionConfigAction(Consumer<Map<String, String>> action) {
            this.flowDefinitionConfigAction = action;
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder cloudPlatform(CloudPlatform cloudPlatform) {
            this.cloudPlatform = cloudPlatform;
            return this;
        }

        public Builder systemClassLoader(ClassLoader systemClassLoader) {
            this.systemClassLoader = systemClassLoader;
            return this;
        }

        public Builder resourceDownloaderType(String resourceDownloaderType) {
            this.resourceDownloaderType = resourceDownloaderType;
            return this;
        }

        public Builder stateProviderType(String stateProviderType) {
            this.stateProviderType = stateProviderType;
            return this;
        }

        public Builder resourcesDirectory(File resourcesDirectory) {
            this.resourcesDirectory = resourcesDirectory;
            return this;
        }

        public Builder narDirectory(File narDirectory) {
            this.narDirectory = narDirectory;
            return this;
        }

        public Builder resourcesSourceDirectory(String resourcesSourceDirectory) {
            this.resourcesSourceDirectory = resourcesSourceDirectory;
            return this;
        }

        public Builder extensionsSourceDirectory(String extensionsSourceDirectory) {
            this.extensionsSourceDirectory = extensionsSourceDirectory;
            return this;
        }

        public Builder defaultExtensionDirectory(File defaultExtensionDirectory) {
            this.defaultExtensionDirectory = defaultExtensionDirectory;
            return this;
        }

        public StatelessFunctionConfiguration build() {
            return new StatelessFunctionConfiguration(this);
        }
    }
}

