/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.naaf.download;

import com.cloudera.naaf.download.CdpSigner;
import com.cloudera.naaf.download.CredentialUtilities;
import com.cloudera.naaf.download.FlowDownload;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.PrivateKey;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DfxFlowDownload
implements FlowDownload {
    private static final Logger logger = LoggerFactory.getLogger(DfxFlowDownload.class);
    private static final int SUCCESS_HTTP_CODE = 200;
    private static final Pattern CRN_PATTERN = Pattern.compile("(crn:cdp:.*)/v\\.\\d+");
    private static final String CHAR_ENCODING = "UTF-8";
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String GET_METHOD = "GET";
    private static final String DATE_HEADER_NAME = "x-altus-date";
    private static final String AUTH_HEADER_NAME = "x-altus-auth";
    private static final String CLIENT_TYPE = "function";
    private final String dfxGlobalBaseUrl;
    private final PrivateKey privateKey;
    private final String accessKey;

    public DfxFlowDownload(String dfxGlobalBaseUrl, String encodedPrivateKey, String accessKey) {
        this.dfxGlobalBaseUrl = dfxGlobalBaseUrl;
        this.accessKey = accessKey;
        this.privateKey = CredentialUtilities.decodePrivateKey(encodedPrivateKey);
    }

    public byte[] downloadFlow(String flowVersionCrn) throws IOException {
        String encodedVersionCrn = URLEncoder.encode(flowVersionCrn, CHAR_ENCODING);
        String catalogDownloadPath = String.format("/dfx/api/v1/catalog/flows/versions/%s?clientType=%s", encodedVersionCrn, CLIENT_TYPE);
        Response response = this.makeGetRequest(catalogDownloadPath);
        if (response.statusCode == 200) {
            return response.content;
        }
        logger.error("Failed to fetch flow from Cloudera's DataFlow Service: received unsuccessful HTTP response " + response);
        String responseText = new String(response.content);
        throw new IOException("Failed to fetch flow from Cloudera's DataFlow Service: received HTTP response code " + responseText);
    }

    private String getFlowCrn(String flowVersionCrn) {
        Matcher matcher = CRN_PATTERN.matcher(flowVersionCrn);
        boolean matches = matcher.matches();
        if (!matches) {
            return flowVersionCrn;
        }
        return matcher.group(1);
    }

    private Response makeGetRequest(String urlPath) throws IOException {
        String date = ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.RFC_1123_DATE_TIME);
        CdpSigner signer = new CdpSigner();
        String auth = signer.computeAuthHeader(GET_METHOD, JSON_CONTENT_TYPE, date, urlPath, this.accessKey, this.privateKey);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(DATE_HEADER_NAME, date);
        headers.put(AUTH_HEADER_NAME, auth);
        headers.put("Content-Type", JSON_CONTENT_TYPE);
        String fullUrl = this.dfxGlobalBaseUrl.endsWith("/") && urlPath.startsWith("/") ? this.dfxGlobalBaseUrl + urlPath.substring(1) : this.dfxGlobalBaseUrl + urlPath;
        return DfxFlowDownload.executeGetRequest(fullUrl, headers);
    }

    public static byte[] readResponse(URLConnection urlConnection) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[256];
        try (InputStream in = urlConnection.getInputStream();){
            int bytesRead;
            while ((bytesRead = in.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, bytesRead);
            }
            buffer.flush();
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Response executeGetRequest(String fullUrl, Map<String, String> headers) throws IOException {
        URL url = new URL(fullUrl);
        try (HttpURLConnectionCloseable connectionCloseable = new HttpURLConnectionCloseable((HttpURLConnection)url.openConnection());){
            HttpURLConnection urlConnection = connectionCloseable.connection;
            urlConnection.setRequestMethod(GET_METHOD);
            headers.forEach((key, value) -> urlConnection.setRequestProperty((String)key, (String)value));
            int status = urlConnection.getResponseCode();
            Response response = new Response(DfxFlowDownload.readResponse(urlConnection), status);
            return response;
        }
        catch (FileNotFoundException e) {
            logger.error("Failed to fetch flow from [{}]: not found", (Object)fullUrl);
            throw new IllegalArgumentException("Not found: " + fullUrl);
        }
    }

    public static byte[] fetchDataflowFromUrl(String flowUrl) throws IOException {
        Response response = DfxFlowDownload.executeGetRequest(flowUrl, Collections.emptyMap());
        if (response.statusCode == 200) {
            return response.content;
        }
        String responseText = new String(response.content);
        logger.error("Failed to fetch flow from [{}]: received unsuccessful HTTP response {}", (Object)flowUrl, (Object)responseText);
        throw new IOException(responseText);
    }

    private static class HttpURLConnectionCloseable
    implements Closeable {
        private HttpURLConnection connection;

        private HttpURLConnectionCloseable(HttpURLConnection connection) {
            this.connection = connection;
        }

        @Override
        public void close() {
            this.connection.disconnect();
        }
    }

    private static class Response {
        private byte[] content;
        private int statusCode;

        public Response(byte[] content, int statusCode) {
            this.content = content;
            this.statusCode = statusCode;
        }
    }
}

