/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.naaf.azure.functions;

import com.cloudera.naaf.StatelessNiFiFunction;
import com.cloudera.naaf.StatelessNiFiUtil;
import com.cloudera.naaf.azure.functions.StatelessNiFiAzureFunctionHolder;
import com.microsoft.azure.functions.ExecutionContext;
import com.microsoft.azure.functions.HttpRequestMessage;
import com.microsoft.azure.functions.HttpResponseMessage;
import com.microsoft.azure.functions.HttpStatus;
import com.microsoft.azure.functions.HttpStatusType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.stateless.flow.TriggerResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractStatelessNiFiHttpTriggerFunction {
    private static final Logger logger = LoggerFactory.getLogger(AbstractStatelessNiFiHttpTriggerFunction.class);
    private static final String ATTRIBUTE_PREFIX = "azure.http.header.";
    private static final String MIME_TYPE = "mime.type";
    private static final String HEADER_ATTRIBUTE_PATTERN_ENV_VAR = "HEADER_ATTRIBUTE_PATTERN";
    private static final String HTTP_STATUS_CODE_ATTRIBUTE_ENV_VAR = "HTTP_STATUS_CODE_ATTRIBUTE";
    private final Optional<Pattern> headerAttributePattern;
    private static final AtomicReference<StatelessNiFiAzureFunctionHolder> functionHolderReference = new AtomicReference();

    public AbstractStatelessNiFiHttpTriggerFunction() {
        String headerAttributePatternVariable = System.getenv(HEADER_ATTRIBUTE_PATTERN_ENV_VAR);
        this.headerAttributePattern = headerAttributePatternVariable != null ? Optional.of(Pattern.compile(headerAttributePatternVariable)) : Optional.empty();
    }

    private StatelessNiFiAzureFunctionHolder getFunctionHolder() {
        StatelessNiFiAzureFunctionHolder functionHolder = functionHolderReference.get();
        if (functionHolder == null) {
            logger.debug("Function has not been initialized yet, initializing now...");
            try {
                functionHolder = new StatelessNiFiAzureFunctionHolder();
            }
            catch (IOException e) {
                logger.error("Error initializing function", (Throwable)e);
                throw new RuntimeException(e);
            }
            functionHolderReference.set(functionHolder);
            logger.debug("Successfully initialized Trigger Function");
            return functionHolder;
        }
        logger.debug("Function is already initialized");
        return functionHolder;
    }

    protected HttpResponseMessage runFunction(HttpRequestMessage<?> request, InputStream inputStream, ExecutionContext executionContext) {
        HttpResponseMessage responseMessage = null;
        try {
            StatelessNiFiAzureFunctionHolder functionHolder = this.getFunctionHolder();
            StatelessNiFiFunction statelessNiFiFunction = functionHolder.getStatelessNiFiFunction();
            Map<String, String> inputAttributes = StatelessNiFiAzureFunctionHolder.getAttributes(executionContext);
            inputAttributes.putAll(this.getAttributes(request));
            String instanceId = functionHolder.getFunctionName();
            TriggerResult triggerResult = statelessNiFiFunction.trigger(instanceId, inputStream, inputAttributes);
            logger.debug("Received {} trigger result{}", (Object)(triggerResult.isSuccessful() ? "successful" : "failure"), (Object)(triggerResult.getFailureCause().isPresent() ? " with failure cause " + ((Throwable)triggerResult.getFailureCause().get()).getMessage() : ""));
            if (triggerResult.isSuccessful()) {
                Map outputAttributes;
                FlowFile result = statelessNiFiFunction.getOutputFlowfile(triggerResult);
                if (result == null) {
                    logger.debug("Received no Flowfile output from dataflow");
                    outputAttributes = null;
                } else {
                    outputAttributes = result.getAttributes();
                }
                if (outputAttributes == null) {
                    responseMessage = request.createResponseBuilder(HttpStatus.OK).body((Object)"DataFlow completed successfully but had no output").build();
                } else {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    StatelessNiFiUtil.copyOutput((FlowFile)result, (TriggerResult)triggerResult, (OutputStream)outputStream);
                    responseMessage = this.buildHttpResponse(request, outputStream.toByteArray(), outputAttributes);
                }
            }
            StatelessNiFiUtil.handleTriggerResult((TriggerResult)triggerResult);
        }
        catch (Throwable t) {
            logger.error("DataFlow failed to execute", t);
            responseMessage = request.createResponseBuilder(HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("DataFlow failure: " + t.getMessage())).build();
        }
        return responseMessage;
    }

    private Map<String, String> getAttributes(HttpRequestMessage<?> httpRequestMessage) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        httpRequestMessage.getHeaders().forEach((key, value) -> {
            attributes.put("cloud.provider", "AZURE");
            attributes.put(ATTRIBUTE_PREFIX + key, (String)value);
            if ("Content-Type".equalsIgnoreCase((String)key)) {
                attributes.put(MIME_TYPE, (String)value);
            }
        });
        attributes.put("azure.http.method", httpRequestMessage.getHttpMethod().name());
        return attributes;
    }

    private HttpResponseMessage buildHttpResponse(HttpRequestMessage<?> request, byte[] responseBody, Map<String, String> outputAttributes) {
        HttpStatus status = HttpStatus.OK;
        HttpResponseMessage.Builder builder = request.createResponseBuilder(status);
        if (outputAttributes != null) {
            String statusCodeValue;
            String httpStatusCodeAttribute;
            if (outputAttributes.containsKey(MIME_TYPE)) {
                builder.header("Content-Type", outputAttributes.get(MIME_TYPE));
            }
            if ((httpStatusCodeAttribute = System.getenv(HTTP_STATUS_CODE_ATTRIBUTE_ENV_VAR)) != null && (statusCodeValue = outputAttributes.get(httpStatusCodeAttribute)) != null) {
                try {
                    int parsedStatusCode = Integer.parseInt(statusCodeValue.trim());
                    status = HttpStatus.valueOf((int)parsedStatusCode);
                }
                catch (NumberFormatException e) {
                    String errorMessage = String.format("Could not parse HTTP status code attribute [%s] value [%s]", httpStatusCodeAttribute, statusCodeValue);
                    logger.error(errorMessage, (Throwable)e);
                    throw new RuntimeException(errorMessage, e);
                }
            }
            this.headerAttributePattern.ifPresent(attributePattern -> outputAttributes.entrySet().stream().filter(entry -> attributePattern.matcher((CharSequence)entry.getKey()).matches()).forEach(entry -> builder.header((String)entry.getKey(), (String)entry.getValue())));
        }
        builder.body((Object)responseBody);
        builder.status((HttpStatusType)status);
        return builder.build();
    }
}

