/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.naaf.azure.functions;

import com.cloudera.naaf.StandardStatelessNiFiFunction;
import com.cloudera.naaf.StatelessFunctionConfiguration;
import com.cloudera.naaf.StatelessNiFiFunction;
import com.cloudera.naaf.metering.CloudPlatform;
import com.microsoft.azure.functions.ExecutionContext;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class StatelessNiFiAzureFunctionHolder {
    private static final String UNVERSIONED = "unversioned";
    private static final String EVENT_CONTEXT_PREFIX = "azure.event.context.";
    private static final String FUNCTION_NAME_ENV_VAR = "FUNCTION_NAME";
    private static final String STORAGE_EXTENSIONS_DIRECTORY_ENV_VAR = "STORAGE_EXTENSIONS_DIRECTORY";
    private static final String STORAGE_RESOURCES_DIRECTORY_ENV_VAR = "STORAGE_RESOURCES_DIRECTORY";
    private static final String STORAGE_ENDPOINT_ENV_VAR = "STORAGE_ENDPOINT";
    private static final String STORAGE_CONTAINER_ENV_VAR = "STORAGE_CONTAINER";
    private static final String DEFAULT_STORAGE_EXTENSIONS_DIRECTORY = "extensions";
    private static final String DEFAULT_STORAGE_RESOURCES_DIRECTORY = "resources";
    private static final String RESOURCE_DOWNLOADER_TYPE = "com.cloudera.naaf.azure.functions.resources.AzureStorageContainerResourceDownloader";
    private static final String STATE_PROVIDER_TYPE = "com.cloudera.naaf.azure.functions.CosmosDBStatelessNiFiStateProvider";
    private static final String REGION = "REGION";
    private static final File NAR_DIRECTORY = new File("lib/");
    private static final File RESOURCES_DIRECTORY = new File(StatelessNiFiFunction.TEMP_DIR, "resources");
    private static final File DEFAULT_EXTENSION_DIRECTORY = new File(StatelessNiFiFunction.TEMP_DIR, "extensions");
    static final String AZURE_CLOUD_PROVIDER = "AZURE";
    private final StatelessNiFiFunction statelessNiFiFunction;
    private final String functionName = System.getenv("FUNCTION_NAME");

    public StatelessNiFiAzureFunctionHolder() throws IOException {
        String region = System.getenv(REGION);
        if (this.functionName == null) {
            throw new IllegalArgumentException("FUNCTION_NAME environment variable must be specified");
        }
        File resourcesDirectory = RESOURCES_DIRECTORY;
        if (!resourcesDirectory.exists() && !resourcesDirectory.mkdirs()) {
            throw new IOException("Resources directory " + resourcesDirectory.getAbsolutePath() + " does not exist and cannot be created");
        }
        String resourcesBucketDirectory = null;
        String extensionsBucketDirectory = null;
        String storageEndpoint = System.getenv(STORAGE_ENDPOINT_ENV_VAR);
        String storageContainer = System.getenv(STORAGE_CONTAINER_ENV_VAR);
        if (storageEndpoint != null && storageContainer != null) {
            resourcesBucketDirectory = Optional.ofNullable(System.getenv(STORAGE_RESOURCES_DIRECTORY_ENV_VAR)).orElse(DEFAULT_STORAGE_RESOURCES_DIRECTORY);
            extensionsBucketDirectory = Optional.ofNullable(System.getenv(STORAGE_EXTENSIONS_DIRECTORY_ENV_VAR)).orElse(DEFAULT_STORAGE_EXTENSIONS_DIRECTORY);
        }
        StatelessFunctionConfiguration configurationActions = new StatelessFunctionConfiguration.Builder().cloudPlatform(CloudPlatform.AZURE_FUNCTIONS).resourcesDirectory(resourcesDirectory).resourcesSourceDirectory(resourcesBucketDirectory).extensionsSourceDirectory(extensionsBucketDirectory).defaultExtensionDirectory(DEFAULT_EXTENSION_DIRECTORY).resourceDownloaderType(RESOURCE_DOWNLOADER_TYPE).stateProviderType(STATE_PROVIDER_TYPE).systemClassLoader(this.getClass().getClassLoader()).narDirectory(NAR_DIRECTORY).region(region).build();
        this.statelessNiFiFunction = new StandardStatelessNiFiFunction(this.functionName, UNVERSIONED, configurationActions);
    }

    public StatelessNiFiFunction getStatelessNiFiFunction() {
        return this.statelessNiFiFunction;
    }

    static Map<String, String> getAttributes(ExecutionContext context) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("cloud.provider", AZURE_CLOUD_PROVIDER);
        attributes.put("azure.event.context.functionName", context.getFunctionName());
        attributes.put("azure.event.context.invocationId", context.getInvocationId());
        if (context.getTraceContext() != null) {
            attributes.put("azure.event.context.trace.parent", context.getTraceContext().getTraceparent());
            attributes.put("azure.event.context.trace.state", context.getTraceContext().getTracestate());
            if (context.getTraceContext().getAttributes() != null) {
                context.getTraceContext().getAttributes().entrySet().forEach(entry -> {
                    String cfr_ignored_0 = (String)attributes.put("azure.event.context..trace.attributes." + (String)entry.getKey(), (String)entry.getValue());
                });
            }
        }
        return attributes;
    }

    String getFunctionName() {
        return this.functionName;
    }
}

