/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.naaf.azure.functions;

import com.cloudera.naaf.StatelessNiFiUtil;
import com.cloudera.naaf.azure.functions.StatelessNiFiAzureFunctionHolder;
import com.microsoft.azure.functions.ExecutionContext;
import com.microsoft.azure.functions.annotation.EventGridTrigger;
import com.microsoft.azure.functions.annotation.FunctionName;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.stateless.flow.TriggerResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatelessNiFiEventGridTriggerFunction {
    private static final Logger logger = LoggerFactory.getLogger(StatelessNiFiEventGridTriggerFunction.class);
    private static final AtomicReference<StatelessNiFiAzureFunctionHolder> functionHolderReference = new AtomicReference();

    private StatelessNiFiAzureFunctionHolder getFunctionHolder() {
        StatelessNiFiAzureFunctionHolder functionHolder = functionHolderReference.get();
        if (functionHolder == null) {
            logger.debug("Function has not been initialized yet, initializing now...");
            try {
                functionHolder = new StatelessNiFiAzureFunctionHolder();
            }
            catch (IOException e) {
                logger.error("Error initializing function", (Throwable)e);
                throw new RuntimeException(e);
            }
            functionHolderReference.set(functionHolder);
            logger.debug("Successfully initialized Trigger Function");
            return functionHolder;
        }
        logger.debug("Function is already initialized");
        return functionHolder;
    }

    @FunctionName(value="StatelessNiFiEventGridTriggerFunction")
    public void run(@EventGridTrigger(name="event", dataType="string") String event, ExecutionContext context) {
        StatelessNiFiAzureFunctionHolder functionHolder = this.getFunctionHolder();
        String instanceId = functionHolder.getFunctionName();
        TriggerResult triggerResult = functionHolder.getStatelessNiFiFunction().trigger(instanceId, (InputStream)new ByteArrayInputStream(event.getBytes(StandardCharsets.UTF_8)), StatelessNiFiAzureFunctionHolder.getAttributes(context));
        StatelessNiFiUtil.handleTriggerResult((TriggerResult)triggerResult);
    }

    protected void finalize() {
        functionHolderReference.get().getStatelessNiFiFunction().cleanUp();
    }
}

