/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.naaf.azure.functions;

import com.azure.core.credential.TokenCredential;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosClientBuilder;
import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.CosmosDatabase;
import com.azure.cosmos.implementation.NotFoundException;
import com.azure.cosmos.models.CosmosItemRequestOptions;
import com.azure.cosmos.models.CosmosItemResponse;
import com.azure.cosmos.models.PartitionKey;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.cloudera.naaf.StatelessNiFiStateProvider;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosmosDBStatelessNiFiStateProvider
implements StatelessNiFiStateProvider {
    private static final Logger logger = LoggerFactory.getLogger(CosmosDBStatelessNiFiStateProvider.class);
    private static final String COSMOSDB_STATE_CONTAINER_VAR = "COSMOSDB_STATE_CONTAINER";
    private static final String COSMOSDB_STATE_DATABASE_VAR = "COSMOSDB_STATE_DATABASE";
    private static final String COSMOSDB_ENDPOINT_VAR = "COSMOSDB_ENDPOINT";
    private static final String DEFAULT_STATE_DATABASE = "nifi_state";
    private static final String DEFAULT_STATE_CONTAINER = "nifi_state";
    private final CosmosClient cosmosClient;
    private final String containerName;
    private final String databaseName = Optional.ofNullable(System.getenv("COSMOSDB_STATE_DATABASE")).orElse("nifi_state");
    private final String endpoint;
    private final CosmosDatabase database;
    private CosmosContainer container;

    public CosmosDBStatelessNiFiStateProvider() {
        this.containerName = Optional.ofNullable(System.getenv(COSMOSDB_STATE_CONTAINER_VAR)).orElse("nifi_state");
        this.endpoint = System.getenv(COSMOSDB_ENDPOINT_VAR);
        if (this.endpoint == null) {
            throw new IllegalArgumentException("COSMOSDB_ENDPOINT is required in order to use the CosmosDB state provider");
        }
        this.cosmosClient = new CosmosClientBuilder().credential((TokenCredential)new DefaultAzureCredentialBuilder().build()).endpoint(this.endpoint).consistencyLevel(ConsistencyLevel.SESSION).contentResponseOnWriteEnabled(true).buildClient();
        this.database = this.cosmosClient.getDatabase(this.databaseName);
        this.container = this.database.getContainer(this.containerName);
    }

    public void storeState(String instanceId, StatelessNiFiStateProvider.StateScope scope, Map<String, String> state) {
        String documentId = this.getDocumentId(instanceId, scope);
        StateDocument stateDocument = new StateDocument(documentId, scope.name(), state);
        this.container.upsertItem((Object)stateDocument, new PartitionKey((Object)documentId), new CosmosItemRequestOptions());
    }

    private String getDocumentId(String instanceId, StatelessNiFiStateProvider.StateScope scope) {
        return UUID.nameUUIDFromBytes((instanceId + scope).getBytes(StandardCharsets.UTF_8)).toString();
    }

    public Map<String, String> retrieveState(String instanceId, StatelessNiFiStateProvider.StateScope scope) {
        String documentId = this.getDocumentId(instanceId, scope);
        try {
            CosmosItemResponse itemResponse = this.container.readItem(documentId, new PartitionKey((Object)documentId), StateDocument.class);
            if (itemResponse.getItem() == null) {
                logger.info("State has not yet been stored for {}, scope {}", (Object)instanceId, (Object)scope);
                return null;
            }
            return ((StateDocument)itemResponse.getItem()).getState();
        }
        catch (NotFoundException e) {
            logger.info("State has not been stored for {}, scope {}", (Object)instanceId, (Object)scope);
            return null;
        }
    }

    public static class StateDocument {
        private String id;
        private String scope;
        private Map<String, String> state;

        public StateDocument() {
        }

        public StateDocument(String documentId, String scope, Map<String, String> state) {
            this.id = documentId;
            this.scope = scope;
            this.state = state;
        }

        public String getId() {
            return this.id;
        }

        public String getScope() {
            return this.scope;
        }

        public Map<String, String> getState() {
            return this.state;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }

        public void setState(Map<String, String> state) {
            this.state = state;
        }
    }
}

