/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.naaf.azure.functions.resources;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.cloudera.naaf.resources.AbstractResourceDownloader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureStorageContainerResourceDownloader
extends AbstractResourceDownloader {
    private static final Logger logger = LoggerFactory.getLogger(AzureStorageContainerResourceDownloader.class);
    private static final String STORAGE_ENDPOINT_ENV_VAR = "STORAGE_ENDPOINT";
    private static final String STORAGE_CONTAINER_ENV_VAR = "STORAGE_CONTAINER";

    public void download(String sourceDirectory, File downloadDirectory) {
        String storageEndpoint = System.getenv(STORAGE_ENDPOINT_ENV_VAR);
        String storageContainer = System.getenv(STORAGE_CONTAINER_ENV_VAR);
        logger.info("Downloading {}/{}/{} to {}", new Object[]{storageEndpoint, storageContainer, sourceDirectory, downloadDirectory});
        try {
            BlobServiceClient blobServiceClient = new BlobServiceClientBuilder().credential((TokenCredential)new DefaultAzureCredentialBuilder().build()).endpoint(storageEndpoint).buildClient();
            BlobContainerClient blobContainerClient = blobServiceClient.getBlobContainerClient(storageContainer);
            ListBlobsOptions options = new ListBlobsOptions();
            String sourcePrefix = sourceDirectory.endsWith("/") ? sourceDirectory : sourceDirectory + "/";
            options.setPrefix(sourcePrefix);
            List blobNames = blobContainerClient.listBlobs(options, Duration.ofSeconds(60L)).stream().map(BlobItem::getName).collect(Collectors.toList());
            logger.debug(String.format("Successfully listed %s blobs", blobNames.size()));
            for (String blobName : blobNames) {
                BlobClient blobClient = blobContainerClient.getBlobClient(blobName);
                String filenameWithinSourceDir = AzureStorageContainerResourceDownloader.substringAfter((String)blobName, (String)sourcePrefix);
                Path filePath = this.getDownloadPath(filenameWithinSourceDir, downloadDirectory);
                if (filePath == null) continue;
                File file = filePath.toFile();
                logger.info(String.format("Downloading %s to %s", blobName, filePath));
                try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
                    blobClient.download((OutputStream)out);
                }
                logger.debug("Downloaded {} ({} bytes)", (Object)filePath, (Object)file.length());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to download from %s/%s/%s to %s", storageEndpoint, storageContainer, sourceDirectory, downloadDirectory), e);
        }
    }
}

