/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.designer.event.control;

import java.util.HashSet;
import org.apache.nifi.designer.event.EventValidationResult;
import org.apache.nifi.designer.event.control.FlowControlEvent;
import org.apache.nifi.designer.event.control.FlowControlEventType;

public class ProcessGroupRefreshRequestEvent
extends FlowControlEvent {
    private String processGroupId;

    @Override
    public FlowControlEventType getEventType() {
        return FlowControlEventType.REFRESH_REQUESTED;
    }

    public String getProcessGroupId() {
        return this.processGroupId;
    }

    public void setProcessGroupId(String processGroupId) {
        this.processGroupId = processGroupId;
    }

    @Override
    protected EventValidationResult validateAdditionalFields() {
        HashSet<String> invalidReasons = new HashSet<String>();
        if (this.getFlowId() == null) {
            invalidReasons.add("flowId is required");
        }
        if (this.isBlank(this.processGroupId)) {
            invalidReasons.add("processGroupId is required");
        }
        return invalidReasons.isEmpty() ? EventValidationResult.valid() : EventValidationResult.invalid(invalidReasons);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + "eventId=" + this.getEventId() + ", " + "flowId=" + this.getFlowId() + ", " + "clusterId=" + this.getClusterId() + ", " + "eventType=" + this.getEventType().name() + ", " + "processGroupId" + this.getProcessGroupId() + "]";
    }
}

