/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.naaf.download;

import com.cloudera.cdp.shaded.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.cloudera.cdp.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.cloudera.cdp.shaded.org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import com.cloudera.cdp.shaded.org.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import com.cloudera.cdp.shaded.org.bouncycastle.jcajce.provider.asymmetric.edec.KeyFactorySpi;
import com.cloudera.cdp.shaded.org.bouncycastle.util.io.pem.PemObject;
import com.cloudera.cdp.shaded.org.bouncycastle.util.io.pem.PemReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Objects;

public class CredentialUtilities {
    private static final int ED25519_KEY_LENGTH = 44;

    private CredentialUtilities() {
    }

    public static PrivateKey decodePrivateKey(String privateKey) {
        Objects.requireNonNull(privateKey, "private key is required");
        return privateKey.length() == 44 ? CredentialUtilities.decodeEd25519PrivateKey(privateKey) : CredentialUtilities.decodeRSAPrivateKey(privateKey);
    }

    private static PrivateKey decodeRSAPrivateKey(String privateKeyString) {
        privateKeyString = privateKeyString.replace("\\n", "\n");
        try {
            PrivateKey privateKey;
            try (PemReader pemReader = new PemReader((Reader)new StringReader(privateKeyString));){
                PemObject pemObject = pemReader.readPemObject();
                if (pemObject == null) {
                    throw new RuntimeException("Invalid private key ");
                }
                PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(pemObject.getContent());
                KeyFactory factory = KeyFactory.getInstance("RSA");
                privateKey = factory.generatePrivate(privateKeySpec);
            }
            return privateKey;
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException("Unable to generate private key " + e.getMessage(), e);
        }
    }

    private static PrivateKey decodeEd25519PrivateKey(String privateKey) {
        byte[] seed = Base64.getDecoder().decode(privateKey);
        try {
            Ed25519PrivateKeyParameters params = new Ed25519PrivateKeyParameters(seed, 0);
            PrivateKeyInfo info = PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)params);
            return new KeyFactorySpi.Ed25519().generatePrivate(info);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to generate private key " + e.getMessage(), e);
        }
    }
}

