/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosClientEncryptionKey;
import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.CosmosUser;
import com.azure.cosmos.models.CosmosClientEncryptionKeyProperties;
import com.azure.cosmos.models.CosmosClientEncryptionKeyResponse;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosContainerRequestOptions;
import com.azure.cosmos.models.CosmosContainerResponse;
import com.azure.cosmos.models.CosmosDatabaseRequestOptions;
import com.azure.cosmos.models.CosmosDatabaseResponse;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.CosmosUserProperties;
import com.azure.cosmos.models.CosmosUserResponse;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.models.ThroughputProperties;
import com.azure.cosmos.models.ThroughputResponse;
import com.azure.cosmos.util.Beta;
import com.azure.cosmos.util.CosmosPagedFlux;
import com.azure.cosmos.util.CosmosPagedIterable;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public class CosmosDatabase {
    private final CosmosAsyncDatabase databaseWrapper;
    private final CosmosClient client;
    private final String id;

    CosmosDatabase(String id, CosmosClient client, CosmosAsyncDatabase database) {
        this.id = id;
        this.client = client;
        this.databaseWrapper = database;
    }

    public String getId() {
        return this.id;
    }

    public CosmosDatabaseResponse read() {
        return this.client.blockDatabaseResponse(this.databaseWrapper.read());
    }

    public CosmosDatabaseResponse read(CosmosDatabaseRequestOptions options) {
        return this.client.blockDatabaseResponse(this.databaseWrapper.read(options));
    }

    public CosmosDatabaseResponse delete() {
        return this.client.blockDatabaseResponse(this.databaseWrapper.delete());
    }

    public CosmosDatabaseResponse delete(CosmosDatabaseRequestOptions options) {
        return this.client.blockDatabaseResponse(this.databaseWrapper.delete(options));
    }

    public CosmosContainerResponse createContainer(CosmosContainerProperties containerProperties) {
        return this.blockContainerResponse(this.databaseWrapper.createContainer(containerProperties));
    }

    public CosmosContainerResponse createContainer(CosmosContainerProperties containerProperties, ThroughputProperties throughputProperties) {
        return this.blockContainerResponse(this.databaseWrapper.createContainer(containerProperties, throughputProperties));
    }

    public CosmosContainerResponse createContainer(CosmosContainerProperties containerProperties, CosmosContainerRequestOptions options) {
        return this.blockContainerResponse(this.databaseWrapper.createContainer(containerProperties, options));
    }

    CosmosContainerResponse createContainer(CosmosContainerProperties containerProperties, int throughput, CosmosContainerRequestOptions options) {
        return this.blockContainerResponse(this.databaseWrapper.createContainer(containerProperties, throughput, options));
    }

    public CosmosContainerResponse createContainer(CosmosContainerProperties containerProperties, ThroughputProperties throughputProperties, CosmosContainerRequestOptions options) {
        return this.blockContainerResponse(this.databaseWrapper.createContainer(containerProperties, throughputProperties, options));
    }

    public CosmosContainerResponse createContainer(String id, String partitionKeyPath) {
        return this.blockContainerResponse(this.databaseWrapper.createContainer(id, partitionKeyPath));
    }

    public CosmosContainerResponse createContainer(String id, String partitionKeyPath, ThroughputProperties throughputProperties) {
        return this.blockContainerResponse(this.databaseWrapper.createContainer(id, partitionKeyPath, throughputProperties));
    }

    public CosmosContainerResponse createContainerIfNotExists(CosmosContainerProperties containerProperties) {
        return this.blockContainerResponse(this.databaseWrapper.createContainerIfNotExists(containerProperties));
    }

    CosmosContainerResponse createContainerIfNotExists(CosmosContainerProperties containerProperties, int throughput) {
        return this.blockContainerResponse(this.databaseWrapper.createContainerIfNotExists(containerProperties, throughput));
    }

    public CosmosContainerResponse createContainerIfNotExists(CosmosContainerProperties containerProperties, ThroughputProperties throughputProperties) {
        return this.blockContainerResponse(this.databaseWrapper.createContainerIfNotExists(containerProperties, throughputProperties));
    }

    public CosmosContainerResponse createContainerIfNotExists(String id, String partitionKeyPath) {
        return this.blockContainerResponse(this.databaseWrapper.createContainerIfNotExists(id, partitionKeyPath));
    }

    CosmosContainerResponse createContainerIfNotExists(String id, String partitionKeyPath, int throughput) {
        return this.blockContainerResponse(this.databaseWrapper.createContainerIfNotExists(id, partitionKeyPath, throughput));
    }

    public CosmosContainerResponse createContainerIfNotExists(String id, String partitionKeyPath, ThroughputProperties throughputProperties) {
        return this.blockContainerResponse(this.databaseWrapper.createContainerIfNotExists(id, partitionKeyPath, throughputProperties));
    }

    CosmosContainerResponse blockContainerResponse(Mono<CosmosContainerResponse> containerMono) {
        try {
            return (CosmosContainerResponse)containerMono.block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosException) {
                throw (CosmosException)((Object)throwable);
            }
            throw Exceptions.propagate((Throwable)ex);
        }
    }

    CosmosPagedIterable<CosmosContainerProperties> readAllContainers(CosmosQueryRequestOptions options) {
        return this.getCosmosPagedIterable(this.databaseWrapper.readAllContainers(options));
    }

    public CosmosPagedIterable<CosmosContainerProperties> readAllContainers() {
        return this.getCosmosPagedIterable(this.databaseWrapper.readAllContainers());
    }

    public CosmosPagedIterable<CosmosContainerProperties> queryContainers(String query) {
        return this.getCosmosPagedIterable(this.databaseWrapper.queryContainers(query));
    }

    public CosmosPagedIterable<CosmosContainerProperties> queryContainers(String query, CosmosQueryRequestOptions options) {
        return this.getCosmosPagedIterable(this.databaseWrapper.queryContainers(query, options));
    }

    public CosmosPagedIterable<CosmosContainerProperties> queryContainers(SqlQuerySpec querySpec) {
        return this.getCosmosPagedIterable(this.databaseWrapper.queryContainers(querySpec));
    }

    public CosmosPagedIterable<CosmosContainerProperties> queryContainers(SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.getCosmosPagedIterable(this.databaseWrapper.queryContainers(querySpec, options));
    }

    public CosmosContainer getContainer(String id) {
        return new CosmosContainer(id, this, this.databaseWrapper.getContainer(id));
    }

    public CosmosUserResponse createUser(CosmosUserProperties userProperties) {
        return this.blockUserResponse(this.databaseWrapper.createUser(userProperties));
    }

    public CosmosUserResponse upsertUser(CosmosUserProperties userProperties) {
        return this.blockUserResponse(this.databaseWrapper.upsertUser(userProperties));
    }

    public CosmosPagedIterable<CosmosUserProperties> readAllUsers() {
        return this.getCosmosPagedIterable(this.databaseWrapper.readAllUsers());
    }

    CosmosPagedIterable<CosmosUserProperties> readAllUsers(CosmosQueryRequestOptions options) {
        return this.getCosmosPagedIterable(this.databaseWrapper.readAllUsers(options));
    }

    public CosmosPagedIterable<CosmosUserProperties> queryUsers(String query) {
        return this.getCosmosPagedIterable(this.databaseWrapper.queryUsers(query));
    }

    public CosmosPagedIterable<CosmosUserProperties> queryUsers(String query, CosmosQueryRequestOptions options) {
        return this.getCosmosPagedIterable(this.databaseWrapper.queryUsers(query, options));
    }

    public CosmosPagedIterable<CosmosUserProperties> queryUsers(SqlQuerySpec querySpec) {
        return this.getCosmosPagedIterable(this.databaseWrapper.queryUsers(querySpec));
    }

    public CosmosPagedIterable<CosmosUserProperties> queryUsers(SqlQuerySpec querySpec, CosmosQueryRequestOptions options) {
        return this.getCosmosPagedIterable(this.databaseWrapper.queryUsers(querySpec, options));
    }

    public CosmosUser getUser(String id) {
        return new CosmosUser(this.databaseWrapper.getUser(id), this, id);
    }

    CosmosUserResponse blockUserResponse(Mono<CosmosUserResponse> containerMono) {
        try {
            return (CosmosUserResponse)containerMono.block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosException) {
                throw (CosmosException)((Object)throwable);
            }
            throw Exceptions.propagate((Throwable)ex);
        }
    }

    public ThroughputResponse replaceThroughput(ThroughputProperties throughputProperties) {
        return this.throughputResponseToBlock(this.databaseWrapper.replaceThroughput(throughputProperties));
    }

    public ThroughputResponse readThroughput() {
        return this.throughputResponseToBlock(this.databaseWrapper.readThroughput());
    }

    @Beta(value=Beta.SinceVersion.V4_15_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosClientEncryptionKey getClientEncryptionKey(String id) {
        return new CosmosClientEncryptionKey(id, this, this.databaseWrapper.getClientEncryptionKey(id));
    }

    @Beta(value=Beta.SinceVersion.V4_15_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosPagedIterable<CosmosClientEncryptionKeyProperties> readAllClientEncryptionKeys() {
        return this.getCosmosPagedIterable(this.databaseWrapper.readAllClientEncryptionKeys(new CosmosQueryRequestOptions()));
    }

    CosmosClientEncryptionKeyResponse blockClientEncryptionKeyResponse(Mono<CosmosClientEncryptionKeyResponse> cosmosClientEncryptionKeyResponseMono) {
        try {
            return (CosmosClientEncryptionKeyResponse)cosmosClientEncryptionKeyResponseMono.block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosException) {
                throw (CosmosException)((Object)throwable);
            }
            throw ex;
        }
    }

    <T> T throughputResponseToBlock(Mono<T> throughputResponse) {
        try {
            return (T)throughputResponse.block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosException) {
                throw (CosmosException)((Object)throwable);
            }
            throw Exceptions.propagate((Throwable)ex);
        }
    }

    private <T> CosmosPagedIterable<T> getCosmosPagedIterable(CosmosPagedFlux<T> cosmosPagedFlux) {
        return new CosmosPagedIterable<T>(cosmosPagedFlux);
    }
}

