/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.ThroughputControlGroupConfig;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.util.Beta;

@Beta(value=Beta.SinceVersion.V4_13_0, warningText="Preview API - subject to change in non-backwards compatible way")
public class ThroughputControlGroupConfigBuilder {
    private String groupName;
    private Integer targetThroughput;
    private Double targetThroughputThreshold;
    private boolean isDefault;

    @Beta(value=Beta.SinceVersion.V4_13_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public ThroughputControlGroupConfigBuilder setGroupName(String groupName) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(groupName), "Group name cannot be null nor empty");
        this.groupName = groupName;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_13_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public ThroughputControlGroupConfigBuilder setTargetThroughput(int targetThroughput) {
        Preconditions.checkArgument(targetThroughput > 0, "Target throughput should be greater than 0");
        this.targetThroughput = targetThroughput;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_13_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public ThroughputControlGroupConfigBuilder setTargetThroughputThreshold(double targetThroughputThreshold) {
        Preconditions.checkArgument(targetThroughputThreshold > 0.0 && targetThroughputThreshold <= 1.0, "Target throughput threshold should between (0, 1]");
        this.targetThroughputThreshold = targetThroughputThreshold;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_13_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public ThroughputControlGroupConfigBuilder setDefault(boolean aDefault) {
        this.isDefault = aDefault;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_13_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public ThroughputControlGroupConfig build() {
        if (StringUtils.isEmpty(this.groupName)) {
            throw new IllegalArgumentException("Group name cannot be null nor empty");
        }
        if (this.targetThroughput == null && this.targetThroughputThreshold == null) {
            throw new IllegalArgumentException("Neither targetThroughput nor targetThroughputThreshold is defined.");
        }
        return new ThroughputControlGroupConfig(this.groupName, this.targetThroughput, this.targetThroughputThreshold, this.isDefault);
    }
}

