/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosException;
import com.azure.cosmos.implementation.BackoffRetryUtility;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.CosmosError;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.Exceptions;
import com.azure.cosmos.implementation.GlobalEndpointManager;
import com.azure.cosmos.implementation.ISessionContainer;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.PathsHelper;
import com.azure.cosmos.implementation.QueryCompatibilityMode;
import com.azure.cosmos.implementation.ReplicatedResourceClientUtils;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.RxDocumentServiceResponse;
import com.azure.cosmos.implementation.RxStoreModel;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.UserAgentContainer;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.WebExceptionRetryPolicy;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.implementation.directconnectivity.DirectBridgeInternal;
import com.azure.cosmos.implementation.directconnectivity.HttpUtils;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.implementation.directconnectivity.WebExceptionUtility;
import com.azure.cosmos.implementation.http.HttpClient;
import com.azure.cosmos.implementation.http.HttpHeaders;
import com.azure.cosmos.implementation.http.HttpRequest;
import com.azure.cosmos.implementation.http.HttpResponse;
import com.azure.cosmos.implementation.http.ReactorNettyRequestRecord;
import com.azure.cosmos.implementation.throughputControl.ThroughputControlStore;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class RxGatewayStoreModel
implements RxStoreModel {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final DiagnosticsClientContext clientContext;
    private final Logger logger = LoggerFactory.getLogger(RxGatewayStoreModel.class);
    private final Map<String, String> defaultHeaders;
    private final HttpClient httpClient;
    private final QueryCompatibilityMode queryCompatibilityMode;
    private final GlobalEndpointManager globalEndpointManager;
    private ConsistencyLevel defaultConsistencyLevel;
    private ISessionContainer sessionContainer;
    private ThroughputControlStore throughputControlStore;

    public RxGatewayStoreModel(DiagnosticsClientContext clientContext, ISessionContainer sessionContainer, ConsistencyLevel defaultConsistencyLevel, QueryCompatibilityMode queryCompatibilityMode, UserAgentContainer userAgentContainer, GlobalEndpointManager globalEndpointManager, HttpClient httpClient) {
        this.clientContext = clientContext;
        this.defaultHeaders = new HashMap<String, String>();
        this.defaultHeaders.put("Cache-Control", "no-cache");
        this.defaultHeaders.put("x-ms-version", "2020-07-15");
        if (userAgentContainer == null) {
            userAgentContainer = new UserAgentContainer();
        }
        this.defaultHeaders.put("User-Agent", userAgentContainer.getUserAgent());
        if (defaultConsistencyLevel != null) {
            this.defaultHeaders.put("x-ms-consistency-level", defaultConsistencyLevel.toString());
        }
        this.defaultConsistencyLevel = defaultConsistencyLevel;
        this.globalEndpointManager = globalEndpointManager;
        this.queryCompatibilityMode = queryCompatibilityMode;
        this.httpClient = httpClient;
        this.sessionContainer = sessionContainer;
    }

    private Mono<RxDocumentServiceResponse> create(RxDocumentServiceRequest request) {
        return this.performRequest(request, HttpMethod.POST);
    }

    private Mono<RxDocumentServiceResponse> patch(RxDocumentServiceRequest request) {
        return this.performRequest(request, HttpMethod.PATCH);
    }

    private Mono<RxDocumentServiceResponse> upsert(RxDocumentServiceRequest request) {
        return this.performRequest(request, HttpMethod.POST);
    }

    private Mono<RxDocumentServiceResponse> read(RxDocumentServiceRequest request) {
        return this.performRequest(request, HttpMethod.GET);
    }

    private Mono<RxDocumentServiceResponse> replace(RxDocumentServiceRequest request) {
        return this.performRequest(request, HttpMethod.PUT);
    }

    private Mono<RxDocumentServiceResponse> delete(RxDocumentServiceRequest request) {
        return this.performRequest(request, HttpMethod.DELETE);
    }

    private Mono<RxDocumentServiceResponse> deleteByPartitionKey(RxDocumentServiceRequest request) {
        return this.performRequest(request, HttpMethod.POST);
    }

    private Mono<RxDocumentServiceResponse> execute(RxDocumentServiceRequest request) {
        return this.performRequest(request, HttpMethod.POST);
    }

    private Mono<RxDocumentServiceResponse> readFeed(RxDocumentServiceRequest request) {
        return this.performRequest(request, HttpMethod.GET);
    }

    private Mono<RxDocumentServiceResponse> query(RxDocumentServiceRequest request) {
        if (request.getOperationType() != OperationType.QueryPlan) {
            request.getHeaders().put("x-ms-documentdb-isquery", "true");
        }
        switch (this.queryCompatibilityMode) {
            case SqlQuery: {
                request.getHeaders().put("Content-Type", "application/sql");
                break;
            }
            default: {
                request.getHeaders().put("Content-Type", "application/query+json");
            }
        }
        return this.performRequest(request, HttpMethod.POST);
    }

    public Mono<RxDocumentServiceResponse> performRequest(RxDocumentServiceRequest request, HttpMethod method) {
        try {
            if (request.requestContext.cosmosDiagnostics == null) {
                request.requestContext.cosmosDiagnostics = this.clientContext.createDiagnostics();
            }
            URI uri = this.getUri(request);
            request.requestContext.resourcePhysicalAddress = uri.toString();
            if (this.throughputControlStore != null) {
                return this.throughputControlStore.processRequest(request, this.performRequestInternal(request, method, uri));
            }
            return this.performRequestInternal(request, method, uri);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    public Mono<RxDocumentServiceResponse> performRequestInternal(RxDocumentServiceRequest request, HttpMethod method, URI requestUri) {
        try {
            HttpHeaders httpHeaders = this.getHttpRequestHeaders(request.getHeaders());
            Flux<byte[]> contentAsByteArray = request.getContentAsByteArrayFlux();
            HttpRequest httpRequest = new HttpRequest(method, requestUri, requestUri.getPort(), httpHeaders, contentAsByteArray);
            Duration responseTimeout = Duration.ofSeconds(Configs.getHttpResponseTimeoutInSeconds());
            if (OperationType.QueryPlan.equals((Object)request.getOperationType())) {
                responseTimeout = Duration.ofSeconds(Configs.getQueryPlanResponseTimeoutInSeconds());
            } else if (request.isAddressRefresh()) {
                responseTimeout = Duration.ofSeconds(Configs.getAddressRefreshResponseTimeoutInSeconds());
            }
            Mono<HttpResponse> httpResponseMono = this.httpClient.send(httpRequest, responseTimeout);
            return this.toDocumentServiceResponse(httpResponseMono, request, httpRequest);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    private HttpHeaders getHttpRequestHeaders(Map<String, String> headers) {
        HttpHeaders httpHeaders = new HttpHeaders(this.defaultHeaders.size());
        for (Map.Entry<String, String> entry : this.defaultHeaders.entrySet()) {
            if (headers.containsKey(entry.getKey())) continue;
            httpHeaders.set(entry.getKey(), entry.getValue());
        }
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                if (entry.getValue() == null) {
                    httpHeaders.set(entry.getKey(), "");
                    continue;
                }
                httpHeaders.set(entry.getKey(), entry.getValue());
            }
        }
        return httpHeaders;
    }

    private URI getUri(RxDocumentServiceRequest request) throws URISyntaxException {
        URI rootUri = request.getEndpointOverride();
        if (rootUri == null) {
            rootUri = request.getIsMedia() ? (URI)this.globalEndpointManager.getWriteEndpoints().get(0) : this.globalEndpointManager.resolveServiceEndpoint(request);
        }
        String path = PathsHelper.generatePath(request.getResourceType(), request, request.isFeed);
        if (request.getResourceType().equals((Object)ResourceType.DatabaseAccount)) {
            path = "";
        }
        return new URI("https", null, rootUri.getHost(), rootUri.getPort(), this.ensureSlashPrefixed(path), null, null);
    }

    private String ensureSlashPrefixed(String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            return path;
        }
        return "/" + path;
    }

    private Mono<RxDocumentServiceResponse> toDocumentServiceResponse(Mono<HttpResponse> httpResponseMono, RxDocumentServiceRequest request, HttpRequest httpRequest) {
        return httpResponseMono.flatMap(httpResponse -> {
            HttpHeaders httpResponseHeaders = httpResponse.headers();
            int httpResponseStatus = httpResponse.statusCode();
            Mono contentObservable = httpResponse.bodyAsByteArray().switchIfEmpty(Mono.just((Object)EMPTY_BYTE_ARRAY));
            return contentObservable.map(content -> {
                ReactorNettyRequestRecord reactorNettyRequestRecord = httpResponse.request().reactorNettyRequestRecord();
                if (reactorNettyRequestRecord != null) {
                    reactorNettyRequestRecord.setTimeCompleted(Instant.now());
                    BridgeInternal.setGatewayRequestTimelineOnDiagnostics(request.requestContext.cosmosDiagnostics, reactorNettyRequestRecord.takeTimelineSnapshot());
                }
                this.validateOrThrow(request, HttpResponseStatus.valueOf((int)httpResponseStatus), httpResponseHeaders, (byte[])content);
                StoreResponse rsp = new StoreResponse(httpResponseStatus, HttpUtils.unescape(httpResponseHeaders.toMap().entrySet()), (byte[])content);
                DirectBridgeInternal.setRequestTimeline(rsp, reactorNettyRequestRecord.takeTimelineSnapshot());
                if (request.requestContext.cosmosDiagnostics != null) {
                    BridgeInternal.recordGatewayResponse(request.requestContext.cosmosDiagnostics, request, rsp, null);
                    DirectBridgeInternal.setCosmosDiagnostics(rsp, request.requestContext.cosmosDiagnostics);
                }
                return rsp;
            }).single();
        }).map(rsp -> {
            if (httpRequest.reactorNettyRequestRecord() != null) {
                return new RxDocumentServiceResponse(this.clientContext, (StoreResponse)rsp, httpRequest.reactorNettyRequestRecord().takeTimelineSnapshot());
            }
            return new RxDocumentServiceResponse(this.clientContext, (StoreResponse)rsp);
        }).onErrorResume(throwable -> {
            CosmosException dce;
            Throwable unwrappedException = reactor.core.Exceptions.unwrap((Throwable)throwable);
            if (!(unwrappedException instanceof Exception)) {
                this.logger.error("Unexpected failure {}", (Object)unwrappedException.getMessage(), (Object)unwrappedException);
                return Mono.error((Throwable)unwrappedException);
            }
            Exception exception = (Exception)unwrappedException;
            if (!(exception instanceof CosmosException)) {
                this.logger.error("Network failure", (Throwable)exception);
                dce = BridgeInternal.createCosmosException(request.requestContext.resourcePhysicalAddress, 0, exception);
                BridgeInternal.setRequestHeaders(dce, request.getHeaders());
            } else {
                dce = (CosmosException)((Object)((Object)exception));
            }
            if (WebExceptionUtility.isNetworkFailure((Exception)((Object)dce))) {
                if (WebExceptionUtility.isReadTimeoutException((Exception)((Object)dce))) {
                    BridgeInternal.setSubStatusCode(dce, 10002);
                } else {
                    BridgeInternal.setSubStatusCode(dce, 10001);
                }
            }
            if (request.requestContext.cosmosDiagnostics != null) {
                if (BridgeInternal.getClientSideRequestStatics(request.requestContext.cosmosDiagnostics).getGatewayRequestTimeline() == null && httpRequest.reactorNettyRequestRecord() != null) {
                    BridgeInternal.setGatewayRequestTimelineOnDiagnostics(request.requestContext.cosmosDiagnostics, httpRequest.reactorNettyRequestRecord().takeTimelineSnapshot());
                }
                BridgeInternal.recordGatewayResponse(request.requestContext.cosmosDiagnostics, request, null, dce);
                BridgeInternal.setCosmosDiagnostics(dce, request.requestContext.cosmosDiagnostics);
            }
            return Mono.error((Throwable)((Object)dce));
        });
    }

    private void validateOrThrow(RxDocumentServiceRequest request, HttpResponseStatus status, HttpHeaders headers, byte[] bodyAsBytes) {
        int statusCode = status.code();
        if (statusCode >= 400) {
            String statusCodeString = status.reasonPhrase() != null ? status.reasonPhrase().replace(" ", "") : "";
            String body = bodyAsBytes != null ? new String(bodyAsBytes) : null;
            CosmosError cosmosError = StringUtils.isNotEmpty(body) ? new CosmosError(body) : new CosmosError();
            cosmosError = new CosmosError(statusCodeString, String.format("%s, StatusCode: %s", cosmosError.getMessage(), statusCodeString), cosmosError.getPartitionedQueryExecutionInfo());
            CosmosException dce = BridgeInternal.createCosmosException(request.requestContext.resourcePhysicalAddress, statusCode, cosmosError, headers.toMap());
            BridgeInternal.setRequestHeaders(dce, request.getHeaders());
            throw dce;
        }
    }

    private Mono<RxDocumentServiceResponse> invokeAsyncInternal(RxDocumentServiceRequest request) {
        switch (request.getOperationType()) {
            case Create: 
            case Batch: {
                return this.create(request);
            }
            case Patch: {
                return this.patch(request);
            }
            case Upsert: {
                return this.upsert(request);
            }
            case Delete: {
                if (request.getResourceType() == ResourceType.PartitionKey) {
                    return this.deleteByPartitionKey(request);
                }
                return this.delete(request);
            }
            case ExecuteJavaScript: {
                return this.execute(request);
            }
            case Read: {
                return this.read(request);
            }
            case ReadFeed: {
                return this.readFeed(request);
            }
            case Replace: {
                return this.replace(request);
            }
            case SqlQuery: 
            case Query: 
            case QueryPlan: {
                return this.query(request);
            }
        }
        throw new IllegalStateException("Unknown operation setType " + (Object)((Object)request.getOperationType()));
    }

    private Mono<RxDocumentServiceResponse> invokeAsync(RxDocumentServiceRequest request) {
        Callable funcDelegate = () -> this.invokeAsyncInternal(request).single();
        return BackoffRetryUtility.executeRetry(funcDelegate, new WebExceptionRetryPolicy(BridgeInternal.getRetryContext(request.requestContext.cosmosDiagnostics)));
    }

    @Override
    public Mono<RxDocumentServiceResponse> processMessage(RxDocumentServiceRequest request) {
        this.applySessionToken(request);
        Mono<RxDocumentServiceResponse> responseObs = this.invokeAsync(request);
        return responseObs.onErrorResume(e -> {
            CosmosException dce = Utils.as(e, CosmosException.class);
            if (dce == null) {
                this.logger.error("unexpected failure {}", (Object)e.getMessage(), e);
                return Mono.error((Throwable)e);
            }
            if (!ReplicatedResourceClientUtils.isMasterResource(request.getResourceType()) && (dce.getStatusCode() == 412 || dce.getStatusCode() == 409 || dce.getStatusCode() == 404 && !Exceptions.isSubStatusCode(dce, 1002))) {
                this.captureSessionToken(request, dce.getResponseHeaders());
            }
            if (Exceptions.isThroughputControlRequestRateTooLargeException(dce)) {
                BridgeInternal.recordGatewayResponse(request.requestContext.cosmosDiagnostics, request, null, dce);
                BridgeInternal.setCosmosDiagnostics(dce, request.requestContext.cosmosDiagnostics);
            }
            return Mono.error((Throwable)((Object)dce));
        }).map(response -> {
            this.captureSessionToken(request, response.getResponseHeaders());
            return response;
        });
    }

    @Override
    public void enableThroughputControl(ThroughputControlStore throughputControlStore) {
    }

    private void captureSessionToken(RxDocumentServiceRequest request, Map<String, String> responseHeaders) {
        if (request.getResourceType() == ResourceType.DocumentCollection && request.getOperationType() == OperationType.Delete) {
            String resourceId = request.getIsNameBased() ? responseHeaders.get("x-ms-content-path") : request.getResourceId();
            this.sessionContainer.clearTokenByResourceId(resourceId);
        } else {
            this.sessionContainer.setSessionToken(request, responseHeaders);
        }
    }

    private void applySessionToken(RxDocumentServiceRequest request) {
        boolean sessionTokenApplicable;
        Map<String, String> headers = request.getHeaders();
        Objects.requireNonNull(headers, "RxDocumentServiceRequest::headers is required and cannot be null");
        String requestConsistencyLevel = headers.get("x-ms-consistency-level");
        boolean bl = sessionTokenApplicable = Strings.areEqual(requestConsistencyLevel, ConsistencyLevel.SESSION.toString()) || this.defaultConsistencyLevel == ConsistencyLevel.SESSION && (!request.isReadOnlyRequest() || request.getResourceType() != ResourceType.Document || !Strings.areEqual(requestConsistencyLevel, ConsistencyLevel.EVENTUAL.toString()));
        if (!Strings.isNullOrEmpty(request.getHeaders().get("x-ms-session-token"))) {
            if (!sessionTokenApplicable || RxGatewayStoreModel.isMasterOperation(request.getResourceType(), request.getOperationType())) {
                request.getHeaders().remove("x-ms-session-token");
            }
            return;
        }
        if (!sessionTokenApplicable || RxGatewayStoreModel.isMasterOperation(request.getResourceType(), request.getOperationType())) {
            return;
        }
        String sessionToken = this.sessionContainer.resolveGlobalSessionToken(request);
        if (!Strings.isNullOrEmpty(sessionToken)) {
            headers.put("x-ms-session-token", sessionToken);
        }
    }

    private static boolean isMasterOperation(ResourceType resourceType, OperationType operationType) {
        return ReplicatedResourceClientUtils.isMasterResource(resourceType) || RxGatewayStoreModel.isStoredProcedureMasterOperation(resourceType, operationType) || operationType == OperationType.QueryPlan;
    }

    private static boolean isStoredProcedureMasterOperation(ResourceType resourceType, OperationType operationType) {
        return resourceType == ResourceType.StoredProcedure && operationType != OperationType.ExecuteJavaScript;
    }
}

