/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.BadRequestException;
import com.azure.cosmos.implementation.ISessionContainer;
import com.azure.cosmos.implementation.ISessionToken;
import com.azure.cosmos.implementation.InternalServerErrorException;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.VectorSessionToken;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class SessionTokenHelper {
    public static void setOriginalSessionToken(RxDocumentServiceRequest request, String originalSessionToken) {
        if (request == null) {
            throw new IllegalArgumentException("request is null");
        }
        if (originalSessionToken == null) {
            request.getHeaders().remove("x-ms-session-token");
        } else {
            request.getHeaders().put("x-ms-session-token", originalSessionToken);
        }
    }

    public static void setPartitionLocalSessionToken(RxDocumentServiceRequest request, ISessionContainer sessionContainer) {
        ISessionToken sessionToken;
        String originalSessionToken = request.getHeaders().get("x-ms-session-token");
        String partitionKeyRangeId = request.requestContext.resolvedPartitionKeyRange.getId();
        if (Strings.isNullOrEmpty(partitionKeyRangeId)) {
            throw new InternalServerErrorException("PartitionKeyRangeId is absent in the context.");
        }
        request.requestContext.sessionToken = StringUtils.isNotEmpty(originalSessionToken) ? (sessionToken = SessionTokenHelper.getLocalSessionToken(request, originalSessionToken, partitionKeyRangeId)) : (sessionToken = sessionContainer.resolvePartitionLocalSessionToken(request, partitionKeyRangeId));
        if (request.requestContext.sessionToken == null) {
            request.getHeaders().remove("x-ms-session-token");
        } else {
            request.getHeaders().put("x-ms-session-token", SessionTokenHelper.concatPartitionKeyRangeIdWithSessionToken(partitionKeyRangeId, request.requestContext.sessionToken.convertToString()));
        }
    }

    private static ISessionToken getLocalSessionToken(RxDocumentServiceRequest request, String globalSessionToken, String partitionKeyRangeId) {
        if (partitionKeyRangeId == null) {
            throw new IllegalStateException("Partition key range Id is absent in the context.");
        }
        String[] localTokens = StringUtils.split(globalSessionToken, ",");
        HashSet<String> partitionKeyRangeSet = new HashSet<String>();
        partitionKeyRangeSet.add(partitionKeyRangeId);
        ISessionToken highestSessionToken = null;
        if (request.requestContext.resolvedPartitionKeyRange != null && request.requestContext.resolvedPartitionKeyRange.getParents() != null) {
            partitionKeyRangeSet.addAll(request.requestContext.resolvedPartitionKeyRange.getParents());
        }
        for (String localToken : localTokens) {
            String[] items = StringUtils.split(localToken, ":");
            if (items.length != 2) {
                throw new BadRequestException(String.format("The session token provided '%s' is invalid.", partitionKeyRangeId));
            }
            ISessionToken parsedSessionToken = SessionTokenHelper.parse(items[1]);
            if (!partitionKeyRangeSet.contains(items[0])) continue;
            highestSessionToken = highestSessionToken == null ? parsedSessionToken : highestSessionToken.merge(parsedSessionToken);
        }
        return highestSessionToken;
    }

    static ISessionToken resolvePartitionLocalSessionToken(RxDocumentServiceRequest request, String partitionKeyRangeId, ConcurrentHashMap<String, ISessionToken> rangeIdToTokenMap) {
        if (rangeIdToTokenMap != null) {
            if (rangeIdToTokenMap.containsKey(partitionKeyRangeId)) {
                return rangeIdToTokenMap.get(partitionKeyRangeId);
            }
            List<String> parents = request.requestContext.resolvedPartitionKeyRange.getParents();
            if (parents != null) {
                ArrayList<String> parentsList = new ArrayList<String>(parents);
                for (int i = parentsList.size() - 1; i >= 0; --i) {
                    String parentId = (String)parentsList.get(i);
                    if (!rangeIdToTokenMap.containsKey(parentId)) continue;
                    return rangeIdToTokenMap.get(parentId);
                }
            }
        }
        return null;
    }

    public static ISessionToken parse(String sessionToken) {
        Utils.ValueHolder<Object> partitionKeyRangeSessionToken = Utils.ValueHolder.initialize(null);
        if (SessionTokenHelper.tryParse(sessionToken, partitionKeyRangeSessionToken)) {
            return (ISessionToken)partitionKeyRangeSessionToken.v;
        }
        throw new RuntimeException((Throwable)((Object)new BadRequestException(String.format("The session token provided '%s' is invalid.", sessionToken))));
    }

    static boolean tryParse(String sessionToken, Utils.ValueHolder<ISessionToken> parsedSessionToken) {
        parsedSessionToken.v = null;
        if (!Strings.isNullOrEmpty(sessionToken)) {
            String[] sessionTokenSegments = StringUtils.split(sessionToken, ":");
            return VectorSessionToken.tryCreate(sessionTokenSegments[sessionTokenSegments.length - 1], parsedSessionToken);
        }
        return false;
    }

    public static void validateAndRemoveSessionToken(RxDocumentServiceRequest request) {
        String sessionToken = request.getHeaders().get("x-ms-session-token");
        if (!Strings.isNullOrEmpty(sessionToken)) {
            SessionTokenHelper.getLocalSessionToken(request, sessionToken, "");
            request.getHeaders().remove("x-ms-session-token");
        }
    }

    public static String concatPartitionKeyRangeIdWithSessionToken(String partitionKeyRangeRid, String sessionToken) {
        return partitionKeyRangeRid + ":" + sessionToken;
    }
}

