/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.implementation;

import com.azure.cosmos.implementation.changefeed.Lease;
import com.azure.cosmos.implementation.changefeed.LeaseCheckpointer;
import com.azure.cosmos.implementation.changefeed.PartitionCheckpointer;
import com.azure.cosmos.implementation.changefeed.implementation.ChangeFeedState;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

class PartitionCheckpointerImpl
implements PartitionCheckpointer {
    private final Logger logger = LoggerFactory.getLogger(PartitionCheckpointerImpl.class);
    private final LeaseCheckpointer leaseCheckpointer;
    private Lease lease;

    public PartitionCheckpointerImpl(LeaseCheckpointer leaseCheckpointer, Lease lease) {
        this.leaseCheckpointer = leaseCheckpointer;
        this.lease = lease;
    }

    @Override
    public Mono<Lease> checkpointPartition(ChangeFeedState continuationState) {
        Preconditions.checkNotNull(continuationState, "Argument 'continuationSttae' must not be null.");
        Preconditions.checkArgument(continuationState.getContinuation().getContinuationTokenCount() == 1, "For ChangeFeedProcessor the continuation state should always have one range/continuation");
        return this.leaseCheckpointer.checkpoint(this.lease, continuationState.getContinuation().getCurrentContinuationToken().getToken()).map(lease1 -> {
            this.lease = lease1;
            this.logger.info("Checkpoint: partition {}, new continuation {}", (Object)this.lease.getLeaseToken(), (Object)this.lease.getContinuationToken());
            return lease1;
        });
    }
}

