/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.cpu;

import com.azure.cosmos.implementation.Utils;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpuMemoryReader {
    private static final Logger logger = LoggerFactory.getLogger(CpuMemoryReader.class);
    private final OperatingSystemMXBean operatingSystemMXBean;

    public CpuMemoryReader() {
        java.lang.management.OperatingSystemMXBean mxBean = null;
        try {
            mxBean = ManagementFactory.getOperatingSystemMXBean();
        }
        catch (Throwable t) {
            logger.error("failed to initialized CpuMemoryReader", t);
        }
        this.operatingSystemMXBean = this.tryGetAs(mxBean, OperatingSystemMXBean.class);
    }

    public float getSystemWideCpuUsage() {
        try {
            float val;
            if (this.operatingSystemMXBean != null && (val = (float)this.operatingSystemMXBean.getSystemCpuLoad()) > 0.0f) {
                return val;
            }
            return Float.NaN;
        }
        catch (Throwable t) {
            logger.error("Failed to get System CPU", t);
            return Float.NaN;
        }
    }

    public long getSystemWideMemoryUsage() {
        try {
            long totalMemory = Runtime.getRuntime().totalMemory() / 0x100000L;
            long freeMemory = Runtime.getRuntime().freeMemory() / 0x100000L;
            long maxMemory = Runtime.getRuntime().maxMemory() / 0x100000L;
            return maxMemory - (totalMemory - freeMemory);
        }
        catch (Throwable t) {
            logger.error("Failed to get System memory", t);
            return 0L;
        }
    }

    private <T> T tryGetAs(java.lang.management.OperatingSystemMXBean mxBean, Class<T> classType) {
        try {
            return Utils.as(mxBean, classType);
        }
        catch (Throwable t) {
            logger.error("failed to initialized CpuMemoryReader as type {}", (Object)classType.getName(), (Object)t);
            return null;
        }
    }
}

