/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.ClientSideRequestStatistics;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.QueryMetrics;
import com.azure.cosmos.implementation.RequestChargeTracker;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.query.DocumentProducer;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.OrderByContinuationToken;
import com.azure.cosmos.implementation.query.OrderByUtils;
import com.azure.cosmos.implementation.query.TriFunction;
import com.azure.cosmos.implementation.query.orderbyquery.OrderByRowResult;
import com.azure.cosmos.implementation.query.orderbyquery.OrderbyRowComparer;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class OrderByDocumentProducer<T extends Resource>
extends DocumentProducer<T> {
    private final OrderbyRowComparer<T> consumeComparer;
    private final Map<FeedRangeEpkImpl, OrderByContinuationToken> targetRangeToOrderByContinuationTokenMap;

    OrderByDocumentProducer(OrderbyRowComparer<T> consumeComparer, IDocumentQueryClient client, String collectionResourceId, CosmosQueryRequestOptions cosmosQueryRequestOptions, TriFunction<FeedRangeEpkImpl, String, Integer, RxDocumentServiceRequest> createRequestFunc, Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> executeRequestFunc, PartitionKeyRange targetRange, FeedRangeEpkImpl feedRange, String collectionLink, Callable<DocumentClientRetryPolicy> createRetryPolicyFunc, Class<T> resourceType, UUID correlatedActivityId, int initialPageSize, String initialContinuationToken, int top, Map<FeedRangeEpkImpl, OrderByContinuationToken> targetRangeToOrderByContinuationTokenMap) {
        super(client, collectionResourceId, cosmosQueryRequestOptions, createRequestFunc, executeRequestFunc, targetRange, collectionLink, createRetryPolicyFunc, resourceType, correlatedActivityId, initialPageSize, initialContinuationToken, top, feedRange);
        this.consumeComparer = consumeComparer;
        this.targetRangeToOrderByContinuationTokenMap = targetRangeToOrderByContinuationTokenMap;
    }

    @Override
    protected Flux<DocumentProducer.DocumentProducerFeedResponse> produceOnSplit(Flux<DocumentProducer<T>> replacementProducers) {
        return replacementProducers.collectList().flux().flatMap(documentProducers -> {
            RequestChargeTracker tracker = new RequestChargeTracker();
            HashMap<String, QueryMetrics> queryMetricsMap = new HashMap<String, QueryMetrics>();
            ArrayList<ClientSideRequestStatistics> clientSideRequestStatisticsList = new ArrayList<ClientSideRequestStatistics>();
            return OrderByUtils.orderedMerge(this.resourceType, this.consumeComparer, tracker, documentProducers, queryMetricsMap, this.targetRangeToOrderByContinuationTokenMap, clientSideRequestStatisticsList).map(orderByQueryResult -> this.resultPageFrom(tracker, (OrderByRowResult<T>)orderByQueryResult));
        });
    }

    private DocumentProducer.DocumentProducerFeedResponse resultPageFrom(RequestChargeTracker tracker, OrderByRowResult<T> row) {
        double requestCharge = tracker.getAndResetCharge();
        Map<String, String> headers = Utils.immutableMapOf("x-ms-request-charge", String.valueOf(requestCharge));
        FeedResponse<OrderByRowResult<T>> fr = BridgeInternal.createFeedResponse(Collections.singletonList(row), headers);
        return new DocumentProducer.DocumentProducerFeedResponse(this, fr, row.getSourceRange());
    }

    @Override
    protected DocumentProducer<T> createChildDocumentProducerOnSplit(PartitionKeyRange targetRange, String initialContinuationToken) {
        return new OrderByDocumentProducer<T>(this.consumeComparer, this.client, this.collectionRid, this.cosmosQueryRequestOptions, this.createRequestFunc, this.executeRequestFuncWithRetries, targetRange, new FeedRangeEpkImpl(targetRange.toRange()), this.collectionLink, this.createRetryPolicyFunc, this.resourceType, this.correlatedActivityId, this.pageSize, initialContinuationToken, this.top, this.targetRangeToOrderByContinuationTokenMap);
    }
}

