/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.PartitionKeyRange;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.query.DocumentProducer;
import com.azure.cosmos.implementation.query.DocumentQueryExecutionContextBase;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionComponent;
import com.azure.cosmos.implementation.query.TriFunction;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedRange;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.SqlQuerySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class ParallelDocumentQueryExecutionContextBase<T extends Resource>
extends DocumentQueryExecutionContextBase<T>
implements IDocumentQueryExecutionComponent<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final List<DocumentProducer<T>> documentProducers = new ArrayList<DocumentProducer<T>>();
    protected final SqlQuerySpec querySpec;
    protected int pageSize;
    protected int top = -1;

    protected ParallelDocumentQueryExecutionContextBase(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, CosmosQueryRequestOptions cosmosQueryRequestOptions, String resourceLink, String rewrittenQuery, boolean isContinuationExpected, boolean getLazyFeedResponse, UUID correlatedActivityId) {
        super(diagnosticsClientContext, client, resourceTypeEnum, resourceType, query, cosmosQueryRequestOptions, resourceLink, getLazyFeedResponse, correlatedActivityId);
        this.querySpec = !Strings.isNullOrEmpty(rewrittenQuery) ? new SqlQuerySpec(rewrittenQuery, this.query.getParameters()) : this.query;
    }

    protected void initialize(String collectionRid, Map<FeedRangeEpkImpl, String> feedRangeToContinuationTokenMap, int initialPageSize, SqlQuerySpec querySpecForInit) {
        this.pageSize = initialPageSize;
        Map<String, String> commonRequestHeaders = this.createCommonHeadersAsync(this.getFeedOptions(null, null));
        for (Map.Entry<FeedRangeEpkImpl, String> entry : feedRangeToContinuationTokenMap.entrySet()) {
            TriFunction<FeedRangeEpkImpl, String, Integer, RxDocumentServiceRequest> createRequestFunc = (feedRange, continuationToken, pageSize) -> {
                HashMap<String, String> headers = new HashMap<String, String>(commonRequestHeaders);
                headers.put("x-ms-continuation", (String)continuationToken);
                headers.put("x-ms-max-item-count", Strings.toString(pageSize));
                PartitionKeyInternal partitionKeyInternal = null;
                if (this.cosmosQueryRequestOptions.getPartitionKey() != null && this.cosmosQueryRequestOptions.getPartitionKey() != PartitionKey.NONE) {
                    partitionKeyInternal = BridgeInternal.getPartitionKeyInternal(this.cosmosQueryRequestOptions.getPartitionKey());
                    headers.put("x-ms-documentdb-partitionkey", partitionKeyInternal.toJson());
                }
                return this.createDocumentServiceRequestWithFeedRange((Map<String, String>)headers, querySpecForInit, partitionKeyInternal, (FeedRange)feedRange, collectionRid, this.cosmosQueryRequestOptions.getThroughputControlGroupName());
            };
            Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> executeFunc = request -> this.executeRequestAsync((RxDocumentServiceRequest)request);
            FeedRangeEpkImpl targetRange = entry.getKey();
            String continuationToken2 = entry.getValue();
            DocumentProducer<T> dp = this.createDocumentProducer(collectionRid, null, continuationToken2, initialPageSize, this.cosmosQueryRequestOptions, querySpecForInit, commonRequestHeaders, createRequestFunc, executeFunc, () -> this.client.getResetSessionTokenRetryPolicy().getRequestPolicy(), targetRange);
            this.documentProducers.add(dp);
        }
    }

    protected abstract DocumentProducer<T> createDocumentProducer(String var1, PartitionKeyRange var2, String var3, int var4, CosmosQueryRequestOptions var5, SqlQuerySpec var6, Map<String, String> var7, TriFunction<FeedRangeEpkImpl, String, Integer, RxDocumentServiceRequest> var8, Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> var9, Callable<DocumentClientRetryPolicy> var10, FeedRangeEpkImpl var11);

    @Override
    public abstract Flux<FeedResponse<T>> drainAsync(int var1);

    public void setTop(int newTop) {
        this.top = newTop;
        for (DocumentProducer<T> producer : this.documentProducers) {
            producer.top = newTop;
        }
    }

    protected void initializeReadMany(IDocumentQueryClient queryClient, String collectionResourceId, SqlQuerySpec sqlQuerySpec, Map<PartitionKeyRange, SqlQuerySpec> rangeQueryMap, CosmosQueryRequestOptions cosmosQueryRequestOptions, UUID activityId, String collectionRid) {
        Map<String, String> commonRequestHeaders = this.createCommonHeadersAsync(this.getFeedOptions(null, null));
        for (Map.Entry<PartitionKeyRange, SqlQuerySpec> entry : rangeQueryMap.entrySet()) {
            PartitionKeyRange targetRange = entry.getKey();
            FeedRangeEpkImpl feedRangeEpk = new FeedRangeEpkImpl(targetRange.toRange());
            SqlQuerySpec querySpec = entry.getValue();
            TriFunction<FeedRangeEpkImpl, String, Integer, RxDocumentServiceRequest> createRequestFunc = (partitionKeyRange, continuationToken, pageSize) -> {
                HashMap<String, String> headers = new HashMap<String, String>(commonRequestHeaders);
                headers.put("x-ms-continuation", (String)continuationToken);
                headers.put("x-ms-max-item-count", Strings.toString(pageSize));
                return this.createDocumentServiceRequestWithFeedRange((Map<String, String>)headers, querySpec, null, (FeedRange)partitionKeyRange, collectionRid, cosmosQueryRequestOptions.getThroughputControlGroupName());
            };
            Function<RxDocumentServiceRequest, Mono<FeedResponse<T>>> executeFunc = request -> this.executeRequestAsync((RxDocumentServiceRequest)request);
            DocumentProducer<T> dp = this.createDocumentProducer(collectionRid, targetRange, null, -1, cosmosQueryRequestOptions, querySpec, commonRequestHeaders, createRequestFunc, executeFunc, () -> this.client.getResetSessionTokenRetryPolicy().getRequestPolicy(), feedRangeEpk);
            this.documentProducers.add(dp);
        }
    }
}

