/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.throughputControl.config;

import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.throughputControl.config.ThroughputControlGroupInternal;
import java.time.Duration;

public class GlobalThroughputControlGroup
extends ThroughputControlGroupInternal {
    private static final Duration DEFAULT_CONTROL_ITEM_RENEW_INTERVAL = Duration.ofSeconds(5L);
    private final CosmosAsyncContainer globalControlContainer;
    private final Duration controlItemRenewInterval;
    private final Duration controlItemExpireInterval;

    public GlobalThroughputControlGroup(String groupName, CosmosAsyncContainer targetContainer, Integer targetThroughput, Double targetThroughputThreshold, boolean isDefault, CosmosAsyncContainer globalControlContainer, Duration controlItemRenewInterval, Duration controlItemExpireInterval) {
        super(groupName, targetContainer, targetThroughput, targetThroughputThreshold, isDefault);
        Preconditions.checkNotNull(globalControlContainer, "Global control container can not be null");
        this.globalControlContainer = globalControlContainer;
        this.controlItemRenewInterval = this.getDefaultControlItemRenewInterval(controlItemRenewInterval, controlItemRenewInterval);
        this.controlItemExpireInterval = controlItemExpireInterval != null ? controlItemExpireInterval : Duration.ofSeconds(2L * this.controlItemRenewInterval.getSeconds() + 1L);
    }

    private Duration getDefaultControlItemRenewInterval(Duration controlItemRenewInterval, Duration controlItemExpireInterval) {
        if (controlItemRenewInterval != null) {
            return controlItemRenewInterval;
        }
        if (controlItemExpireInterval != null) {
            return Duration.ofSeconds((controlItemExpireInterval.getSeconds() - 1L) / 2L);
        }
        return DEFAULT_CONTROL_ITEM_RENEW_INTERVAL;
    }

    public CosmosAsyncContainer getGlobalControlContainer() {
        return this.globalControlContainer;
    }

    public Duration getControlItemRenewInterval() {
        return this.controlItemRenewInterval;
    }

    public Duration getControlItemExpireInterval() {
        return this.controlItemExpireInterval;
    }
}

