/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.implementation;

import com.azure.core.util.FluxUtil;
import com.azure.core.util.implementation.BinaryDataContent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Flux;

public final class InputStreamContent
extends BinaryDataContent {
    private static final ClientLogger LOGGER = new ClientLogger(InputStreamContent.class);
    private final InputStream content;
    private final AtomicReference<byte[]> bytes = new AtomicReference();

    public InputStreamContent(InputStream inputStream) {
        this.content = Objects.requireNonNull(inputStream, "'inputStream' cannot be null.");
    }

    @Override
    public Long getLength() {
        if (this.bytes.get() != null) {
            return this.bytes.get().length;
        }
        return null;
    }

    @Override
    public String toString() {
        return new String(this.toBytes(), StandardCharsets.UTF_8);
    }

    @Override
    public byte[] toBytes() {
        byte[] data = this.bytes.get();
        if (data == null) {
            this.bytes.set(this.getBytes());
            data = this.bytes.get();
        }
        return data;
    }

    @Override
    public <T> T toObject(TypeReference<T> typeReference, ObjectSerializer serializer) {
        return serializer.deserializeFromBytes(this.toBytes(), typeReference);
    }

    @Override
    public InputStream toStream() {
        return this.content;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.toBytes()).asReadOnlyBuffer();
    }

    @Override
    public Flux<ByteBuffer> toFluxByteBuffer() {
        return FluxUtil.toFluxByteBuffer(this.content, 8092);
    }

    private byte[] getBytes() {
        try {
            int nRead;
            ByteArrayOutputStream dataOutputBuffer = new ByteArrayOutputStream();
            byte[] data = new byte[8092];
            while ((nRead = this.content.read(data, 0, data.length)) != -1) {
                dataOutputBuffer.write(data, 0, nRead);
            }
            return dataOutputBuffer.toByteArray();
        }
        catch (IOException ex) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(ex));
        }
    }
}

