/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.http.HttpHeaders;
import com.azure.core.implementation.jackson.ObjectMapperShim;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;

public class JacksonAdapter
implements SerializerAdapter {
    private static final Pattern PATTERN = Pattern.compile("^\"*|\"*$");
    private final ClientLogger logger = new ClientLogger(JacksonAdapter.class);
    private final ObjectMapperShim mapper;
    private final ObjectMapperShim xmlMapper;
    private final ObjectMapperShim headerMapper;
    private ObjectMapper rawOuterMapper;
    private ObjectMapper rawInnerMapper;
    private static SerializerAdapter serializerAdapter;

    public JacksonAdapter() {
        this((outerMapper, innerMapper) -> {});
    }

    public JacksonAdapter(BiConsumer<ObjectMapper, ObjectMapper> configureSerialization) {
        Objects.requireNonNull(configureSerialization, "'configureSerialization' cannot be null.");
        this.headerMapper = ObjectMapperShim.createHeaderMapper();
        this.xmlMapper = ObjectMapperShim.createXmlMapper();
        this.mapper = ObjectMapperShim.createJsonMapper(ObjectMapperShim.createSimpleMapper(), (outerMapper, innerMapper) -> this.captureRawMappersAndConfigure((ObjectMapper)outerMapper, (ObjectMapper)innerMapper, configureSerialization));
    }

    private void captureRawMappersAndConfigure(ObjectMapper outerMapper, ObjectMapper innerMapper, BiConsumer<ObjectMapper, ObjectMapper> configure) {
        this.rawOuterMapper = outerMapper;
        this.rawInnerMapper = innerMapper;
        configure.accept(outerMapper, innerMapper);
    }

    @Deprecated
    protected ObjectMapper simpleMapper() {
        return this.rawInnerMapper;
    }

    public static synchronized SerializerAdapter createDefaultSerializerAdapter() {
        if (serializerAdapter == null) {
            serializerAdapter = new JacksonAdapter();
        }
        return serializerAdapter;
    }

    @Deprecated
    public ObjectMapper serializer() {
        return this.rawOuterMapper;
    }

    @Override
    public String serialize(Object object, SerializerEncoding encoding) throws IOException {
        if (object == null) {
            return null;
        }
        if (encoding == SerializerEncoding.XML) {
            return this.xmlMapper.writeValueAsString(object);
        }
        return this.mapper.writeValueAsString(object);
    }

    @Override
    public byte[] serializeToBytes(Object object, SerializerEncoding encoding) throws IOException {
        if (object == null) {
            return null;
        }
        if (encoding == SerializerEncoding.XML) {
            return this.xmlMapper.writeValueAsBytes(object);
        }
        return this.mapper.writeValueAsBytes(object);
    }

    @Override
    public void serialize(Object object, SerializerEncoding encoding, OutputStream outputStream) throws IOException {
        if (object == null) {
            return;
        }
        if (encoding == SerializerEncoding.XML) {
            this.xmlMapper.writeValue(outputStream, object);
        } else {
            this.mapper.writeValue(outputStream, object);
        }
    }

    @Override
    public String serializeRaw(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return PATTERN.matcher(this.serialize(object, SerializerEncoding.JSON)).replaceAll("");
        }
        catch (IOException ex) {
            this.logger.warning("Failed to serialize {} to JSON.", object.getClass(), ex);
            return null;
        }
    }

    @Override
    public String serializeList(List<?> list, CollectionFormat format) {
        return this.serializeIterable(list, format);
    }

    @Override
    public <T> T deserialize(String value, Type type, SerializerEncoding encoding) throws IOException {
        if (CoreUtils.isNullOrEmpty(value)) {
            return null;
        }
        if (encoding == SerializerEncoding.XML) {
            return this.xmlMapper.readValue(value, type);
        }
        return this.mapper.readValue(value, type);
    }

    @Override
    public <T> T deserialize(byte[] bytes, Type type, SerializerEncoding encoding) throws IOException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        if (encoding == SerializerEncoding.XML) {
            return this.xmlMapper.readValue(bytes, type);
        }
        return this.mapper.readValue(bytes, type);
    }

    @Override
    public <T> T deserialize(InputStream inputStream, Type type, SerializerEncoding encoding) throws IOException {
        if (inputStream == null) {
            return null;
        }
        if (encoding == SerializerEncoding.XML) {
            return this.xmlMapper.readValue(inputStream, type);
        }
        return this.mapper.readValue(inputStream, type);
    }

    @Override
    public <T> T deserialize(HttpHeaders headers, Type deserializedHeadersType) throws IOException {
        return this.headerMapper.deserialize(headers, deserializedHeadersType);
    }
}

