/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.naaf.metering;

import com.cloudera.naaf.metering.CloudPlatform;
import com.cloudera.naaf.metering.Invocation;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class StandardInvocation
implements Invocation {
    private final long durationNanos;
    private final boolean successful;
    private final String id = UUID.randomUUID().toString();
    private final String functionId;
    private final String region;
    private final String functionName;
    private final CloudPlatform cloudPlatform;
    private final String flowCrn;
    private final Instant startTime;

    private StandardInvocation(Builder builder) {
        this.durationNanos = builder.durationNanos;
        this.successful = builder.successful;
        this.region = builder.region;
        this.flowCrn = builder.flowCrn;
        this.functionName = builder.functionName;
        this.cloudPlatform = builder.cloudPlatform;
        this.functionId = builder.functionId;
        this.startTime = builder.startTime;
    }

    @Override
    public long getDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.durationNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getFunctionId() {
        return this.functionId;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public CloudPlatform getCloudPlatform() {
        return this.cloudPlatform;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public String getFlowCrn() {
        return this.flowCrn;
    }

    @Override
    public Instant getStartTime() {
        return this.startTime;
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long durationNanos;
        private boolean successful;
        private String region;
        private String functionName;
        private CloudPlatform cloudPlatform;
        private String flowCrn;
        private String functionId;
        private Instant startTime;

        private Builder() {
        }

        public Builder durationNanos(long durationNanos) {
            this.durationNanos = durationNanos;
            return this;
        }

        public Builder successful(boolean successful) {
            this.successful = successful;
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public Builder flowCrn(String flowCrn) {
            this.flowCrn = flowCrn;
            return this;
        }

        public Builder cloudPlatform(CloudPlatform cloudPlatform) {
            this.cloudPlatform = cloudPlatform;
            return this;
        }

        public Builder functionId(String functionId) {
            this.functionId = functionId;
            return this;
        }

        public Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public StandardInvocation build() {
            return new StandardInvocation(this);
        }
    }
}

