/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.naaf.resources;

import com.cloudera.naaf.resources.ResourceDownloader;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

public abstract class AbstractResourceDownloader
implements ResourceDownloader {
    protected Path getDownloadPath(String objectName, File downloadDirectory) {
        if (objectName.endsWith("/")) {
            return null;
        }
        Path filePath = Paths.get(downloadDirectory.getAbsolutePath(), objectName);
        File parentDirectory = filePath.getParent().toFile();
        if (!parentDirectory.exists() && !parentDirectory.mkdirs()) {
            throw new RuntimeException(String.format("Could not create %s in order to download %s", parentDirectory, objectName));
        }
        File file = filePath.toFile();
        if (file.exists()) {
            return null;
        }
        return filePath;
    }

    protected static final String substringAfter(String string, String separator) {
        int index = string.indexOf(separator);
        if (index < 0) {
            return "";
        }
        return string.substring(index + separator.length());
    }
}

