/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flow;

import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.apache.nifi.flow.VersionControlSystemType;

public class VersionedFlowCoordinates {
    private String registryId;
    private String storageLocation;
    private VersionControlSystemType systemType;
    private String changeChannel;
    private String changeChannelOffset;
    private String registryUrl;
    private String bucketId;
    private String flowId;
    private int version;
    private Boolean latest;

    @ApiModelProperty(value="The identifier of the Flow Registry that contains the flow")
    public String getRegistryId() {
        return this.registryId;
    }

    public void setRegistryId(String registryId) {
        this.registryId = registryId;
    }

    @ApiModelProperty(value="The location of the Flow Registry that stores the flow")
    public String getStorageLocation() {
        return this.storageLocation;
    }

    public void setStorageLocation(String storageLocation) {
        this.storageLocation = storageLocation;
    }

    @ApiModelProperty(value="The type of the version control system")
    public VersionControlSystemType getSystemType() {
        return this.systemType;
    }

    public void setSystemType(VersionControlSystemType systemType) {
        this.systemType = systemType;
    }

    @ApiModelProperty(value="The name of the channel where flow designer will publish changes to this flow")
    public String getChangeChannel() {
        return this.changeChannel;
    }

    public void setChangeChannel(String changeChannel) {
        this.changeChannel = changeChannel;
    }

    @ApiModelProperty(value="The offset of the last successfully consumed message from the change channel")
    public String getChangeChannelOffset() {
        return this.changeChannelOffset;
    }

    public void setChangeChannelOffset(String changeChannelOffset) {
        this.changeChannelOffset = changeChannelOffset;
    }

    @Deprecated
    @ApiModelProperty(value="The URL of the Flow Registry that contains the flow")
    public String getRegistryUrl() {
        return this.registryUrl;
    }

    @Deprecated
    public void setRegistryUrl(String registryUrl) {
        this.registryUrl = registryUrl;
    }

    @ApiModelProperty(value="The UUID of the bucket that the flow resides in")
    public String getBucketId() {
        return this.bucketId;
    }

    public void setBucketId(String bucketId) {
        this.bucketId = bucketId;
    }

    @ApiModelProperty(value="The UUID of the flow")
    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    @ApiModelProperty(value="The version of the flow")
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @ApiModelProperty(value="Whether or not these coordinates point to the latest version of the flow")
    public Boolean getLatest() {
        return this.latest;
    }

    public void setLatest(Boolean latest) {
        this.latest = latest;
    }

    public int hashCode() {
        return Objects.hash(this.registryId, this.storageLocation, this.registryUrl, this.bucketId, this.flowId, this.version);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VersionedFlowCoordinates)) {
            return false;
        }
        VersionedFlowCoordinates other = (VersionedFlowCoordinates)obj;
        return Objects.equals(this.registryUrl, other.registryUrl) && Objects.equals(this.bucketId, other.bucketId) && Objects.equals(this.flowId, other.flowId) && Objects.equals(this.version, other.version);
    }

    public String toString() {
        return "VersionedFlowCoordinates[bucketId=" + this.bucketId + ", flowId=" + this.flowId + ", version=" + this.version + ", registryUrl=" + this.registryUrl + "]";
    }
}

