/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.designer.event.control;

import java.util.HashSet;
import org.apache.nifi.designer.event.AbstractFlowDesignerEvent;
import org.apache.nifi.designer.event.EventValidationResult;
import org.apache.nifi.designer.event.control.FlowControlEventType;

public abstract class FlowControlEvent
extends AbstractFlowDesignerEvent {
    private String flowId;
    private String clusterId;

    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public abstract FlowControlEventType getEventType();

    public void setEventType(FlowControlEventType eventType) {
    }

    @Override
    public final EventValidationResult validate() {
        HashSet<String> invalidReasons = new HashSet<String>();
        if (this.isBlank(this.getEventId())) {
            invalidReasons.add("eventId is required");
        }
        if (this.isBlank(this.flowId)) {
            invalidReasons.add("flowId is required");
        }
        if (this.isBlank(this.clusterId)) {
            invalidReasons.add("clusterId is required");
        }
        EventValidationResult additionalFieldsResult = this.validateAdditionalFields();
        invalidReasons.addAll(additionalFieldsResult.getInvalidReasons());
        return invalidReasons.isEmpty() ? EventValidationResult.valid() : EventValidationResult.invalid(invalidReasons);
    }

    protected abstract EventValidationResult validateAdditionalFields();

    @Override
    protected boolean isBlank(String value) {
        return value == null || value.trim().isEmpty();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "eventId=" + this.getEventId() + ", " + "flowId=" + this.flowId + ", " + "clusterId=" + this.clusterId + ", " + "eventType=" + this.getEventType().name() + "]";
    }
}

