/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.authentication.credentials;

import com.cloudera.cdp.ValidationUtils;
import com.cloudera.cdp.authentication.credentials.CdpCredentials;
import com.cloudera.cdp.client.CredentialUtilities;
import java.security.PrivateKey;

public class BasicCdpCredentials
implements CdpCredentials {
    private final String accessKeyId;
    private final PrivateKey privateKey;
    private final String accessToken;

    public BasicCdpCredentials(String accessKeyId, String privateKey) {
        this(accessKeyId, CredentialUtilities.decodePrivateKey(ValidationUtils.checkNotNullAndThrow(privateKey)));
    }

    public BasicCdpCredentials(String accessKeyId, PrivateKey privateKey) {
        ValidationUtils.checkNotNullAndThrow(accessKeyId);
        ValidationUtils.checkNotNullAndThrow(privateKey);
        this.accessKeyId = accessKeyId;
        this.privateKey = privateKey;
        this.accessToken = null;
    }

    public BasicCdpCredentials(String accessToken) {
        ValidationUtils.checkNotNullAndThrow(accessToken);
        this.accessKeyId = null;
        this.privateKey = null;
        this.accessToken = accessToken;
    }

    @Override
    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public Boolean isValid() {
        if (this.getAccessKeyId() != null && this.getPrivateKey() != null) {
            return true;
        }
        if (this.getAccessToken() != null) {
            return true;
        }
        return false;
    }
}

