/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.authentication.credentials;

import com.cloudera.cdp.ValidationUtils;
import com.cloudera.cdp.authentication.credentials.CdpCredentials;
import com.cloudera.cdp.authentication.credentials.CdpCredentialsProvider;
import com.cloudera.cdp.authentication.credentials.profile.CdpProfileConfigFile;
import com.cloudera.cdp.shaded.javax.annotation.Nullable;
import com.cloudera.cdp.shaded.org.apache.commons.lang3.StringUtils;

public class CdpProfileCredentialsProvider
implements CdpCredentialsProvider {
    public static final String CDP_DEFAULT_PROFILE = "CDP_DEFAULT_PROFILE";
    public static final String CDP_DEFAULT_PROFILE_NAME = "default";
    private volatile CdpProfileConfigFile cdpProfileConfigFile;
    private final String cdpProfileName;

    public CdpProfileCredentialsProvider() {
        this(null);
    }

    public CdpProfileCredentialsProvider(@Nullable String profileName) {
        this((CdpProfileConfigFile)null, profileName);
    }

    public CdpProfileCredentialsProvider(String profileFilePath, @Nullable String profileName) {
        this(new CdpProfileConfigFile(ValidationUtils.checkNotNullAndThrow(profileFilePath)), profileName);
    }

    private CdpProfileCredentialsProvider(@Nullable CdpProfileConfigFile profilesConfigFile, @Nullable String profileName) {
        this.cdpProfileConfigFile = profilesConfigFile;
        this.cdpProfileName = StringUtils.isBlank(profileName) ? this.getCdpProfileName() : profileName;
    }

    private String getCdpProfileName() {
        String envProfileName = System.getenv(CDP_DEFAULT_PROFILE);
        if (StringUtils.isBlank(envProfileName)) {
            return CDP_DEFAULT_PROFILE_NAME;
        }
        return envProfileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CdpCredentials getCredentials() {
        if (this.cdpProfileConfigFile == null) {
            CdpProfileCredentialsProvider cdpProfileCredentialsProvider = this;
            synchronized (cdpProfileCredentialsProvider) {
                if (this.cdpProfileConfigFile == null) {
                    this.cdpProfileConfigFile = new CdpProfileConfigFile();
                }
            }
        }
        return this.cdpProfileConfigFile.getCredentials(this.cdpProfileName);
    }
}

