/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.client;

import com.cloudera.cdp.CdpClientException;
import com.cloudera.cdp.ValidationUtils;
import com.cloudera.cdp.annotation.SdkInternalApi;
import com.cloudera.cdp.authentication.credentials.CdpCredentials;
import com.cloudera.cdp.client.BaseResponse;
import com.cloudera.cdp.client.CdpClientConfiguration;
import com.cloudera.cdp.client.CdpClientMiddleware;
import com.cloudera.cdp.client.CdpClientRetryMiddleware;
import com.cloudera.cdp.client.CdpHttpClient;
import com.cloudera.cdp.client.CdpParseResponseMiddleware;
import com.cloudera.cdp.client.CdpRequestAuthMiddleware;
import com.cloudera.cdp.client.CdpRequestContext;
import com.cloudera.cdp.client.CdpRequestHeadersMiddleware;
import com.cloudera.cdp.client.CdpResponse;
import com.cloudera.cdp.client.ClientFactory;
import com.cloudera.cdp.client.Pair;
import com.cloudera.cdp.client.RestResponse;
import com.cloudera.cdp.http.RetryHandler;
import com.cloudera.cdp.shaded.com.google.common.annotations.VisibleForTesting;
import com.cloudera.cdp.shaded.com.google.common.collect.ImmutableMap;
import com.cloudera.cdp.shaded.javax.annotation.Nullable;
import com.cloudera.cdp.shaded.javax.ws.rs.client.Client;
import com.cloudera.cdp.shaded.javax.ws.rs.core.GenericType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

@SdkInternalApi
public abstract class CdpClient {
    protected static final List<Class<? extends CdpClientMiddleware>> NO_EXTENSION = null;
    private static final ClientFactory CLIENT_FACTORY = new ClientFactory();
    private static final String PARAMETER_DATE_TIME_FORMAT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final DateTimeFormatter PARAMETER_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final Map<Class<?>, BiFunction<CdpClientMiddleware, CdpClient, CdpClientMiddleware>> BUILTIN_EXTENSIONS = ImmutableMap.of(CdpClientRetryMiddleware.class, (next, client) -> new CdpClientRetryMiddleware((CdpClientMiddleware)next), CdpRequestHeadersMiddleware.class, (next, client) -> new CdpRequestHeadersMiddleware((CdpClientMiddleware)next, client.headers), CdpRequestAuthMiddleware.class, (next, client) -> new CdpRequestAuthMiddleware((CdpClientMiddleware)next), CdpParseResponseMiddleware.class, (next, client) -> new CdpParseResponseMiddleware((CdpClientMiddleware)next));
    private final CdpCredentials credentials;
    private final String endpoint;
    private final String clientApplicationName;
    private final RetryHandler retryHandler;
    private final Client client;
    private final Map<String, String> headers;

    protected CdpClient(CdpCredentials credentials, String endpoint, CdpClientConfiguration config) {
        this.credentials = ValidationUtils.checkNotNullAndThrow(credentials);
        this.endpoint = ValidationUtils.checkNotNullAndThrow(endpoint);
        ValidationUtils.checkNotNullAndThrow(config);
        this.clientApplicationName = config.getClientApplicationName();
        this.retryHandler = config.getRetryHandler();
        this.headers = config.getRequestHeaders();
        this.client = CLIENT_FACTORY.create(config);
    }

    protected CdpClient(CdpRequestContext<?> context) {
        ValidationUtils.checkNotNullAndThrow(context);
        this.credentials = context.getCredentials();
        this.endpoint = context.getEndpoint();
        this.clientApplicationName = context.getClientApplicationName();
        this.retryHandler = context.getRetryHandler();
        this.headers = context.getHeaders();
        this.client = context.getClient();
    }

    protected abstract String getServiceName();

    protected String getRequestContentType() {
        return "application/json";
    }

    protected String getResponseContentType() {
        return "application/json";
    }

    protected <T extends CdpResponse> T invokeAPI(String operationName, String path, Object body, GenericType<T> returnType, @Nullable List<Class<? extends CdpClientMiddleware>> extensions) {
        ValidationUtils.checkNotNullAndThrow(operationName);
        ValidationUtils.checkNotNullAndThrow(path);
        ValidationUtils.checkNotNullAndThrow(body);
        return (T)((CdpResponse)this.invokeAPI(operationName, "POST", path, Collections.emptyList(), Collections.emptyMap(), body, returnType, extensions));
    }

    protected RestResponse invokeAPI(String operationName, String method, String path, List<Pair> queries, Map<String, String> headers, @Nullable Object body, @Nullable List<Class<? extends CdpClientMiddleware>> extensions) {
        ValidationUtils.checkNotNullAndThrow(operationName);
        ValidationUtils.checkNotNullAndThrow(method);
        ValidationUtils.checkNotNullAndThrow(path);
        ValidationUtils.checkNotNullAndThrow(queries);
        ValidationUtils.checkNotNullAndThrow(headers);
        return this.invokeAPI(operationName, method, path, queries, headers, body, new RestResponseGenericType(), extensions);
    }

    protected <T extends BaseResponse> T invokeAPI(String operationName, String method, String path, List<Pair> queries, Map<String, String> headers, @Nullable Object body, GenericType<T> returnType, @Nullable List<Class<? extends CdpClientMiddleware>> extensions) {
        CdpRequestContext<T> context = new CdpRequestContext<T>(this.client, this.getServiceName(), operationName, returnType);
        context.setClientApplicationName(this.clientApplicationName);
        context.setRetryHandler(this.retryHandler);
        context.setCredentials(this.credentials);
        context.setRequestContentType(this.getRequestContentType());
        context.setResponseContentType(this.getResponseContentType());
        context.setEndpoint(this.endpoint);
        context.setMethod(method);
        context.setPath(path);
        context.setQueries(queries);
        context.setHeaders(headers);
        context.setBody(body);
        this.invokeAPI(context, extensions);
        return context.getResponse();
    }

    @VisibleForTesting
    protected <T extends BaseResponse> void invokeAPI(CdpRequestContext<T> context, @Nullable List<Class<? extends CdpClientMiddleware>> extensions) {
        CdpClientMiddleware current = new CdpHttpClient();
        current = new CdpParseResponseMiddleware(current);
        current = new CdpRequestAuthMiddleware(current);
        current = new CdpRequestHeadersMiddleware(current, this.headers);
        current = new CdpClientRetryMiddleware(current);
        if (extensions != null) {
            for (int i = extensions.size() - 1; i >= 0; --i) {
                Class<? extends CdpClientMiddleware> extensionClz = extensions.get(i);
                current = this.createExtensionInstance(extensionClz, current);
            }
        }
        current.invokeAPI(context);
    }

    @VisibleForTesting
    protected String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof ZonedDateTime) {
            return ((ZonedDateTime)param).withZoneSameInstant(ZoneOffset.UTC).format(PARAMETER_DATE_TIME_FORMATTER);
        }
        if (param instanceof Collection) {
            return ((Collection)param).stream().map(o -> this.parameterToString(o)).collect(Collectors.joining(","));
        }
        return String.valueOf(param);
    }

    @VisibleForTesting
    protected Pair parameterToPair(String name, Object value) {
        return new Pair(name, this.parameterToString(value));
    }

    @VisibleForTesting
    protected List<Pair> parameterToPairs(String collectionFormat, String name, Collection value) {
        ValidationUtils.checkNotNullAndThrow(collectionFormat);
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (value == null) {
            return params;
        }
        if ("multi".equals(collectionFormat)) {
            for (Object item : value) {
                params.add(new Pair(name, this.parameterToString(item)));
            }
            return params;
        }
        String delimiter = ",";
        if ("ssv".equals(collectionFormat)) {
            delimiter = " ";
        } else if ("tsv".equals(collectionFormat)) {
            delimiter = "\t";
        } else if ("pipes".equals(collectionFormat)) {
            delimiter = "|";
        }
        ArrayList<String> values = new ArrayList<String>();
        for (Object item : value) {
            values.add(this.parameterToString(item));
        }
        params.add(new Pair(name, String.join((CharSequence)delimiter, values)));
        return params;
    }

    public void shutdown() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (Exception e) {
                throw new CdpClientException("Error closing client", e);
            }
        }
    }

    private CdpClientMiddleware createExtensionInstance(Class<? extends CdpClientMiddleware> extensionClz, CdpClientMiddleware next) {
        ValidationUtils.checkNotNullAndThrow(extensionClz);
        ValidationUtils.checkNotNullAndThrow(next);
        try {
            BiFunction func = BUILTIN_EXTENSIONS.getOrDefault(extensionClz, null);
            if (func != null) {
                return (CdpClientMiddleware)func.apply(next, this);
            }
            Constructor<? extends CdpClientMiddleware> ctor = extensionClz.getConstructor(CdpClientMiddleware.class);
            return ctor.newInstance(next);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new CdpClientException(String.format("Failed to initialize extension (%s): %s.", extensionClz.getSimpleName(), ex), ex);
        }
    }

    private static class RestResponseGenericType
    extends GenericType<RestResponse> {
        private RestResponseGenericType() {
        }
    }
}

