/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.client;

import com.cloudera.cdp.ValidationUtils;
import com.cloudera.cdp.annotation.SdkInternalApi;
import com.cloudera.cdp.authentication.credentials.CdpCredentialsProvider;
import com.cloudera.cdp.authentication.credentials.DefaultCdpCredentialProviderChain;
import com.cloudera.cdp.client.CdpClientConfiguration;
import com.cloudera.cdp.client.CdpClientConfigurationBuilder;
import com.cloudera.cdp.client.CdpRegion;

@SdkInternalApi
public abstract class CdpClientBuilder<T extends CdpClientBuilder<T>> {
    private static final String CDP_ENDPOINT = "https://api.%s.cdp.cloudera.com:443";
    private static final String ALTUS_ENDPOINT_FORMAT_STRING = "https://%sapi.%s.altus.cloudera.com:443";
    private CdpCredentialsProvider cdpCredentialsProvider;
    private CdpClientConfiguration cdpClientConfiguration;
    private CdpRegion cdpRegion = CdpRegion.US_WEST_1;
    private String cdpEndpoint = null;
    private final boolean cdpEndpointFormat;
    private final String serviceName;

    protected CdpClientBuilder(String serviceName, boolean cdpEndpointFormat) {
        ValidationUtils.checkNotNullAndThrow(serviceName);
        this.cdpCredentialsProvider = DefaultCdpCredentialProviderChain.getInstance();
        this.cdpClientConfiguration = CdpClientConfigurationBuilder.defaultBuilder().build();
        this.cdpEndpointFormat = cdpEndpointFormat;
        this.serviceName = serviceName;
    }

    public CdpCredentialsProvider getCdpCredentials() {
        return this.cdpCredentialsProvider;
    }

    public T withCredentials(CdpCredentialsProvider cdpCredentialsProvider) {
        ValidationUtils.checkNotNullAndThrow(cdpCredentialsProvider);
        this.cdpCredentialsProvider = cdpCredentialsProvider;
        return this.self();
    }

    public T withEndPoint(String cdpEndPoint) {
        ValidationUtils.checkNotNullAndThrow(cdpEndPoint);
        this.cdpEndpoint = cdpEndPoint;
        return this.self();
    }

    public String getCdpEndPoint() {
        if (this.cdpEndpoint != null) {
            return this.cdpEndpoint;
        }
        if (this.cdpEndpointFormat) {
            return this.getCdpFormatEndpoint();
        }
        return this.getAltusFormatEndpoint();
    }

    private String getCdpFormatEndpoint() {
        if (this.cdpRegion == CdpRegion.US_WEST_1) {
            return String.format(CDP_ENDPOINT, new Object[]{CdpRegion.US_WEST_1});
        }
        return String.format(CDP_ENDPOINT, new Object[]{this.cdpRegion});
    }

    private String getAltusFormatEndpoint() {
        if (this.cdpRegion == CdpRegion.US_WEST_1) {
            return String.format(ALTUS_ENDPOINT_FORMAT_STRING, new Object[]{this.serviceName, CdpRegion.US_WEST_1});
        }
        return String.format(CDP_ENDPOINT, new Object[]{this.cdpRegion});
    }

    public T withClientConfiguration(CdpClientConfiguration cdpClientConfiguration) {
        ValidationUtils.checkNotNullAndThrow(cdpClientConfiguration);
        this.cdpClientConfiguration = cdpClientConfiguration;
        return this.self();
    }

    public final CdpClientConfiguration getCdpClientConfiguration() {
        return this.cdpClientConfiguration;
    }

    public T withCdpRegion(CdpRegion cdpRegion) {
        ValidationUtils.checkNotNullAndThrow(cdpRegion);
        this.cdpRegion = cdpRegion;
        return this.self();
    }

    protected abstract T self();
}

