/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.client;

import com.cloudera.cdp.ValidationUtils;
import com.cloudera.cdp.client.CdpClientConfiguration;
import com.cloudera.cdp.http.ExponentialBackoffDelayPolicy;
import com.cloudera.cdp.http.HttpCodesRetryChecker;
import com.cloudera.cdp.http.RetryHandler;
import com.cloudera.cdp.http.SimpleRetryHandler;
import com.cloudera.cdp.shaded.com.google.common.base.MoreObjects;
import com.cloudera.cdp.shaded.javax.annotation.Nullable;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CdpClientConfigurationBuilder {
    private int maxConnections = 20;
    private String clientApplicationName = null;
    private String proxyUri = null;
    private String proxyUsername = null;
    private String proxyPassword = null;
    private Duration readTimeout = Duration.ofMinutes(1L);
    private Duration connectionTimeout = Duration.ofMinutes(1L);
    private Duration connectionMaxIdle = Duration.ofSeconds(50L);
    private Duration validateAfterInactivity = Duration.ofSeconds(2L);
    private RetryHandler retryHandler = new SimpleRetryHandler(new HttpCodesRetryChecker(HttpCodesRetryChecker.DEFAULT_RETRY_CODES), new ExponentialBackoffDelayPolicy(2, Duration.ofMillis(10L), 5), 13);
    private boolean ignoreTls = false;
    private List<X509Certificate> trustedCertificates = new ArrayList<X509Certificate>();
    private Map<String, String> requestHeaders = new HashMap<String, String>();

    private CdpClientConfigurationBuilder() {
    }

    public CdpClientConfigurationBuilder withMaxConnections(int maxConnections) {
        ValidationUtils.checkArgumentAndThrow(maxConnections > 0);
        this.maxConnections = maxConnections;
        return this;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public CdpClientConfigurationBuilder withClientApplicationName(String clientApplicationName) {
        ValidationUtils.checkNotNullAndThrow(clientApplicationName);
        this.clientApplicationName = clientApplicationName;
        return this;
    }

    public String getClientApplicationName() {
        return this.clientApplicationName;
    }

    public CdpClientConfigurationBuilder withConnectionTimeout(Duration connectionTimeout) {
        ValidationUtils.checkArgumentAndThrow(connectionTimeout.toMillis() > 0L);
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public CdpClientConfigurationBuilder withReadTimeout(Duration readTimeout) {
        ValidationUtils.checkArgumentAndThrow(readTimeout.toMillis() > 0L);
        this.readTimeout = readTimeout;
        return this;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public CdpClientConfigurationBuilder withConnectionMaxIdle(Duration connectionMaxIdle) {
        ValidationUtils.checkNotNullAndThrow(connectionMaxIdle);
        this.connectionMaxIdle = connectionMaxIdle;
        return this;
    }

    public Duration getConnectionMaxIdle() {
        return this.connectionMaxIdle;
    }

    public CdpClientConfigurationBuilder withValidateAfterInactivity(Duration validateAfterInactivity) {
        ValidationUtils.checkNotNullAndThrow(validateAfterInactivity);
        this.validateAfterInactivity = validateAfterInactivity;
        return this;
    }

    public Duration getValidateAfterInactivity() {
        return this.validateAfterInactivity;
    }

    public CdpClientConfigurationBuilder withRetryHandler(RetryHandler retryHandler) {
        ValidationUtils.checkNotNullAndThrow(retryHandler);
        this.retryHandler = retryHandler;
        return this;
    }

    public RetryHandler getRetryHandler() {
        return this.retryHandler;
    }

    public CdpClientConfigurationBuilder withProxyUri(@Nullable String proxyUri) {
        this.proxyUri = proxyUri;
        return this;
    }

    public String getProxyUri() {
        return this.proxyUri;
    }

    public CdpClientConfigurationBuilder withProxyUsername(@Nullable String proxyUsername) {
        this.proxyUsername = proxyUsername;
        return this;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public CdpClientConfigurationBuilder withProxyPassword(@Nullable String proxyPassword) {
        this.proxyPassword = proxyPassword;
        return this;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public CdpClientConfigurationBuilder withIgnoreTls(boolean ignoreTls) {
        this.ignoreTls = ignoreTls;
        return this;
    }

    public boolean getIgnoreTls() {
        return this.ignoreTls;
    }

    public CdpClientConfigurationBuilder withTrustedCertificates(List<X509Certificate> trustedCertificates) {
        ValidationUtils.checkNotNullAndThrow(trustedCertificates);
        this.trustedCertificates = trustedCertificates;
        return this;
    }

    public CdpClientConfigurationBuilder addTrustedCertificate(X509Certificate trustedCertificate) {
        ValidationUtils.checkNotNullAndThrow(trustedCertificate);
        this.trustedCertificates.add(trustedCertificate);
        return this;
    }

    public List<X509Certificate> getTrustedCertificates() {
        return this.trustedCertificates;
    }

    public CdpClientConfigurationBuilder withRequestHeaders(Map<String, String> requestHeaders) {
        ValidationUtils.checkNotNullAndThrow(requestHeaders);
        this.requestHeaders = requestHeaders;
        return this;
    }

    public CdpClientConfigurationBuilder addRequestHeader(String name, String value) {
        ValidationUtils.checkNotNullAndThrow(name);
        ValidationUtils.checkNotNullAndThrow(value);
        this.requestHeaders.put(name, value);
        return this;
    }

    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public static CdpClientConfigurationBuilder defaultBuilder() {
        return new CdpClientConfigurationBuilder();
    }

    public CdpClientConfiguration build() {
        return new CdpClientConfiguration(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("readTimeout", this.getReadTimeout()).add("connectionTimeout", this.getConnectionTimeout()).add("clientApplicationName", this.getClientApplicationName()).add("Proxy URI", this.getProxyUri()).add("Proxy Username", this.getProxyUsername()).add("Proxy Password", "<hidden>").add("Ignore TLS", this.getIgnoreTls()).add("Trusted Certs", "<hidden>").add("Request Headers", "<hidden>").toString();
    }
}

