/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.client;

import com.cloudera.cdp.CdpClientException;
import com.cloudera.cdp.ValidationUtils;
import com.cloudera.cdp.annotation.SdkInternalApi;
import com.cloudera.cdp.client.BaseResponse;
import com.cloudera.cdp.client.CdpClientMiddleware;
import com.cloudera.cdp.client.CdpRequestContext;
import com.cloudera.cdp.http.RetryHandler;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SdkInternalApi
public class CdpClientRetryMiddleware
implements CdpClientMiddleware {
    private static final Logger LOG = LoggerFactory.getLogger(CdpClientRetryMiddleware.class);
    private final CdpClientMiddleware next;

    public CdpClientRetryMiddleware(CdpClientMiddleware next) {
        this.next = ValidationUtils.checkNotNullAndThrow(next);
    }

    @Override
    public <T extends BaseResponse> void invokeAPI(CdpRequestContext<T> context) {
        ValidationUtils.checkNotNullAndThrow(context);
        RetryHandler retryHandler = ValidationUtils.checkNotNullAndThrow(context.getRetryHandler());
        int attempts = 0;
        while (true) {
            ++attempts;
            try {
                this.next.invokeAPI(context);
                return;
            }
            catch (CdpClientException exception) {
                Duration delay = retryHandler.shouldRetry(attempts, exception);
                if (delay == RetryHandler.DO_NOT_RETRY) {
                    throw exception;
                }
                LOG.warn("Caught exception", (Throwable)exception);
                LOG.warn("Wait {} milli-seconds then retry.", (Object)delay.toMillis());
                try {
                    Thread.sleep(delay.toMillis());
                }
                catch (InterruptedException e) {
                    throw new CdpClientException("Error while retrying request", e);
                }
            }
        }
    }
}

