/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.client;

import com.cloudera.cdp.ValidationUtils;
import com.cloudera.cdp.annotation.SdkInternalApi;
import com.cloudera.cdp.client.BaseResponse;
import com.cloudera.cdp.client.CdpClientMiddleware;
import com.cloudera.cdp.client.CdpRequestContext;
import com.cloudera.cdp.client.Pair;
import com.cloudera.cdp.shaded.com.google.common.annotations.VisibleForTesting;
import com.cloudera.cdp.shaded.javax.ws.rs.client.Entity;
import com.cloudera.cdp.shaded.javax.ws.rs.client.Invocation;
import com.cloudera.cdp.shaded.javax.ws.rs.client.WebTarget;
import com.cloudera.cdp.shaded.javax.ws.rs.core.Response;
import java.util.Map;

@SdkInternalApi
public class CdpHttpClient
implements CdpClientMiddleware {
    @Override
    public <T extends BaseResponse> void invokeAPI(CdpRequestContext<T> context) {
        ValidationUtils.checkNotNullAndThrow(context);
        Response response = this.getAPIResponse(context);
        context.setRawResponse(response);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    Response getAPIResponse(CdpRequestContext<?> context) {
        void var4_8;
        WebTarget t = context.getClient().target(context.getRequestUrl());
        for (Pair pair : context.getQueries()) {
            t = t.queryParam(pair.getName(), pair.getValue());
        }
        for (Map.Entry entry : context.getProperties().entrySet()) {
            t = (WebTarget)t.property((String)entry.getKey(), entry.getValue());
        }
        String contentType = context.getRequestContentType();
        Invocation.Builder builder = t.request();
        for (Map.Entry<String, String> header : context.getHeaders().entrySet()) {
            String headerName = header.getKey();
            if (headerName.equals("Content-Type")) {
                contentType = header.getValue();
                continue;
            }
            Invocation.Builder builder2 = var4_8.header(headerName, header.getValue());
        }
        if (context.getBody() == null) {
            return var4_8.method(context.getMethod());
        }
        return var4_8.method(context.getMethod(), Entity.entity(context.getBody(), contentType));
    }
}

