/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.client;

import com.cloudera.cdp.ValidationUtils;
import com.cloudera.cdp.annotation.SdkInternalApi;
import com.cloudera.cdp.authentication.Signer;
import com.cloudera.cdp.client.BaseResponse;
import com.cloudera.cdp.client.CdpClientMiddleware;
import com.cloudera.cdp.client.CdpRequestContext;
import com.cloudera.cdp.shaded.com.google.common.base.Strings;
import java.security.PrivateKey;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

@SdkInternalApi
public class CdpRequestAuthMiddleware
implements CdpClientMiddleware {
    private final CdpClientMiddleware next;

    public CdpRequestAuthMiddleware(CdpClientMiddleware next) {
        this.next = ValidationUtils.checkNotNullAndThrow(next);
    }

    @Override
    public <T extends BaseResponse> void invokeAPI(CdpRequestContext<T> context) {
        ValidationUtils.checkNotNullAndThrow(context);
        this.computeAuthHeaders(context);
        this.next.invokeAPI(context);
    }

    private void computeAuthHeaders(CdpRequestContext<?> context) {
        Map<String, String> headers = context.getHeaders();
        String accessKeyId = context.getCredentials().getAccessKeyId();
        PrivateKey privateKey = context.getCredentials().getPrivateKey();
        String accessToken = context.getCredentials().getAccessToken();
        if (!Strings.isNullOrEmpty(accessKeyId) && privateKey != null) {
            String date = ZonedDateTime.now(ZoneId.of("GMT")).format(DateTimeFormatter.RFC_1123_DATE_TIME);
            String method = context.getMethod();
            String auth = new Signer().computeAuthHeader(method, context.getRequestContentType(), date, context.getRequestUrl().getPath(), accessKeyId, privateKey);
            headers.put("x-altus-date", date);
            headers.put("x-altus-auth", auth);
        } else if (!Strings.isNullOrEmpty(accessToken)) {
            headers.put("Authorization", accessToken);
        }
    }
}

