/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.client;

import com.cloudera.cdp.ValidationUtils;
import com.cloudera.cdp.annotation.SdkInternalApi;
import com.cloudera.cdp.authentication.credentials.CdpCredentials;
import com.cloudera.cdp.client.BaseResponse;
import com.cloudera.cdp.client.Pair;
import com.cloudera.cdp.http.RetryHandler;
import com.cloudera.cdp.shaded.javax.annotation.Nullable;
import com.cloudera.cdp.shaded.javax.ws.rs.client.Client;
import com.cloudera.cdp.shaded.javax.ws.rs.core.GenericType;
import com.cloudera.cdp.shaded.javax.ws.rs.core.Response;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class CdpRequestContext<T extends BaseResponse> {
    private final Client client;
    private final String serviceName;
    private final String operationName;
    private final GenericType<T> responseType;
    private String clientApplicationName;
    private RetryHandler retryHandler;
    private CdpCredentials credentials;
    private String requestContentType;
    private String responseContentType;
    private String endpoint;
    private String method;
    private String path;
    private List<Pair> queries;
    private Map<String, String> headers;
    private Object body;
    private Response rawResponse;
    private T response;
    private Map<String, Object> properties;

    public CdpRequestContext(Client client, String serviceName, String operationName, GenericType<T> responseType) {
        this.client = ValidationUtils.checkNotNullAndThrow(client);
        this.serviceName = ValidationUtils.checkNotNullAndThrow(serviceName);
        this.operationName = ValidationUtils.checkNotNullAndThrow(operationName);
        this.responseType = ValidationUtils.checkNotNullAndThrow(responseType);
    }

    public CdpRequestContext(Client client, String serviceName, String operationName, GenericType<T> responseType, CdpRequestContext context) {
        this(client, serviceName, operationName, responseType);
        this.setClientApplicationName(context.getClientApplicationName());
        this.setRetryHandler(context.getRetryHandler());
        this.setCredentials(context.getCredentials());
        this.setRequestContentType(context.getRequestContentType());
        this.setResponseContentType(context.getResponseContentType());
        this.setEndpoint(context.getEndpoint());
        this.setMethod(context.getMethod());
        this.setPath(context.getPath());
        this.getQueries().addAll(context.getQueries());
        this.getHeaders().putAll(context.getHeaders());
        this.setBody(context.getBody());
        this.getProperties().putAll(context.getProperties());
    }

    public Client getClient() {
        return this.client;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public GenericType<T> getResponseType() {
        return this.responseType;
    }

    @Nullable
    public String getClientApplicationName() {
        return this.clientApplicationName;
    }

    public void setClientApplicationName(@Nullable String clientApplicationName) {
        this.clientApplicationName = clientApplicationName;
    }

    public RetryHandler getRetryHandler() {
        return this.retryHandler;
    }

    public void setRetryHandler(RetryHandler retryHandler) {
        this.retryHandler = ValidationUtils.checkNotNullAndThrow(retryHandler);
    }

    public CdpCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(CdpCredentials credentials) {
        this.credentials = ValidationUtils.checkNotNullAndThrow(credentials);
    }

    public String getRequestContentType() {
        return this.requestContentType;
    }

    public void setRequestContentType(String requestContentType) {
        this.requestContentType = ValidationUtils.checkNotNullAndThrow(requestContentType);
    }

    public String getResponseContentType() {
        return this.responseContentType;
    }

    public void setResponseContentType(String responseContentType) {
        this.responseContentType = ValidationUtils.checkNotNullAndThrow(responseContentType);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = ValidationUtils.checkNotNullAndThrow(endpoint);
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = ValidationUtils.checkNotNullAndThrow(method);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = ValidationUtils.checkNotNullAndThrow(path);
    }

    public List<Pair> getQueries() {
        if (this.queries == null) {
            this.queries = new ArrayList<Pair>();
        }
        return this.queries;
    }

    public void setQueries(List<Pair> queries) {
        this.queries = ValidationUtils.checkNotNullAndThrow(queries);
    }

    public Map<String, String> getHeaders() {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = ValidationUtils.checkNotNullAndThrow(headers);
    }

    @Nullable
    public Object getBody() {
        return this.body;
    }

    public void setBody(@Nullable Object body) {
        this.body = body;
    }

    @Nullable
    public Response getRawResponse() {
        return this.rawResponse;
    }

    public void setRawResponse(@Nullable Response rawResponse) {
        this.rawResponse = rawResponse;
    }

    @Nullable
    public T getResponse() {
        return this.response;
    }

    public void setResponse(@Nullable T response) {
        this.response = response;
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        return this.properties;
    }

    public URI getRequestUrl() {
        return URI.create(this.getEndpoint() + this.getPath()).normalize();
    }
}

