/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.client;

import com.cloudera.cdp.ValidationUtils;
import com.cloudera.cdp.annotation.SdkInternalApi;
import com.cloudera.cdp.client.BaseResponse;
import com.cloudera.cdp.client.CdpClientMiddleware;
import com.cloudera.cdp.client.CdpRequestContext;
import com.cloudera.cdp.shaded.com.google.common.annotations.VisibleForTesting;
import com.cloudera.cdp.shaded.com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SdkInternalApi
public class CdpRequestHeadersMiddleware
implements CdpClientMiddleware {
    private static final Logger LOG = LoggerFactory.getLogger(CdpRequestHeadersMiddleware.class);
    private static final String VERSION_PROPERTIES_FILE = "version.properties";
    private static final Properties VERSION_PROPERTIES = CdpRequestHeadersMiddleware.loadVersionProperties();
    private final CdpClientMiddleware next;
    private final Map<String, String> headers;

    private static Properties loadVersionProperties() {
        Properties props = new Properties();
        try (InputStream stream = CdpRequestHeadersMiddleware.class.getResourceAsStream(VERSION_PROPERTIES_FILE);){
            props.load(stream);
        }
        catch (IOException | RuntimeException e) {
            props.put("version", "Unknown");
            LOG.warn("Failed to read CDP SDK Version.", (Throwable)e);
        }
        return props;
    }

    public CdpRequestHeadersMiddleware(CdpClientMiddleware next, Map<String, String> headers) {
        this.next = ValidationUtils.checkNotNullAndThrow(next);
        this.headers = ValidationUtils.checkNotNullAndThrow(headers);
    }

    @Override
    public <T extends BaseResponse> void invokeAPI(CdpRequestContext<T> context) {
        ValidationUtils.checkNotNullAndThrow(context);
        this.computeHeaders(context);
        this.next.invokeAPI(context);
    }

    private void computeHeaders(CdpRequestContext<?> context) {
        String altusClientApp;
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.putAll(context.getHeaders());
        headers.put("User-Agent", CdpRequestHeadersMiddleware.buildUserAgent());
        String method = context.getMethod();
        if (method.equals("POST") || method.equals("PUT") || method.equals("PATCH")) {
            headers.put("Content-Type", context.getRequestContentType());
        }
        if (!method.equals("DELETE")) {
            headers.put("Accept", context.getResponseContentType());
        }
        if (!Strings.isNullOrEmpty(altusClientApp = context.getClientApplicationName())) {
            headers.put("x-altus-client-app", altusClientApp);
        }
        context.setHeaders(headers);
    }

    @VisibleForTesting
    static String buildUserAgent() {
        return String.format("CDPSDK/%s Java/%s %s/%s", VERSION_PROPERTIES.get("version"), System.getProperty("java.version"), System.getProperty("os.name"), System.getProperty("os.version"));
    }
}

