/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.client;

import com.cloudera.cdp.ValidationUtils;
import com.cloudera.cdp.annotation.SdkInternalApi;
import com.cloudera.cdp.client.BaseResponse;
import com.cloudera.cdp.shaded.com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public abstract class CdpResponse
extends BaseResponse {
    public static final String ALTUS_HEADER_REQUESTID = "x-altus-request-id";
    public static final String CDP_HEADER_REQUESTID = "x-cdp-request-id";

    public String getRequestId() {
        return CdpResponse.getRequestId(this.getResponseHeaders());
    }

    static String getRequestId(Map<String, List<String>> responseHeaders) {
        ValidationUtils.checkNotNullAndThrow(responseHeaders);
        List<String> values = responseHeaders.get(ALTUS_HEADER_REQUESTID);
        if (values == null) {
            values = responseHeaders.get(CDP_HEADER_REQUESTID);
        }
        if (values == null) {
            return "unknown";
        }
        return Iterables.getOnlyElement(values);
    }
}

