/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.client;

import com.cloudera.cdp.CdpClientException;
import com.cloudera.cdp.ValidationUtils;
import com.cloudera.cdp.annotation.SdkInternalApi;
import com.cloudera.cdp.client.CdpClientConfiguration;
import com.cloudera.cdp.shaded.org.apache.http.config.Registry;
import com.cloudera.cdp.shaded.org.apache.http.config.RegistryBuilder;
import com.cloudera.cdp.shaded.org.apache.http.conn.socket.ConnectionSocketFactory;
import com.cloudera.cdp.shaded.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import com.cloudera.cdp.shaded.org.apache.http.conn.ssl.DefaultHostnameVerifier;
import com.cloudera.cdp.shaded.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.cloudera.cdp.shaded.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

@SdkInternalApi
class ConnectionManagerFactory {
    private static final KeyStore USE_DEFAULT_KEYSTORE = null;

    ConnectionManagerFactory() {
    }

    public PoolingHttpClientConnectionManager create(CdpClientConfiguration config) {
        SSLContext sslContext;
        HostnameVerifier hostnameVerifier;
        TrustManager[] trustManagers;
        ValidationUtils.checkNotNullAndThrow(config);
        if (config.getIgnoreTls()) {
            trustManagers = new TrustManager[]{ConnectionManagerFactory.createIgnoreCertTrustManger()};
            hostnameVerifier = (s1, s2) -> true;
        } else {
            try {
                KeyStore ks;
                if (config.getTrustedCertificates().isEmpty()) {
                    ks = USE_DEFAULT_KEYSTORE;
                } else {
                    ks = KeyStore.getInstance(KeyStore.getDefaultType());
                    ks.load(null);
                    for (X509Certificate cert : config.getTrustedCertificates()) {
                        ks.setCertificateEntry(UUID.randomUUID().toString(), cert);
                    }
                }
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(ks);
                trustManagers = trustManagerFactory.getTrustManagers();
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new CdpClientException("Error initializing truststore", e);
            }
            hostnameVerifier = new DefaultHostnameVerifier();
        }
        try {
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagers, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new CdpClientException("Error initializing SSL", e);
        }
        Registry<ConnectionSocketFactory> socketFactoryRegistry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)new SSLConnectionSocketFactory(sslContext, hostnameVerifier))).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connectionManager.setValidateAfterInactivity((int)config.getValidateAfterInactivity().toMillis());
        connectionManager.setDefaultMaxPerRoute(config.getMaxConnections());
        connectionManager.setMaxTotal(config.getMaxConnections());
        return connectionManager;
    }

    private static X509TrustManager createIgnoreCertTrustManger() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }
}

