/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.environments.model;

import com.cloudera.cdp.environments.model.CloudSubnet;
import com.cloudera.cdp.environments.model.NetworkAwsParams;
import com.cloudera.cdp.environments.model.NetworkAzureParams;
import com.cloudera.cdp.environments.model.NetworkGcpParams;
import com.cloudera.cdp.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Network {
    private String networkName = null;
    private List<String> subnetIds = new ArrayList<String>();
    private String endpointAccessGatewayScheme = null;
    private List<String> endpointAccessGatewaySubnetIds = new ArrayList<String>();
    private NetworkAwsParams aws = null;
    private NetworkAzureParams azure = null;
    private NetworkGcpParams gcp = null;
    private String networkCidr = null;
    private Map<String, CloudSubnet> subnetMetadata = new HashMap<String, CloudSubnet>();

    @JsonProperty(value="networkName")
    public String getNetworkName() {
        return this.networkName;
    }

    public void setNetworkName(String networkName) {
        this.networkName = networkName;
    }

    @JsonProperty(value="subnetIds")
    public List<String> getSubnetIds() {
        return this.subnetIds;
    }

    public void setSubnetIds(List<String> subnetIds) {
        this.subnetIds = subnetIds;
    }

    @JsonProperty(value="endpointAccessGatewayScheme")
    public String getEndpointAccessGatewayScheme() {
        return this.endpointAccessGatewayScheme;
    }

    public void setEndpointAccessGatewayScheme(String endpointAccessGatewayScheme) {
        this.endpointAccessGatewayScheme = endpointAccessGatewayScheme;
    }

    @JsonProperty(value="endpointAccessGatewaySubnetIds")
    public List<String> getEndpointAccessGatewaySubnetIds() {
        return this.endpointAccessGatewaySubnetIds;
    }

    public void setEndpointAccessGatewaySubnetIds(List<String> endpointAccessGatewaySubnetIds) {
        this.endpointAccessGatewaySubnetIds = endpointAccessGatewaySubnetIds;
    }

    @JsonProperty(value="aws")
    public NetworkAwsParams getAws() {
        return this.aws;
    }

    public void setAws(NetworkAwsParams aws) {
        this.aws = aws;
    }

    @JsonProperty(value="azure")
    public NetworkAzureParams getAzure() {
        return this.azure;
    }

    public void setAzure(NetworkAzureParams azure) {
        this.azure = azure;
    }

    @JsonProperty(value="gcp")
    public NetworkGcpParams getGcp() {
        return this.gcp;
    }

    public void setGcp(NetworkGcpParams gcp) {
        this.gcp = gcp;
    }

    @JsonProperty(value="networkCidr")
    public String getNetworkCidr() {
        return this.networkCidr;
    }

    public void setNetworkCidr(String networkCidr) {
        this.networkCidr = networkCidr;
    }

    @JsonProperty(value="subnetMetadata")
    public Map<String, CloudSubnet> getSubnetMetadata() {
        return this.subnetMetadata;
    }

    public void setSubnetMetadata(Map<String, CloudSubnet> subnetMetadata) {
        this.subnetMetadata = subnetMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Network network = (Network)o;
        if (!Objects.equals(this.networkName, network.networkName)) {
            return false;
        }
        if (!Objects.equals(this.subnetIds, network.subnetIds)) {
            return false;
        }
        if (!Objects.equals(this.endpointAccessGatewayScheme, network.endpointAccessGatewayScheme)) {
            return false;
        }
        if (!Objects.equals(this.endpointAccessGatewaySubnetIds, network.endpointAccessGatewaySubnetIds)) {
            return false;
        }
        if (!Objects.equals(this.aws, network.aws)) {
            return false;
        }
        if (!Objects.equals(this.azure, network.azure)) {
            return false;
        }
        if (!Objects.equals(this.gcp, network.gcp)) {
            return false;
        }
        if (!Objects.equals(this.networkCidr, network.networkCidr)) {
            return false;
        }
        return Objects.equals(this.subnetMetadata, network.subnetMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.networkName, this.subnetIds, this.endpointAccessGatewayScheme, this.endpointAccessGatewaySubnetIds, this.aws, this.azure, this.gcp, this.networkCidr, this.subnetMetadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Network {\n");
        sb.append("    networkName: ").append(this.toIndentedString(this.networkName)).append("\n");
        sb.append("    subnetIds: ").append(this.toIndentedString(this.subnetIds)).append("\n");
        sb.append("    endpointAccessGatewayScheme: ").append(this.toIndentedString(this.endpointAccessGatewayScheme)).append("\n");
        sb.append("    endpointAccessGatewaySubnetIds: ").append(this.toIndentedString(this.endpointAccessGatewaySubnetIds)).append("\n");
        sb.append("    aws: ").append(this.toIndentedString(this.aws)).append("\n");
        sb.append("    azure: ").append(this.toIndentedString(this.azure)).append("\n");
        sb.append("    gcp: ").append(this.toIndentedString(this.gcp)).append("\n");
        sb.append("    networkCidr: ").append(this.toIndentedString(this.networkCidr)).append("\n");
        sb.append("    subnetMetadata: ").append(this.toIndentedString(this.subnetMetadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

