/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.extension;

import com.cloudera.cdp.CdpClientException;
import com.cloudera.cdp.ValidationUtils;
import com.cloudera.cdp.annotation.SdkInternalApi;
import com.cloudera.cdp.client.BaseResponse;
import com.cloudera.cdp.client.CdpClientMiddleware;
import com.cloudera.cdp.client.CdpRequestContext;
import com.cloudera.cdp.client.Pair;
import com.cloudera.cdp.client.RestResponse;
import com.cloudera.cdp.shaded.com.google.common.base.Strings;
import com.cloudera.cdp.shaded.javax.ws.rs.core.GenericType;
import com.cloudera.cdp.shaded.javax.ws.rs.core.Response;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SdkInternalApi
public class Redirect
implements CdpClientMiddleware {
    private static final Logger LOG = LoggerFactory.getLogger(Redirect.class);
    private final CdpClientMiddleware next;

    public Redirect(CdpClientMiddleware next) {
        this.next = ValidationUtils.checkNotNullAndThrow(next);
    }

    @Override
    public <T extends BaseResponse> void invokeAPI(CdpRequestContext<T> context) {
        ValidationUtils.checkNotNullAndThrow(context);
        String redirectUrl = this.findRedirectLocation(context);
        if (Strings.isNullOrEmpty(redirectUrl) || !URI.create(redirectUrl).isAbsolute()) {
            throw new CdpClientException("Missing or incorrect redirect URL");
        }
        context.setEndpoint(redirectUrl);
        context.setPath("");
        context.setQueries(new ArrayList<Pair>());
        this.next.invokeAPI(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findRedirectLocation(CdpRequestContext<?> context) {
        CdpRequestContext<RestResponse> redirectContext = new CdpRequestContext<RestResponse>(context.getClient(), context.getServiceName(), context.getOperationName(), new RestResponseGenericType(), context);
        redirectContext.getProperties().put("jersey.config.client.followRedirects", false);
        this.next.invokeAPI(redirectContext);
        RestResponse redirectResponse = redirectContext.getResponse();
        if (redirectResponse == null) {
            throw new CdpClientException("Missing redirect response");
        }
        try {
            if (redirectResponse.getStatusInfo().getFamily() != Response.Status.Family.REDIRECTION) {
                throw new CdpClientException(String.format("Redirect response status code is incorrect. HTTP status: %d", redirectResponse.getHttpCode()));
            }
            List locationHeaders = redirectResponse.getResponseHeaders().getOrDefault("Location", null);
            if (locationHeaders == null || locationHeaders.isEmpty()) {
                throw new CdpClientException("Missing Location response header");
            }
            String redirectUrl = (String)locationHeaders.get(0);
            LOG.debug("Redirect request status: {}, redirect to: {}", (Object)redirectResponse.getHttpCode(), (Object)redirectUrl);
            String string = redirectUrl;
            return string;
        }
        finally {
            redirectResponse.close();
        }
    }

    private static class RestResponseGenericType
    extends GenericType<RestResponse> {
        private RestResponseGenericType() {
        }
    }
}

