/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.extension;

import com.cloudera.cdp.CdpClientException;
import com.cloudera.cdp.ValidationUtils;
import com.cloudera.cdp.annotation.SdkInternalApi;
import com.cloudera.cdp.authentication.credentials.BasicCdpCredentials;
import com.cloudera.cdp.client.BaseResponse;
import com.cloudera.cdp.client.CdpClientMiddleware;
import com.cloudera.cdp.client.CdpRequestContext;
import com.cloudera.cdp.iam.api.IamClient;
import com.cloudera.cdp.iam.model.GenerateWorkloadAuthTokenRequest;
import com.cloudera.cdp.iam.model.GenerateWorkloadAuthTokenResponse;
import com.cloudera.cdp.shaded.com.google.common.base.Strings;
import java.lang.reflect.Method;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SdkInternalApi
public class Workload
implements CdpClientMiddleware {
    private static final Logger LOG = LoggerFactory.getLogger(Workload.class);
    private final CdpClientMiddleware next;

    public Workload(CdpClientMiddleware next) {
        this.next = ValidationUtils.checkNotNullAndThrow(next);
    }

    @Override
    public <T extends BaseResponse> void invokeAPI(CdpRequestContext<T> context) {
        String environmentCrn;
        String workloadName;
        ValidationUtils.checkNotNullAndThrow(context);
        if (!Strings.isNullOrEmpty(context.getCredentials().getAccessToken())) {
            LOG.debug("Skip workload service-discovery");
            this.next.invokeAPI(context);
            return;
        }
        LOG.debug("Run workload service-discovery");
        String serviceName = context.getServiceName();
        if (Strings.isNullOrEmpty(serviceName)) {
            throw new CdpClientException("Missing service name");
        }
        if (serviceName.equals("dfworkload")) {
            workloadName = "DF";
            environmentCrn = this.getEnvironmentCrn(context.getBody());
            if (Strings.isNullOrEmpty(environmentCrn)) {
                throw new CdpClientException("Missing environment CRN");
            }
        } else {
            throw new CdpClientException(String.format("Unknown service name '%s'", serviceName));
        }
        IamClient iamClient = new IamClient(context);
        GenerateWorkloadAuthTokenRequest request = new GenerateWorkloadAuthTokenRequest();
        request.setWorkloadName(workloadName);
        request.setEnvironmentCrn(environmentCrn);
        GenerateWorkloadAuthTokenResponse response = iamClient.generateWorkloadAuthToken(request);
        String workloadUrl = response.getEndpointUrl();
        String workloadAccessToken = response.getToken();
        LOG.debug(String.format("Workload service-discovery succeeded. endpointUrl=%s, accessToken=%s...", workloadUrl, Workload.sanitizeAccessToken(workloadAccessToken)));
        if (!Strings.isNullOrEmpty(workloadUrl)) {
            workloadUrl = URI.create(workloadUrl).resolve("/").toString();
        }
        if (!Strings.isNullOrEmpty(workloadAccessToken) && !workloadAccessToken.startsWith("Bearer ")) {
            workloadAccessToken = "Bearer " + workloadAccessToken;
        }
        context.setEndpoint(workloadUrl);
        context.setCredentials(new BasicCdpCredentials(workloadAccessToken));
        this.next.invokeAPI(context);
    }

    private String getEnvironmentCrn(Object requestBody) {
        ValidationUtils.checkNotNullAndThrow(requestBody);
        try {
            Method method = requestBody.getClass().getMethod("getEnvironmentCrn", new Class[0]);
            return (String)method.invoke(requestBody, new Object[0]);
        }
        catch (Exception e) {
            throw new CdpClientException("Failed to retrieve environment CRN from request body", e);
        }
    }

    private static String sanitizeAccessToken(String accessToken) {
        if (Strings.isNullOrEmpty(accessToken)) {
            return "";
        }
        if (accessToken.length() < 16) {
            return accessToken;
        }
        return accessToken.substring(0, 16);
    }
}

