/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdp.http;

import com.cloudera.cdp.ValidationUtils;
import com.cloudera.cdp.http.DelayPolicy;
import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;

public class ExponentialBackoffDelayPolicy
implements DelayPolicy {
    private final int growthFactor;
    private final Duration base;
    private final int jitterPercentage;

    public ExponentialBackoffDelayPolicy(int growthFactor, Duration base) {
        this(growthFactor, base, 0);
    }

    public ExponentialBackoffDelayPolicy(int growthFactor, Duration base, int jitterPercentage) {
        ValidationUtils.checkArgumentAndThrow(growthFactor > 0);
        ValidationUtils.checkNotNullAndThrow(base);
        ValidationUtils.checkArgumentAndThrow(base.toMillis() > 0L);
        ValidationUtils.checkArgumentAndThrow(jitterPercentage >= 0);
        this.growthFactor = growthFactor;
        this.base = base;
        this.jitterPercentage = jitterPercentage;
    }

    @Override
    public Duration delay(int attempts) {
        ValidationUtils.checkArgumentAndThrow(attempts >= 1);
        long deterministicMillis = (long)((double)this.base.toMillis() * Math.pow(this.growthFactor, attempts - 1));
        if (this.jitterPercentage == 0) {
            return Duration.ofMillis(deterministicMillis);
        }
        long jitterRangeMillis = deterministicMillis * (long)this.jitterPercentage / 100L;
        if (jitterRangeMillis == 0L) {
            return Duration.ofMillis(deterministicMillis);
        }
        long jitterMillis = ThreadLocalRandom.current().nextLong(jitterRangeMillis) - jitterRangeMillis / 2L;
        return Duration.ofMillis(deterministicMillis + jitterMillis);
    }
}

